/*
 * Decompiled with CFR 0.152.
 */
public final class GameLogicSnake
extends GameLogic {
    private static final int LEN_MAX = 30;
    private static final int LEN_UP = 12;
    private static final int LEN_MIN = 4;
    private static final int LIFE_MAX = 3;
    private static final byte LEN_INC = 1;
    private static final int SCORE_INC = 20;
    private static final byte[] MOVE = new byte[]{6, 0, 1, 8, 1, 0, 4, 2, 3, 10, 3, 2};
    private static final int MOVE_COUNT = 4;
    private static final int MOVE_KEY = 0;
    private static final int MOVE_STEP = 1;
    private static final int MOVE_STOP = 2;
    private static final int MOVE_LEN = 3;
    private static boolean bIsOnFast = false;
    public int iStepCur = 2;
    private int iFood = -1;
    private int iLast = 3;
    private int iLen = 0;
    private int iLevel = 1;

    public GameLogicSnake() {
        super(30, 3);
    }

    protected final void save() throws Exception {
        super.save();
        GUtillIo.writeInt(this.iFood);
        GUtillIo.writeInt(this.iLen);
        GUtillIo.writeInt(this.iLast);
        GUtillIo.writeInt(this.iStepCur);
    }

    protected final void load() throws Exception {
        super.load();
        this.iFood = GUtillIo.readInt();
        this.iLen = GUtillIo.readInt();
        this.iLast = GUtillIo.readInt();
        this.iStepCur = GUtillIo.readInt();
    }

    public final void updateLevel(int level) {
        this.clear();
        this.iLevel = level - 1;
        this.placePlayer();
        this.placeFood();
    }

    public final void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.iFood == -1) {
                this.placeFood();
            }
            int posNext = this.figure_pos[0] + GameField.step[this.iStepCur];
            if (this.checkCollision()) {
                this.lifeDecr();
            } else if (posNext == this.iFood) {
                GameField.set(this.iFood, (byte)0);
                this.iFood = -1;
                GUtillArray.moveIn(this.figure_pos, this.iLast + 1, 0);
                this.figure_pos[0] = posNext;
                this.score += 20;
                ++this.iLast;
                if (this.iLast == this.iLen) {
                    this.gameup = true;
                    this.placePlayer();
                    this.placeFood();
                }
                this.figure_elem[this.iLast] = 1;
            } else {
                GUtillArray.moveIn(this.figure_pos, this.iLast, 0);
                this.figure_pos[0] = posNext;
            }
        }
    }

    public final boolean updateEvent() {
        boolean result = false;
        if (this.canUpdate()) {
            if (E.kStates[7] && !this.active) {
                this.active = true;
                result = true;
            } else if (this.active) {
                int index = 0;
                for (int i = 0; i < 4; ++i) {
                    index = 3 * i;
                    byte keyId = MOVE[index + 0];
                    int stepId = MOVE[index + 1];
                    byte stepStopId = MOVE[index + 2];
                    if (!E.kStates[keyId]) continue;
                    if (this.iStepCur == stepId) {
                        this.updateState();
                        result = true;
                        break;
                    }
                    if (this.iStepCur == stepStopId) continue;
                    this.iStepCur = stepId;
                    this.updateState();
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private final boolean checkCollision() {
        byte[] border = GameField.border(this.figure_pos[0]);
        boolean result = false;
        switch (this.iStepCur) {
            case 0: {
                if (!GUtillArray.contains(border, (byte)1)) break;
                result = true;
                break;
            }
            case 1: {
                if (!GUtillArray.contains(border, (byte)2)) break;
                result = true;
                break;
            }
            case 2: {
                if (!GUtillArray.contains(border, (byte)0)) break;
                result = true;
                break;
            }
            case 3: {
                if (!GUtillArray.contains(border, (byte)3)) break;
                result = true;
            }
        }
        if (!result) {
            for (int i = 1; i <= this.iLast; ++i) {
                if (this.figure_pos[i] != this.figure_pos[0]) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected final void placePlayer() {
        this.active = false;
        int inc = this.iLevel * 1;
        this.iLen = 12 + inc;
        this.iLast = 4 + inc - 1;
        GUtillArray.fill(this.figure_pos, -1);
        int width = 10;
        int first = 190;
        do {
            this.figure_pos[0] = 191 + GUtillMath.rnd(8);
        } while (this.figure_pos[0] == this.iFood);
        this.iStepCur = 2;
        for (int i = 0; i <= this.iLast; ++i) {
            this.figure_elem[i] = 1;
        }
    }

    private final void placeFood() {
        int rand = 0;
        int size = 200;
        this.iFood = -1;
        while (this.iFood == -1) {
            rand = GUtillMath.rnd(200);
            if (GUtillArray.contains(this.figure_pos, rand)) continue;
            this.iFood = rand;
        }
        GameField.set(this.iFood, (byte)2);
    }
}

