/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.AffineTrans;

public class FigureLayout {
    AffineTrans[] affineArray;
    AffineTrans affine;
    int scaleX;
    int scaleY;
    int centerX;
    int centerY;
    int parallelWidth;
    int parallelHeight;
    int near;
    int far;
    int angle;
    int perspectiveWidth;
    int perspectiveHeight;
    int projection;

    public FigureLayout() {
        this(null, 512, 512, 0, 0);
    }

    public FigureLayout(AffineTrans affineTrans, int n2, int n3, int n4, int n5) {
        this.setAffineTrans(affineTrans);
        this.centerX = n4;
        this.centerY = n5;
        this.setScale(n2, n3);
    }

    public final AffineTrans getAffineTrans() {
        return this.affine;
    }

    public final int getCenterX() {
        return this.centerX;
    }

    public final int getCenterY() {
        return this.centerY;
    }

    public final int getParallelHeight() {
        return this.parallelHeight;
    }

    public final int getParallelWidth() {
        return this.parallelWidth;
    }

    public final int getScaleX() {
        return this.scaleX;
    }

    public final int getScaleY() {
        return this.scaleY;
    }

    public final void selectAffineTrans(int n2) {
        if (this.affineArray == null || n2 < 0 || n2 >= this.affineArray.length) {
            throw new IllegalArgumentException();
        }
        this.affine = this.affineArray[n2];
    }

    public final void setAffineTrans(AffineTrans affineTrans) {
        if (affineTrans == null) {
            affineTrans = new AffineTrans(4096, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 4096, 0);
        }
        if (this.affineArray == null) {
            this.affineArray = new AffineTrans[1];
            this.affineArray[0] = affineTrans;
        }
        this.affine = affineTrans;
    }

    public final void setAffineTrans(AffineTrans[] affineTransArray) {
        if (affineTransArray == null) {
            throw new NullPointerException();
        }
        for (AffineTrans affineTrans : affineTransArray) {
            if (affineTrans != null) continue;
            throw new NullPointerException();
        }
        this.affineArray = affineTransArray;
    }

    public final void setAffineTransArray(AffineTrans[] affineTransArray) {
        this.setAffineTrans(affineTransArray);
    }

    public final void setCenter(int n2, int n3) {
        this.centerX = n2;
        this.centerY = n3;
    }

    public final void setParallelSize(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        this.parallelWidth = n2;
        this.parallelHeight = n3;
        this.projection = -1862270976;
    }

    public final void setPerspective(int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 1 || n3 > Short.MAX_VALUE || n4 < 1 || n4 > 2047) {
            throw new IllegalArgumentException();
        }
        this.near = n2;
        this.far = n3;
        this.angle = n4;
        this.projection = -1845493760;
    }

    public final void setPerspective(int n2, int n3, int n4, int n5) {
        if (n2 >= n3 || n2 < 1 || n3 > Short.MAX_VALUE || n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.near = n2;
        this.far = n3;
        this.perspectiveWidth = n4;
        this.perspectiveHeight = n5;
        this.projection = -1828716544;
    }

    public final void setScale(int n2, int n3) {
        this.scaleX = n2;
        this.scaleY = n3;
        this.projection = -1879048192;
    }
}

