/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.view;

import emulator.AppSettings;
import emulator.Emulator;
import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Transform3D;
import emulator.graphics3D.Vector4f;
import emulator.graphics3D.lwjgl.Emulator3D;
import emulator.graphics3D.lwjgl.GLCanvasUtil;
import emulator.graphics3D.lwjgl.LWJGLUtil;
import emulator.graphics3D.m3g.LightsCache;
import emulator.graphics3D.m3g.MeshMorph;
import emulator.graphics3D.m3g.RenderObject;
import emulator.graphics3D.m3g.RenderPipe;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.Transformable;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;
import kemnn.eP;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.ARBColorBufferFloat;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLCapabilities;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class M3GView3D
implements Runnable,
PaintListener {
    private static M3GView3D a;
    private LWJGLUtil a;
    private RenderPipe a;
    private boolean a;
    private int a;
    private int b;
    private float a;
    private float b;
    private static Camera a;
    private static Transform a;
    private static Vector a;
    private static Vector b;
    private static Canvas a;
    private static ByteBuffer a;
    private static ImageData a;
    private static GLCapabilities a;
    private static long a;
    private boolean b;

    private M3GView3D() {
        a = this;
        this.a = 0.0f;
        this.b = 1.0f;
        this.a = new LWJGLUtil();
        this.a = new RenderPipe();
    }

    public static M3GView3D getViewInstance() {
        if (a == null) {
            a = new M3GView3D();
        }
        return a;
    }

    public boolean isRenderInvisibleNodes() {
        return this.a.isRenderInvisibleNodes();
    }

    public void setRenderInvisibleNodes(boolean bl2) {
        this.a.setRenderInvisibleNodes(bl2);
    }

    public final void setXray(boolean bl2) {
        this.a = bl2;
    }

    public final void setViewport(int n2, int n3) {
        this.a = n2;
        this.b = n3;
    }

    private void a() {
        GL11.glViewport(0, 0, this.a, this.b);
        GL11.glScissor(0, 0, this.a, this.b);
    }

    private void b() {
        GL11.glDepthRange(this.a, this.b);
    }

    public final void clearBackground(Background background) {
        this.a();
        this.b();
        GL11.glClearDepth(1.0);
        GL11.glDepthMask(true);
        GL11.glColorMask(true, true, true, true);
        int n2 = background != null && !this.a ? background.getColor() : 0;
        GL11.glClearColor(G3DUtils.getFloatColor(n2, 16), G3DUtils.getFloatColor(n2, 8), G3DUtils.getFloatColor(n2, 0), G3DUtils.getFloatColor(n2, 24));
        GL11.glClear(16640);
        if (background != null && !this.a) {
            GL11.glClear(background.isColorClearEnabled() ? 16384 : 0);
            this.a(background);
        } else {
            GL11.glClear(16384);
        }
    }

    private void a(Background background) {
        if (background != null && background.getImage() != null && background.getCropWidth() > 0 && background.getCropHeight() > 0) {
            GL11.glDisable(2896);
            GL11.glDisable(2912);
            int n2 = background.getImage().getFormat() == 99 ? 6407 : 6408;
            int n3 = background.getImage().getWidth();
            int n4 = background.getImage().getHeight();
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            float f2 = this.a;
            float f3 = this.b;
            float f4 = f2 / (float)background.getCropWidth();
            float f5 = f3 / (float)background.getCropHeight();
            float f6 = f4 * (float)n3;
            float f7 = f5 * (float)n4;
            float f8 = -f2 * (float)background.getCropX() / (float)background.getCropWidth() - f2 / 2.0f;
            float f9 = f3 * (float)background.getCropY() / (float)background.getCropHeight() + f3 / 2.0f;
            int n5 = 1;
            int n6 = 1;
            if (background.getImageModeX() == 33) {
                float f10;
                f8 %= f6;
                if (f10 > 0.0f) {
                    f8 -= f6;
                }
                n5 = (int)(2.5f + f2 / f6);
                f8 -= (float)(n5 / 2) * f6;
            }
            if (background.getImageModeY() == 33) {
                f9 %= f7;
                n6 = (int)(2.5f + f3 / f7);
                f9 += (float)(n6 / 2) * f7;
            }
            GL11.glPixelStorei(3314, n3);
            GL11.glPixelStorei(3315, 0);
            GL11.glPixelStorei(3316, 0);
            GL11.glDepthFunc(519);
            GL11.glDepthMask(false);
            GL11.glPixelZoom(f4, -f5);
            ByteBuffer byteBuffer = this.a.getImageBuffer(background.getImage().getImageData());
            for (int i2 = 0; i2 < n6; ++i2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                    GL11.glBitmap(0, 0, 0.0f, 0.0f, f8 + (float)i3 * f6, f9 - (float)i2 * f7, byteBuffer);
                    GL11.glDrawPixels(n3, n4, n2, 5121, byteBuffer);
                }
            }
            GL11.glPixelStorei(3314, 0);
        }
    }

    public final void method368(Node node, Transform transform) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!(node instanceof Sprite3D || node instanceof Mesh || node instanceof Group)) {
            throw new IllegalArgumentException();
        }
        this.a.pushRenderNode(node, transform == null ? new Transform() : transform);
        this.c();
    }

    private void c() {
        this.a.sortNodes();
        for (int i2 = 0; i2 < this.a.getSize(); ++i2) {
            RenderObject renderObject = this.a.getRenderObj(i2);
            if (renderObject.node instanceof Mesh) {
                Mesh mesh = (Mesh)renderObject.node;
                IndexBuffer indexBuffer = mesh.getIndexBuffer(renderObject.submeshIndex);
                Appearance appearance = mesh.getAppearance(renderObject.submeshIndex);
                if (indexBuffer == null || appearance == null) continue;
                VertexBuffer vertexBuffer = MeshMorph.getViewInstance().getMorphedVertexBuffer(mesh);
                this.a(vertexBuffer, indexBuffer, appearance, renderObject.trans, mesh.getScope(), renderObject.alphaFactor);
                continue;
            }
            this.a((Sprite3D)renderObject.node, renderObject.trans, renderObject.alphaFactor);
        }
        this.a.clear();
        MeshMorph.getViewInstance().clearCache();
    }

    private void a(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Transform transform, int n2, float f2) {
        if ((a.getScope() & n2) != 0) {
            this.a();
            this.b();
            this.f();
            this.a(a, b, n2);
            if (transform != null) {
                Transform transform2 = new Transform();
                transform2.set(transform);
                transform2.transpose();
                GL11.glMultMatrixf(this.a.getFloatBuffer(((Transform3D)transform2.getImpl()).m_matrix));
            }
            this.a(appearance, false);
            this.a(vertexBuffer, indexBuffer, appearance, f2);
        }
    }

    private void a(Sprite3D sprite3D, Transform transform, float f2) {
        block19: {
            int n2;
            ByteBuffer byteBuffer;
            int[] nArray;
            block26: {
                int n3;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                Transform transform2;
                Transform transform3;
                block25: {
                    float f9;
                    block24: {
                        int[] nArray2;
                        block23: {
                            boolean bl2;
                            block22: {
                                block21: {
                                    block20: {
                                        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                                        Vector4f vector4f2 = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
                                        Vector4f vector4f3 = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
                                        transform3 = new Transform(a);
                                        transform3.postMultiply(transform);
                                        Transform3D transform3D = (Transform3D)transform3.getImpl();
                                        transform3D.transform(vector4f);
                                        transform3D.transform(vector4f2);
                                        transform3D.transform(vector4f3);
                                        Vector4f vector4f4 = new Vector4f(vector4f);
                                        vector4f.mul(1.0f / vector4f.w);
                                        vector4f2.mul(1.0f / vector4f2.w);
                                        vector4f3.mul(1.0f / vector4f3.w);
                                        vector4f2.sub(vector4f);
                                        vector4f3.sub(vector4f);
                                        Vector4f vector4f5 = new Vector4f(vector4f2.length(), 0.0f, 0.0f, 0.0f);
                                        Vector4f vector4f6 = new Vector4f(0.0f, vector4f3.length(), 0.0f, 0.0f);
                                        vector4f5.add(vector4f4);
                                        vector4f6.add(vector4f4);
                                        transform2 = new Transform();
                                        a.getProjection(transform2);
                                        transform3D = (Transform3D)transform2.getImpl();
                                        transform3D.transform(vector4f4);
                                        transform3D.transform(vector4f5);
                                        transform3D.transform(vector4f6);
                                        if (!(vector4f4.w > 0.0f) || !(-vector4f4.w < vector4f4.z) || !(vector4f4.z <= vector4f4.w)) break block19;
                                        vector4f4.mul(1.0f / vector4f4.w);
                                        vector4f5.mul(1.0f / vector4f5.w);
                                        vector4f6.mul(1.0f / vector4f6.w);
                                        vector4f5.sub(vector4f4);
                                        vector4f6.sub(vector4f4);
                                        boolean bl3 = sprite3D.isScaled();
                                        nArray2 = new int[]{sprite3D.getCropX(), sprite3D.getCropY(), sprite3D.getCropWidth(), sprite3D.getCropHeight()};
                                        boolean bl4 = nArray2[2] < 0;
                                        bl2 = nArray2[3] < 0;
                                        nArray2[2] = Math.abs(nArray2[2]);
                                        nArray2[3] = Math.abs(nArray2[3]);
                                        f8 = 1.0f;
                                        f7 = 1.0f;
                                        f6 = (bl4 ? nArray2[2] : -nArray2[2]) / 2;
                                        f5 = (bl2 ? -nArray2[3] : nArray2[3]) / 2;
                                        if (!bl3) {
                                            if (bl4) {
                                                f8 = -1.0f;
                                            }
                                            if (bl2) {
                                                f7 = -1.0f;
                                            }
                                            f4 = nArray2[2];
                                            f3 = nArray2[3];
                                        } else {
                                            f8 = vector4f5.length() * (float)this.a * 0.5f;
                                            f7 = vector4f6.length() * (float)this.b * 0.5f;
                                            f4 = f8;
                                            f3 = f7;
                                            f6 = -f8 / 2.0f;
                                            f5 = f7 / 2.0f;
                                            if (bl4) {
                                                f6 += f8;
                                            }
                                            if (bl2) {
                                                f5 -= f7;
                                            }
                                            f8 /= bl4 ? -((float)nArray2[2]) : (float)nArray2[2];
                                            f7 /= bl2 ? -((float)nArray2[3]) : (float)nArray2[3];
                                        }
                                        nArray = new int[4];
                                        if (!G3DUtils.intersectRectangle(nArray2[0], nArray2[1], nArray2[2], nArray2[3], 0, 0, sprite3D.getImage().getWidth(), sprite3D.getImage().getHeight(), nArray)) break block19;
                                        if (bl4) break block20;
                                        f9 = f6 - f8 * (float)(nArray2[0] - nArray[0]);
                                        break block21;
                                    }
                                    if (nArray2[0] <= 0) break block22;
                                    f9 = f6 + f8 * (float)(nArray2[0] - nArray[0]);
                                }
                                f6 = f9;
                            }
                            if (bl2) break block23;
                            f9 = f5 + f7 * (float)(nArray2[1] - nArray[1]);
                            break block24;
                        }
                        if (nArray2[1] <= 0) break block25;
                        f9 = f5 - f7 * (float)(nArray2[1] - nArray[1]);
                    }
                    f5 = f9;
                }
                Transform transform4 = new Transform();
                transform4.postScale((float)this.a / ((float)this.a + f4), (float)this.b / ((float)this.b + f3), 1.0f);
                transform4.postMultiply(transform2);
                transform2.set(transform4);
                int n4 = (int)(0.0f - f4 / 2.0f);
                int n5 = (int)(0.0f - f3 / 2.0f);
                int n6 = (int)((float)this.a + f4);
                int n7 = (int)((float)this.b + f3);
                transform2.transpose();
                transform3.transpose();
                GL11.glViewport(n4, this.b - n5 - n7, n6, n7);
                GL11.glMatrixMode(5889);
                GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform2.getImpl()).m_matrix));
                GL11.glMatrixMode(5888);
                GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform3.getImpl()).m_matrix));
                GL11.glDisable(2896);
                byteBuffer = this.a.getImageBuffer(sprite3D.getImage().getImageData());
                GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glPixelStorei(3314, sprite3D.getImage().getWidth());
                GL11.glPixelStorei(3315, nArray[1]);
                GL11.glPixelStorei(3316, nArray[0]);
                GL11.glBitmap(0, 0, 0.0f, 0.0f, f6, f5, byteBuffer);
                GL11.glPixelZoom(f8, -f7);
                n2 = 6407;
                switch (sprite3D.getImage().getFormat()) {
                    case 96: {
                        n3 = 6406;
                        break;
                    }
                    case 97: {
                        n3 = 6409;
                        break;
                    }
                    case 98: {
                        n3 = 6410;
                        break;
                    }
                    case 99: {
                        n3 = 6407;
                        break;
                    }
                    case 100: {
                        n3 = 6408;
                        break;
                    }
                    default: {
                        break block26;
                    }
                }
                n2 = n3;
            }
            this.a(sprite3D.getAppearance(), true);
            GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)(255.0f * f2));
            GL11.glDisableClientState(32886);
            GL11.glDrawPixels(nArray[2], nArray[3], n2, 5121, byteBuffer);
            GL11.glPixelStorei(3314, 0);
            GL11.glPixelStorei(3315, 0);
            GL11.glPixelStorei(3316, 0);
        }
    }

    public final boolean init(Canvas canvas) {
        a = canvas;
        try {
            GLCanvasUtil.makeCurrent(canvas);
            this.d();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (a == 0L) {
                if (!GLFW.glfwInit()) {
                    return false;
                }
                GLFW.glfwDefaultWindowHints();
                GLFW.glfwWindowHint(131076, 0);
                GLFW.glfwWindowHint(131075, 1);
                a = GLFW.glfwCreateWindow(400, 300, "M3GView", 0L, 0L);
                if (a == 0L) {
                    return false;
                }
            }
            GLFW.glfwMakeContextCurrent(a);
            this.d();
            eP.a().syncExec((Runnable)this);
        }
        this.e();
        return true;
    }

    private void d() {
        if (a == null) {
            a = GL.createCapabilities();
            return;
        }
        try {
            a = GL.getCapabilities();
        }
        catch (Exception exception) {
            a = GL.createCapabilities();
        }
    }

    private void e() {
        GL11.glEnable(3089);
        GL11.glEnable(2977);
        GL11.glPixelStorei(3317, 1);
        GL11.glDisable(2832);
        GL11.glDisable(2848);
        GL11.glDisable(2881);
        GL11.glEnable(3024);
    }

    public final void setCurrent(int n2, int n3) throws Exception {
        if (this.b != n2 || this.b != n3) {
            this.a = n2;
            this.b = n3;
            if (a != 0L) {
                a = new ImageData(n2, n3, 32, Emulator3D.swtPalleteData);
                a = BufferUtils.createByteBuffer(n2 * n3 * 4);
                GLFW.glfwSetWindowSize(a, n2, n3);
            }
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        if (a != null) {
            Image image = new Image(null, a);
            gC.drawImage(image, 0, 0);
            image.dispose();
        }
    }

    public void swapBuffers() {
        GL11.glFinish();
        if (a != 0L) {
            a.rewind();
            GL11.glReadPixels(0, 0, this.a, this.b, 6408, 5121, a);
            int n2 = M3GView3D.a.width << 2;
            int n3 = M3GView3D.a.data.length - n2;
            for (int i2 = M3GView3D.a.height; i2 > 0; --i2) {
                a.get(M3GView3D.a.data, n3, n2);
                n3 -= n2;
            }
        }
        eP.a().syncExec((Runnable)this);
    }

    @Override
    public void run() {
        if (a != 0L && !this.b) {
            this.b = true;
            a.addPaintListener((PaintListener)this);
            return;
        }
        try {
            if (a.isDisposed()) {
                return;
            }
            if (a == 0L) {
                GLCanvasUtil.swapBuffers(a);
            }
            a.redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void releaseContext() {
        if (a != 0L) {
            GLFW.glfwMakeContextCurrent(0L);
            return;
        }
        try {
            GLCanvasUtil.releaseContext(a);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setCamera(Camera camera, Transform transform) {
        if (transform != null) {
            a.set(transform);
            ((Transform3D)a.getImpl()).invert();
        } else {
            a.setIdentity();
        }
        a = camera;
    }

    public static int method381(Light light, Transform transform) {
        if (light == null) {
            throw new NullPointerException();
        }
        a.add(light);
        if (transform == null) {
            b.add(new Transform());
        } else {
            b.add(new Transform(transform));
        }
        return a.size();
    }

    public static void method388() {
        a.clear();
        b.clear();
    }

    public final void method374(World world) {
        M3GView3D.method388();
        this.a(world, world);
    }

    private void a(World world, Group group) {
        Transform transform = new Transform();
        for (int i2 = 0; i2 < group.getChildCount(); ++i2) {
            Node node = group.getChild(i2);
            if (node instanceof Light && node.getTransformTo(world, transform)) {
                a.add(node);
                b.add(new Transform(transform));
                continue;
            }
            if (!(node instanceof Group)) continue;
            this.a(world, (Group)node);
        }
    }

    private void a(Appearance appearance, boolean bl2) {
        if (!bl2) {
            this.a(appearance.getPolygonMode());
        }
        this.a(appearance.getCompositingMode());
        if (!bl2) {
            this.a(appearance.getMaterial());
        }
        this.a(appearance.getFog());
    }

    private void a(PolygonMode polygonMode) {
        if (polygonMode == null) {
            polygonMode = new PolygonMode();
        }
        GL11.glPolygonMode(1032, this.a ? 6913 : 6914);
        int n2 = polygonMode.getCulling();
        if (n2 == 162) {
            GL11.glDisable(2884);
        } else {
            GL11.glEnable(2884);
            GL11.glCullFace(n2 == 161 ? 1028 : 1029);
        }
        GL11.glShadeModel(polygonMode.getShading() == 164 ? 7424 : 7425);
        GL11.glFrontFace(polygonMode.getWinding() == 169 ? 2304 : 2305);
        GL11.glLightModelf(2898, polygonMode.isTwoSidedLightingEnabled() ? 1.0f : 0.0f);
        GL11.glLightModelf(2897, polygonMode.isLocalCameraLightingEnabled() ? 1.0f : 0.0f);
        boolean bl2 = polygonMode.isPerspectiveCorrectionEnabled();
        if (AppSettings.m3gForcePerspectiveCorrection) {
            bl2 = true;
        }
        GL11.glHint(3152, bl2 ? 4354 : 4353);
    }

    private void a(CompositingMode compositingMode) {
        if (compositingMode == null) {
            compositingMode = new CompositingMode();
        }
        GL11.glEnable(2929);
        GL11.glDepthMask(compositingMode.isDepthWriteEnabled());
        GL11.glDepthFunc(compositingMode.isDepthTestEnabled() ? 515 : 519);
        GL11.glColorMask(compositingMode.isColorWriteEnabled(), compositingMode.isColorWriteEnabled(), compositingMode.isColorWriteEnabled(), compositingMode.isAlphaWriteEnabled());
        GL11.glAlphaFunc(518, compositingMode.getAlphaThreshold());
        if (compositingMode.getAlphaThreshold() == 0.0f) {
            GL11.glDisable(3008);
        } else {
            GL11.glEnable(3008);
        }
        if (compositingMode.getBlending() == 68) {
            GL11.glDisable(3042);
        } else {
            GL11.glEnable(3042);
        }
        switch (compositingMode.getBlending()) {
            case 64: {
                GL11.glBlendFunc(770, 771);
                break;
            }
            case 65: {
                GL11.glBlendFunc(770, 1);
                break;
            }
            case 66: {
                GL11.glBlendFunc(774, 0);
                break;
            }
            case 67: {
                GL11.glBlendFunc(774, 768);
                break;
            }
            case 68: {
                GL11.glBlendFunc(1, 0);
                break;
            }
        }
        GL11.glPolygonOffset(compositingMode.getDepthOffsetFactor(), compositingMode.getDepthOffsetUnits());
        if (compositingMode.getDepthOffsetFactor() == 0.0f && compositingMode.getDepthOffsetUnits() == 0.0f) {
            GL11.glDisable(this.a ? 10754 : 32823);
        } else {
            GL11.glEnable(this.a ? 10754 : 32823);
        }
    }

    private void a(Material material) {
        if (material != null) {
            GL11.glEnable(2896);
            float[] fArray = new float[4];
            G3DUtils.fillFloatColor(fArray, material.getColor(1024));
            GL11.glMaterialfv(1032, 4608, this.a.getFloatBuffer(fArray));
            G3DUtils.fillFloatColor(fArray, material.getColor(2048));
            GL11.glMaterialfv(1032, 4609, this.a.getFloatBuffer(fArray));
            G3DUtils.fillFloatColor(fArray, material.getColor(4096));
            GL11.glMaterialfv(1032, 5632, this.a.getFloatBuffer(fArray));
            G3DUtils.fillFloatColor(fArray, material.getColor(8192));
            GL11.glMaterialfv(1032, 4610, this.a.getFloatBuffer(fArray));
            GL11.glMaterialf(1032, 5633, material.getShininess());
            if (material.isVertexColorTrackingEnabled()) {
                GL11.glEnable(2903);
                GL11.glColorMaterial(1032, 5634);
            } else {
                GL11.glDisable(2903);
            }
        } else {
            GL11.glDisable(2896);
        }
    }

    private void a(Fog fog) {
        if (fog != null && !this.a) {
            GL11.glEnable(2912);
            GL11.glFogi(2917, fog.getMode() == 81 ? 9729 : 2048);
            float[] fArray = new float[4];
            G3DUtils.fillFloatColor(fArray, fog.getColor());
            fArray[3] = 1.0f;
            GL11.glFogfv(2918, this.a.getFloatBuffer(fArray));
            GL11.glFogf(2915, fog.getNearDistance());
            GL11.glFogf(2916, fog.getFarDistance());
            GL11.glFogf(2914, fog.getDensity());
        } else {
            GL11.glDisable(2912);
        }
    }

    private void a(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, float f2) {
        Object object;
        VertexArray vertexArray = vertexBuffer.getColors();
        if (vertexArray == null) {
            int n2 = vertexBuffer.getDefaultColor();
            GL11.glColor4ub((byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)((float)(n2 >> 24 & 0xFF) * f2));
            GL11.glDisableClientState(32886);
        } else {
            GL11.glEnableClientState(32886);
            if (vertexArray.getComponentType() == 1) {
                byte[] byArray = vertexArray.getByteValues();
                GL11.glColorPointer(f2 == 1.0f ? vertexArray.getComponentCount() : 4, 5121, 0, this.a.getColorBuffer(byArray, f2, vertexArray.getVertexCount()));
            }
        }
        VertexArray vertexArray2 = vertexBuffer.getNormals();
        if (vertexArray2 != null && appearance.getMaterial() != null) {
            GL11.glEnableClientState(32885);
            GL11.glEnable(2977);
            if (vertexArray2.getComponentType() == 1) {
                GL11.glNormalPointer(5120, 0, this.a.getNormalBuffer(vertexArray2.getByteValues()));
            } else {
                GL11.glNormalPointer(5122, 0, this.a.getNormalBuffer(vertexArray2.getShortValues()));
            }
        } else {
            GL11.glDisableClientState(32885);
        }
        float[] fArray = new float[4];
        VertexArray vertexArray3 = vertexBuffer.getPositions(fArray);
        GL11.glEnableClientState(32884);
        if (vertexArray3.getComponentType() == 1) {
            object = vertexArray3.getByteValues();
            GL11.glVertexPointer(vertexArray3.getComponentCount(), 5122, 0, this.a.getVertexBuffer((byte[])object));
        } else {
            object = vertexArray3.getShortValues();
            GL11.glVertexPointer(vertexArray3.getComponentCount(), 5122, 0, this.a.getVertexBuffer((short[])object));
        }
        GL11.glMatrixMode(5888);
        GL11.glTranslatef(fArray[1], fArray[2], fArray[3]);
        GL11.glScalef(fArray[0], fArray[0], fArray[0]);
        object = (TriangleStripArray)indexBuffer;
        int n3 = ((TriangleStripArray)object).getStripCount();
        if (appearance != null && !this.a) {
            Object object2;
            int n4;
            IntBuffer intBuffer = BufferUtils.createIntBuffer(10);
            GL11.glGenTextures(intBuffer);
            for (n4 = 0; n4 < 10; ++n4) {
                object2 = appearance.getTexture(n4);
                VertexArray vertexArray4 = vertexBuffer.getTexCoords(n4, fArray);
                if (object2 == null || vertexArray4 == null) continue;
                Image2D image2D = ((Texture2D)object2).getImage();
                fArray[3] = 0.0f;
                if (!M3GView3D.a()) {
                    GL13.glActiveTexture(33984 + n4);
                    GL13.glClientActiveTexture(33984 + n4);
                }
                GL11.glEnable(3553);
                GL11.glBindTexture(3553, intBuffer.get(n4));
                int n5 = 0;
                switch (((Texture2D)object2).getBlending()) {
                    case 224: {
                        n5 = 260;
                        break;
                    }
                    case 225: {
                        n5 = 3042;
                        break;
                    }
                    case 226: {
                        n5 = 8449;
                        break;
                    }
                    case 227: {
                        n5 = 8448;
                        break;
                    }
                    case 228: {
                        n5 = 7681;
                        break;
                    }
                }
                GL11.glTexEnvi(8960, 8704, n5);
                float[] fArray2 = new float[4];
                G3DUtils.fillFloatColor(fArray2, ((Texture2D)object2).getBlendColor());
                fArray2[3] = 1.0f;
                GL11.glTexEnvfv(8960, 8705, this.a.getFloatBuffer(fArray2));
                int n6 = 6407;
                switch (image2D.getFormat()) {
                    case 96: {
                        n6 = 6406;
                        break;
                    }
                    case 97: {
                        n6 = 6409;
                        break;
                    }
                    case 98: {
                        n6 = 6410;
                        break;
                    }
                    case 99: {
                        n6 = 6407;
                        break;
                    }
                    case 100: {
                        n6 = 6408;
                    }
                }
                GL11.glTexImage2D(3553, 0, n6, image2D.getWidth(), image2D.getHeight(), 0, n6, 5121, this.a.getImageBuffer(image2D.getImageData()));
                GL11.glTexParameterf(3553, 10242, ((Texture2D)object2).getWrappingS() == 240 && !M3GView3D.a() ? 33071.0f : 10497.0f);
                GL11.glTexParameterf(3553, 10243, ((Texture2D)object2).getWrappingT() == 240 && !M3GView3D.a() ? 33071.0f : 10497.0f);
                int n7 = ((Texture2D)object2).getLevelFilter();
                int n8 = ((Texture2D)object2).getImageFilter();
                if (M3GView3D.a() || AppSettings.m3gMipmapping != 1) {
                    // empty if block
                }
                n7 = 208;
                if (!M3GView3D.a()) {
                    GL11.glTexParameteri(3553, 34046, 1);
                }
                if (AppSettings.m3gTexFilter == 1) {
                    n8 = 210;
                } else if (AppSettings.m3gTexFilter == 2) {
                    n8 = 209;
                }
                int n9 = 0;
                int n10 = 0;
                if (n8 == 210) {
                    n9 = 9728;
                    n10 = 9728;
                    if (n7 == 210) {
                        n10 = 9984;
                    } else if (n7 == 209) {
                        n10 = 9986;
                    }
                } else if (n8 == 209) {
                    n9 = 9729;
                    n10 = 9729;
                    if (n7 == 210) {
                        n10 = 9985;
                    } else if (n7 == 209) {
                        n10 = 9987;
                    }
                }
                GL11.glTexParameteri(3553, 10241, n10);
                GL11.glTexParameteri(3553, 10240, n9);
                GL11.glEnableClientState(32888);
                ShortBuffer shortBuffer = vertexArray4.getComponentType() == 1 ? this.a.getTexCoordBuffer(vertexArray4.getByteValues(), n4) : this.a.getTexCoordBuffer(vertexArray4.getShortValues(), n4);
                GL11.glTexCoordPointer(vertexArray4.getComponentCount(), 5122, 0, shortBuffer);
                Transform transform = new Transform();
                ((Transformable)object2).getCompositeTransform(transform);
                transform.transpose();
                GL11.glMatrixMode(5890);
                GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
                GL11.glTranslatef(fArray[1], fArray[2], fArray[3]);
                GL11.glScalef(fArray[0], fArray[0], fArray[0]);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                object2 = ((TriangleStripArray)object).getIndexStrip(n4);
                GL11.glDrawElements(5, this.a.getElementsBuffer((int[])object2));
            }
            if (!M3GView3D.a()) {
                for (n4 = 0; n4 < 10; ++n4) {
                    if (!GL11.glIsTexture(intBuffer.get(n4))) continue;
                    GL13.glActiveTexture(33984 + n4);
                    GL13.glClientActiveTexture(33984 + n4);
                    GL11.glDisableClientState(32888);
                    GL11.glDisable(3553);
                }
            }
            GL11.glDeleteTextures(intBuffer);
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                int[] nArray = ((TriangleStripArray)object).getIndexStrip(i2);
                GL11.glDrawElements(5, this.a.getElementsBuffer(nArray));
            }
        }
        int n11 = GL11.glGetError();
        if (n11 != 0) {
            Emulator.getEmulator().getLogStream().println("M3GView GL Error: " + n11);
        }
    }

    private static boolean a() {
        return !M3GView3D.a.OpenGL12;
    }

    private void f() {
        if (a != null) {
            Transform transform = new Transform();
            a.getProjection(transform);
            transform.transpose();
            GL11.glMatrixMode(5889);
            GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
            transform.set(a);
            transform.transpose();
            GL11.glMatrixMode(5888);
            GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
        }
    }

    private void a(Vector vector2, Vector vector3, int n2) {
        int n3;
        for (n3 = 0; n3 < 8; ++n3) {
            GL11.glDisable(16384 + n3);
        }
        if (!M3GView3D.a() && M3GView3D.a.GL_ARB_color_buffer_float) {
            ARBColorBufferFloat.glClampColorARB(35098, AppSettings.m3gDisableLightClamp ? 0 : 1);
        }
        n3 = 0;
        Transform transform = new Transform();
        for (int i2 = 0; i2 < vector2.size() && n3 < 8; ++i2) {
            Light light = (Light)vector2.get(i2);
            if (light == null || (light.getScope() & n2) == 0 || !this.a.isVisible(light)) continue;
            Transform transform2 = (Transform)vector3.get(i2);
            if (transform2 != null) {
                transform.set(transform2);
            } else {
                transform.setIdentity();
            }
            transform.transpose();
            GL11.glPushMatrix();
            GL11.glMatrixMode(5888);
            GL11.glMultMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
            int n4 = 16384 + n3;
            ++n3;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            GL11.glLightfv(n4, 4608, this.a.getFloatBuffer(fArray));
            GL11.glLightfv(n4, 4609, this.a.getFloatBuffer(fArray));
            GL11.glLightfv(n4, 4610, this.a.getFloatBuffer(fArray));
            GL11.glLightf(n4, 4615, 1.0f);
            GL11.glLightf(n4, 4616, 0.0f);
            GL11.glLightf(n4, 4617, 0.0f);
            GL11.glLightf(n4, 4614, 180.0f);
            GL11.glLightf(n4, 4613, 0.0f);
            float[] fArray2 = light.getMode() == 129 ? LightsCache.POSITIVE_Z_AXIS : LightsCache.LOCAL_ORIGIN;
            GL11.glLightfv(n4, 4611, this.a.getFloatBuffer(fArray2));
            G3DUtils.fillFloatColor(fArray, light.getColor());
            float f2 = light.getIntensity();
            fArray[0] = fArray[0] * f2;
            fArray[1] = fArray[1] * f2;
            fArray[2] = fArray[2] * f2;
            fArray[3] = 1.0f;
            int n5 = light.getMode();
            if (n5 == 128) {
                GL11.glLightfv(n4, 4608, this.a.getFloatBuffer(fArray));
            } else {
                GL11.glLightfv(n4, 4609, this.a.getFloatBuffer(fArray));
                GL11.glLightfv(n4, 4610, this.a.getFloatBuffer(fArray));
            }
            if (n5 == 131) {
                GL11.glLightfv(n4, 4612, this.a.getFloatBuffer(LightsCache.NEGATIVE_Z_AXIS));
                GL11.glLightf(n4, 4614, light.getSpotAngle());
                GL11.glLightf(n4, 4613, light.getSpotExponent());
            }
            if (n5 == 131 || n5 == 130) {
                GL11.glLightf(n4, 4615, light.getConstantAttenuation());
                GL11.glLightf(n4, 4616, light.getLinearAttenuation());
                GL11.glLightf(n4, 4617, light.getQuadraticAttenuation());
            }
            GL11.glEnable(n4);
            GL11.glPopMatrix();
        }
    }

    public final void drawGrid(float f2) {
        this.a();
        this.b();
        this.f();
        GL11.glPolygonMode(1032, 6914);
        GL11.glDisable(2884);
        GL11.glShadeModel(7425);
        GL11.glFrontFace(2305);
        GL11.glEnable(2929);
        GL11.glDepthFunc(519);
        GL11.glDisable(3008);
        GL11.glDisable(3042);
        GL11.glDisable(32823);
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glColor4ub((byte)70, (byte)121, (byte)-80, (byte)-1);
        GL11.glDisableClientState(32886);
        GL11.glDisableClientState(32885);
        float f3 = f2 * 5.0f;
        boolean bl2 = true;
        GL11.glMatrixMode(5888);
        GL11.glBegin(7);
        float f4 = -f3;
        block0: while (true) {
            float f5 = f4;
            if (f4 >= f3) {
                GL11.glEnd();
                return;
            }
            f4 = -f3;
            while (true) {
                float f6 = f4;
                if (f4 >= f3) {
                    bl2 = !bl2;
                    f4 = f5 + f2;
                    continue block0;
                }
                if (bl2) {
                    GL11.glVertex3f(f5, 0.0f, f6);
                    GL11.glVertex3f(f5 + f2, 0.0f, f6);
                    GL11.glVertex3f(f5 + f2, 0.0f, f6 + f2);
                    GL11.glVertex3f(f5, 0.0f, f6 + f2);
                }
                bl2 = !bl2;
                f4 = f6 + f2;
            }
            break;
        }
    }

    public final void drawAxis() {
        this.a();
        this.b();
        this.f();
        GL11.glPolygonMode(1032, 6914);
        GL11.glDisable(2884);
        GL11.glShadeModel(7425);
        GL11.glFrontFace(2305);
        GL11.glEnable(2929);
        GL11.glDepthFunc(519);
        GL11.glDisable(3008);
        GL11.glDisable(3042);
        GL11.glDisable(32823);
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glDisableClientState(32886);
        GL11.glDisableClientState(32885);
        GL11.glMatrixMode(5888);
        GL11.glColor4ub((byte)-1, (byte)0, (byte)0, (byte)-1);
        GL11.glBegin(1);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glVertex3f(1.0f, 0.0f, 0.0f);
        GL11.glEnd();
        GL11.glBegin(6);
        GL11.glVertex3f(1.3f, 0.0f, 0.0f);
        GL11.glVertex3f(1.0f, 0.1f, 0.1f);
        GL11.glVertex3f(1.0f, -0.1f, 0.1f);
        GL11.glVertex3f(1.0f, -0.1f, -0.1f);
        GL11.glVertex3f(1.0f, 0.1f, -0.1f);
        GL11.glVertex3f(1.0f, 0.1f, 0.1f);
        GL11.glEnd();
        GL11.glColor4ub((byte)0, (byte)-1, (byte)0, (byte)-1);
        GL11.glBegin(1);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glVertex3f(0.0f, 1.0f, 0.0f);
        GL11.glEnd();
        GL11.glBegin(6);
        GL11.glVertex3f(0.0f, 1.3f, 0.0f);
        GL11.glVertex3f(0.1f, 1.0f, 0.1f);
        GL11.glVertex3f(-0.1f, 1.0f, 0.1f);
        GL11.glVertex3f(-0.1f, 1.0f, -0.1f);
        GL11.glVertex3f(0.1f, 1.0f, -0.1f);
        GL11.glVertex3f(0.1f, 1.0f, 0.1f);
        GL11.glEnd();
        GL11.glColor4ub((byte)0, (byte)0, (byte)-1, (byte)-1);
        GL11.glBegin(1);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glVertex3f(0.0f, 0.0f, 1.0f);
        GL11.glEnd();
        GL11.glBegin(6);
        GL11.glVertex3f(0.0f, 0.0f, 1.3f);
        GL11.glVertex3f(0.1f, 0.1f, 1.0f);
        GL11.glVertex3f(-0.1f, 0.1f, 1.0f);
        GL11.glVertex3f(-0.1f, -0.1f, 1.0f);
        GL11.glVertex3f(0.1f, -0.1f, 1.0f);
        GL11.glVertex3f(0.1f, 0.1f, 1.0f);
        GL11.glEnd();
    }

    static {
        a = new Transform();
        a = new Vector();
        b = new Vector();
    }
}

