/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Emulator;
import emulator.Utils;
import emulator.ui.swt.devutils.ClasspathEntry;
import emulator.ui.swt.devutils.a;
import emulator.ui.swt.devutils.idea.ProjectConfigGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectGenerator {
    public static final String PROGUARD_LOCAL_CFG = "proguard-local.cfg";
    public static final String PROGUARD_GLOBAL_CFG = "proguard.cfg";

    public static String create(String string, String string2, String string3, String string4) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        Path path = Paths.get(string, string2).toAbsolutePath();
        ProjectGenerator.createDirectories(path);
        Files.write(path.resolve(".gitignore"), "### IntelliJ IDEA ###\nout/\n!**/src/main/**/out/\n!**/src/test/**/out/\nproguard-local.cfg\n.idea/runConfigurations\n\n### Eclipse ###\n.apt_generated\n.classpath\n.factorypath\n.project\n.settings\nbin/\ndeployed/\n\n### NetBeans ###\n/nbproject/private/\n/nbbuild/\n/dist/\n/nbdist/\n/.nb-gradle/\n\n### VS Code ###\n.vscode/\n\n### Mac OS ###\n.DS_Store".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        ProjectConfigGenerator.generateIML(null, path.resolve(string2 + ".iml"));
        ProjectGenerator.generateProGuardConfig(path, string2, new ClasspathEntry[0]);
        Files.write(path.resolve("META-INF").resolve("MANIFEST.MF"), ProjectConfigGenerator.buildManifest(string2, string3, string4).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String string5 = ProjectGenerator.generateDummyMidlet(path, string3);
        ProjectGenerator.generateMiscXmls(path, string2);
        ProjectGenerator.generateBuildConfigs(path, string2, false);
        ProjectGenerator.generateRunConfigs(path, string2, new a[]{new a(string3, string4)}, false);
        return string5;
    }

    public static boolean restore(String string) throws IOException, InterruptedException {
        a[] aArray;
        Path path = Paths.get(string, new String[0]);
        Path path2 = path.resolve("Application Descriptor");
        Path path3 = path.resolve("META-INF").resolve("MANIFEST.MF");
        Path path4 = ClasspathEntry.findImlAt(path);
        ProjectGenerator.createDirectories(path);
        boolean bl2 = Files.exists(path2, new LinkOption[0]);
        if (Files.exists(path3, new LinkOption[0])) {
            if (bl2) {
                System.out.println("Warning: both \"Application Descriptor\" and \"MANIFEST.MF\" exist. Run configurations will be updated based on \"Application Descriptor\".");
                ProjectGenerator.fixManifestWithVersion(path3);
                ProjectGenerator.fixManifestWithVersion(path2);
                aArray = a.a(path2);
            } else {
                ProjectGenerator.fixManifestWithVersion(path3);
                aArray = a.a(path3);
            }
        } else if (bl2) {
            ProjectGenerator.fixManifestWithVersion(path2);
            aArray = a.a(path2);
        } else {
            throw new IllegalArgumentException("Neither \"Application Descriptor\" nor \"MANIFEST.MF\" files found!");
        }
        String string2 = path.getFileName().toString();
        if (path4 != null) {
            try {
                ClasspathEntry[] classpathEntryArray = ClasspathEntry.readFromIml(path4);
                ProjectGenerator.generateProGuardConfig(path, string2, classpathEntryArray);
            }
            catch (Exception exception) {
                System.out.println("Failed to parse IML! No libraries will be exported.");
                ProjectGenerator.generateProGuardConfig(path, string2, new ClasspathEntry[0]);
            }
            boolean bl3 = false;
            Path path5 = path.resolve(".idea").resolve("runConfigurations");
            if (!(Files.exists(path5, new LinkOption[0]) && Files.exists(path5.resolve("Package.xml"), new LinkOption[0]) && Files.exists(path5.resolve("Restore_project.xml"), new LinkOption[0]))) {
                bl3 = true;
            }
            for (int i2 = 1; i2 <= aArray.length; ++i2) {
                Path path6 = path5.resolve("Run_with_KEmulator_" + i2 + ".xml");
                if (!Files.exists(path6, new LinkOption[0])) {
                    bl3 = true;
                    break;
                }
                if (ProjectGenerator.checkRunConfiguration(path6, aArray[i2 - 1])) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                ProjectGenerator.generateRunConfigs(path, string2, aArray, bl2);
            } else {
                System.out.println("Skipping run configurations generation");
            }
            if (!"1.8 CLDC Devtime".equals(ProjectGenerator.getProjectJdkName(path.resolve(".idea").resolve("misc.xml")))) {
                System.out.println("For compatibility reasons, it's recommended to name project's JDK as \"1.8 CLDC Devtime\". You can rerun IDE setup to bring your configuration to recommended one.");
            }
        } else {
            System.out.println("No IML found! Run configuration will not be created.");
            ProjectGenerator.generateProGuardConfig(path, string2, new ClasspathEntry[0]);
        }
        return path4 != null;
    }

    public static String convertEclipse(String string) throws IOException, InterruptedException, ParserConfigurationException, TransformerException, SAXException {
        ClasspathEntry[] classpathEntryArray;
        Path path = Paths.get(string, new String[0]).getParent().toAbsolutePath();
        String string2 = path.getFileName().toString();
        if (Files.exists(path.resolve("META-INF").resolve("MANIFEST.MF"), new LinkOption[0])) {
            System.out.println("MANIFEST.MF found! It will be ignored, converted projects use \"Application Descriptor\".");
        }
        ProjectGenerator.createDirectories(path);
        HashSet<Object> hashSet = new HashSet();
        boolean bl2 = false;
        Path path2 = path.resolve(".gitignore");
        if (Files.exists(path2, new LinkOption[0])) {
            classpathEntryArray = Files.readAllLines(path2);
            hashSet = new HashSet<String>((Collection<String>)classpathEntryArray);
            long l2 = Files.size(path2);
            try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path2, StandardOpenOption.READ);){
                ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                seekableByteChannel.position(l2 - 1L);
                seekableByteChannel.read(byteBuffer);
                byteBuffer.flip();
                byte by2 = byteBuffer.get();
                bl2 = by2 != 10 && by2 != 13;
            }
        }
        classpathEntryArray = new BufferedWriter(new FileWriter(path2.toString(), true));
        a[] aArray = null;
        try {
            if (bl2) {
                classpathEntryArray.newLine();
            }
            if (!(hashSet.contains(".idea") || hashSet.contains(".idea/") || hashSet.contains(".idea/*") || hashSet.contains(".idea/runConfigurations"))) {
                classpathEntryArray.write(".idea/runConfigurations");
                classpathEntryArray.newLine();
            }
            if (!hashSet.contains(PROGUARD_GLOBAL_CFG)) {
                classpathEntryArray.write(PROGUARD_LOCAL_CFG);
                classpathEntryArray.newLine();
            }
        }
        catch (Throwable object) {
            aArray = object;
            throw object;
        }
        finally {
            if (classpathEntryArray != null) {
                if (aArray != null) {
                    try {
                        classpathEntryArray.close();
                    }
                    catch (Throwable throwable) {
                        aArray.addSuppressed(throwable);
                    }
                } else {
                    classpathEntryArray.close();
                }
            }
        }
        classpathEntryArray = ProjectConfigGenerator.generateIML(path.resolve(".classpath"), path.resolve(string2 + ".iml"));
        ProjectGenerator.generateProGuardConfig(path, string2, classpathEntryArray);
        ProjectGenerator.fixManifestWithVersion(Paths.get(string, new String[0]));
        aArray = a.a(path.resolve("Application Descriptor"));
        ProjectGenerator.generateMiscXmls(path, string2);
        ProjectGenerator.generateBuildConfigs(path, string2, true);
        ProjectGenerator.generateRunConfigs(path, string2, aArray, true);
        return path.toString();
    }

    private static void fixManifestWithVersion(Path path) throws IOException {
        List<String> list2 = Files.readAllLines(path);
        boolean bl2 = false;
        for (String string : list2) {
            if (!string.startsWith("Manifest-Version:")) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            list2.add(0, "Manifest-Version: 1.0");
            Files.write(path, list2, new OpenOption[0]);
        }
    }

    private static void createDirectories(Path path) throws IOException {
        Files.createDirectories(path.resolve(".idea"), new FileAttribute[0]);
        Files.createDirectories(path.resolve(".idea").resolve("artifacts"), new FileAttribute[0]);
        Files.createDirectories(path.resolve(".idea").resolve("runConfigurations"), new FileAttribute[0]);
        ProjectGenerator.createDirSilently(path.resolve("src"));
        ProjectGenerator.createDirSilently(path.resolve("res"));
        ProjectGenerator.createDirSilently(path.resolve("bin"));
        ProjectGenerator.createDirSilently(path.resolve("deployed"));
        ProjectGenerator.createDirSilently(path.resolve("META-INF"));
    }

    private static void createDirSilently(Path path) throws IOException {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    private static void generateRunConfigs(Path path, String string, a[] aArray, boolean bl2) throws IOException {
        for (int i2 = 0; i2 < aArray.length; ++i2) {
            Path path2 = path.resolve(".idea").resolve("runConfigurations").resolve("Run_with_KEmulator_" + (i2 + 1) + ".xml");
            String string2 = ProjectConfigGenerator.buildKemRunConfig(string, aArray[i2].b, aArray[i2].a, bl2);
            Files.write(path2, string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        Files.write(path.resolve(".idea").resolve("runConfigurations").resolve("Package.xml"), ProjectConfigGenerator.buildPackageRunConfig(string).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(path.resolve(".idea").resolve("runConfigurations").resolve("Restore_project.xml"), ProjectConfigGenerator.buildRestoreRunConfig(string).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void generateBuildConfigs(Path path, String string, boolean bl2) throws IOException {
        Path path2 = path.resolve(".idea").resolve("artifacts").resolve(string + ".xml");
        Files.write(path2, ProjectConfigGenerator.buildArtifactConfig(string, bl2).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void generateMiscXmls(Path path, String string) throws IOException {
        Files.write(path.resolve(".idea").resolve("encodings.xml"), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"Encoding\" addBOMForNewFiles=\"with BOM under Windows, with no BOM otherwise\" />\n</project>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(path.resolve(".idea").resolve("misc.xml"), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"ProjectRootManager\" version=\"2\" languageLevel=\"JDK_1_3\" project-jdk-name=\"1.8 CLDC Devtime\" project-jdk-type=\"JavaSDK\">\n    <output url=\"file://$PROJECT_DIR$/bin\" />\n  </component>\n</project>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(path.resolve(".idea").resolve(".gitignore"), "# Default ignored files\n/shelf/\n/workspace.xml\n# Editor-based HTTP Client requests\n/httpRequests/\n# Datasource local storage ignored files\n/dataSources/\n/dataSources.local.xml\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(path.resolve(".idea").resolve(".name"), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(path.resolve(".idea").resolve("modules.xml"), ProjectConfigGenerator.buildModulesFile(string).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static String generateDummyMidlet(Path path, String string) throws IOException {
        Path path2;
        Path path3 = path.resolve("src");
        if (string.indexOf(46) != -1) {
            String[] stringArray = ProjectConfigGenerator.splitByLastDot(string);
            Path path4 = Paths.get(path3.toString(), stringArray[0].replace('.', File.separatorChar));
            Files.createDirectories(path4, new FileAttribute[0]);
            path2 = path4.resolve(stringArray[1] + ".java");
            Files.write(path2, ProjectConfigGenerator.buildDummyMidlet(string).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            path2 = path3.resolve(string + ".java");
            Files.write(path2, ProjectConfigGenerator.buildDummyMidlet(string).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return path2.toString();
    }

    private static void generateProGuardConfig(Path path, String string, ClasspathEntry[] classpathEntryArray) throws IOException {
        Files.write(path.resolve(PROGUARD_LOCAL_CFG), ProjectConfigGenerator.buildLocalProguardConfig(path.toString(), string, classpathEntryArray).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        if (!Files.exists(path.resolve(PROGUARD_GLOBAL_CFG), new LinkOption[0])) {
            Files.write(path.resolve(PROGUARD_GLOBAL_CFG), System.lineSeparator().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public static String getProjectJdkName(Path path) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(path.toFile());
            NodeList nodeList = document.getElementsByTagName("component");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element = (Element)nodeList.item(i2);
                if (!"ProjectRootManager".equals(element.getAttribute("name"))) continue;
                return element.getAttribute("project-jdk-name");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String readManifestFromNetbeans(Path path) throws IOException {
        List<String> list2 = Files.readAllLines(path);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (String string : list2) {
            if (!string.startsWith("manifest.")) continue;
            String[] stringArray = string.split("=", 2);
            hashtable.put(stringArray[0].substring("manifest.".length()), Utils.translateEscapes(stringArray[1]));
        }
        return "Manifest-Version: 1.0\n" + (String)hashtable.get("midlets") + (String)hashtable.get("apipermissions") + (String)hashtable.get("others") + (String)hashtable.get("manifest");
    }

    private static boolean checkRunConfiguration(Path path, a a2) throws IOException {
        List<String> list2 = Files.readAllLines(path);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (String string : list2) {
            String string2 = string.trim();
            if (string2.startsWith("<configuration default=\"false\" name=\"Run &quot;")) {
                if (!string.contains("&quot;" + a2.b + "&quot;")) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (string2.startsWith("<option name=\"PROGRAM_PARAMETERS\" value=\"")) {
                if (!string.contains("-midlet " + a2.a)) {
                    return false;
                }
                bl3 = true;
                continue;
            }
            if (!string2.startsWith("<option name=\"WORKING_DIRECTORY\" value=\"")) continue;
            if (!string.contains("\"" + Emulator.getAbsolutePath() + "\"")) {
                return false;
            }
            bl4 = true;
        }
        return bl2 && bl3 && bl4;
    }
}

