/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Node;

public class RayIntersection {
    private float[] rayStartEnd = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private float[] normal = new float[]{0.0f, 0.0f, 1.0f};
    private Node intersected = null;
    private int submeshIndex = 0;
    private float distance = 0.0f;
    private float[] textureS = new float[10];
    private float[] textureT = new float[10];
    private Camera camera;
    private float pickX;
    private float pickY;
    private float minDistance;

    public Node getIntersected() {
        return this.intersected;
    }

    public void getRay(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < 6) {
            throw new IllegalArgumentException();
        }
        fArray[0] = this.rayStartEnd[0];
        fArray[1] = this.rayStartEnd[1];
        fArray[2] = this.rayStartEnd[2];
        fArray[3] = this.rayStartEnd[3] - this.rayStartEnd[0];
        fArray[4] = this.rayStartEnd[4] - this.rayStartEnd[1];
        fArray[5] = this.rayStartEnd[5] - this.rayStartEnd[2];
    }

    public float getDistance() {
        return this.distance;
    }

    public int getSubmeshIndex() {
        return this.submeshIndex;
    }

    public float getTextureS(int n2) {
        if (n2 < 0 && n2 >= 10) {
            throw new IndexOutOfBoundsException();
        }
        return this.textureS[n2];
    }

    public float getTextureT(int n2) {
        if (n2 < 0 && n2 >= 10) {
            throw new IndexOutOfBoundsException();
        }
        return this.textureS[n2];
    }

    public float getNormalX() {
        return this.normal[0];
    }

    public float getNormalY() {
        return this.normal[1];
    }

    public float getNormalZ() {
        return this.normal[2];
    }

    protected Camera getCamera() {
        return this.camera;
    }

    protected float getPickX() {
        return this.pickX;
    }

    protected float getPickY() {
        return this.pickY;
    }

    protected void startPick(float[] fArray, float f2, float f3, Camera camera) {
        this.rayStartEnd = fArray;
        this.pickX = f2;
        this.pickY = f3;
        this.camera = camera;
        this.minDistance = Float.MAX_VALUE;
    }

    protected boolean testDistance(float f2) {
        return f2 > 0.0f && f2 < this.minDistance;
    }

    protected boolean endPick(float f2, float[] fArray, float[] fArray2, int n2, Node node, float[] fArray3) {
        if (!this.testDistance(f2)) {
            return false;
        }
        if (fArray != null && fArray2 != null) {
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                this.textureS[i2] = fArray[i2];
                this.textureT[i2] = fArray2[i2];
            }
        }
        this.submeshIndex = n2;
        this.distance = f2;
        this.intersected = node;
        if (fArray3 != null) {
            this.normal[0] = fArray3[0];
            this.normal[1] = fArray3[1];
            this.normal[2] = fArray3[2];
            float f3 = Vector4f.length(this.normal);
            if (f3 > 1.0E-5f) {
                this.normal[0] = this.normal[0] / f3;
                this.normal[1] = this.normal[1] / f3;
                this.normal[2] = this.normal[2] / f3;
            }
        }
        this.minDistance = f2;
        return true;
    }
}

