/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import kemnn.ff;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Component$Identifier;
import net.java.games.input.Component$Identifier$Button;
import net.java.games.input.Controller;
import net.java.games.input.Controller$Type;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.GenericDesktopUsage;
import net.java.games.input.Keyboard;
import net.java.games.input.Mouse;
import net.java.games.input.OSXAbstractController;
import net.java.games.input.OSXComponent;
import net.java.games.input.OSXEnvironmentPlugin$1;
import net.java.games.input.OSXEnvironmentPlugin$2;
import net.java.games.input.OSXEnvironmentPlugin$3;
import net.java.games.input.OSXHIDDevice;
import net.java.games.input.OSXHIDDeviceIterator;
import net.java.games.input.OSXHIDElement;
import net.java.games.input.OSXHIDQueue;
import net.java.games.input.OSXKeyboard;
import net.java.games.input.OSXMouse;
import net.java.games.input.Rumbler;
import net.java.games.input.UsagePage;
import net.java.games.input.UsagePair;

public final class OSXEnvironmentPlugin
extends ControllerEnvironment
implements ff {
    private static boolean supported = false;
    private final Controller[] controllers = this.isSupported() ? OSXEnvironmentPlugin.enumerateControllers() : new Controller[0];

    static void loadLibrary(String string) {
        AccessController.doPrivileged(new OSXEnvironmentPlugin$1(string));
    }

    static String getPrivilegedProperty(String string) {
        return (String)AccessController.doPrivileged(new OSXEnvironmentPlugin$2(string));
    }

    static String getPrivilegedProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new OSXEnvironmentPlugin$3(string, string2));
    }

    private static final boolean isMacOSXEqualsOrBetterThan(int n2, int n3) {
        int n4;
        int n5;
        String string = System.getProperty("os.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            n5 = Integer.parseInt(string2);
            n4 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            OSXEnvironmentPlugin.logln(new StringBuffer().append("Exception occurred while trying to determine OS version: ").append(exception).toString());
            return false;
        }
        return n5 > n2 || n5 == n2 && n4 >= n3;
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    private static final void addElements(OSXHIDQueue oSXHIDQueue, List list2, List list3, boolean bl2) throws IOException {
        for (OSXHIDElement oSXHIDElement : list2) {
            Component$Identifier component$Identifier = oSXHIDElement.getIdentifier();
            if (component$Identifier == null) continue;
            if (bl2) {
                if (component$Identifier == Component$Identifier$Button._0) {
                    component$Identifier = Component$Identifier$Button.LEFT;
                } else if (component$Identifier == Component$Identifier$Button._1) {
                    component$Identifier = Component$Identifier$Button.RIGHT;
                } else if (component$Identifier == Component$Identifier$Button._2) {
                    component$Identifier = Component$Identifier$Button.MIDDLE;
                }
            }
            OSXComponent oSXComponent = new OSXComponent(component$Identifier, oSXHIDElement);
            list3.add(oSXComponent);
            oSXHIDQueue.addElement(oSXHIDElement, oSXComponent);
        }
    }

    private static final Keyboard createKeyboardFromDevice(OSXHIDDevice oSXHIDDevice, List list2) throws IOException {
        ArrayList arrayList = new ArrayList();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list2, arrayList, false);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        OSXKeyboard oSXKeyboard = new OSXKeyboard(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0]);
        return oSXKeyboard;
    }

    private static final Mouse createMouseFromDevice(OSXHIDDevice oSXHIDDevice, List list2) throws IOException {
        ArrayList arrayList = new ArrayList();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list2, arrayList, true);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        OSXMouse oSXMouse = new OSXMouse(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0]);
        if (oSXMouse.getPrimaryButton() != null && oSXMouse.getX() != null && oSXMouse.getY() != null) {
            return oSXMouse;
        }
        oSXHIDQueue.release();
        return null;
    }

    private static final AbstractController createControllerFromDevice(OSXHIDDevice oSXHIDDevice, List list2, Controller$Type controller$Type) throws IOException {
        ArrayList arrayList = new ArrayList();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list2, arrayList, false);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        OSXAbstractController oSXAbstractController = new OSXAbstractController(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0], controller$Type);
        return oSXAbstractController;
    }

    private static final void createControllersFromDevice(OSXHIDDevice oSXHIDDevice, List list2) throws IOException {
        AbstractController abstractController;
        UsagePair usagePair = oSXHIDDevice.getUsagePair();
        if (usagePair == null) {
            return;
        }
        List list3 = oSXHIDDevice.getElements();
        if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && (usagePair.getUsage() == GenericDesktopUsage.MOUSE || usagePair.getUsage() == GenericDesktopUsage.POINTER)) {
            Mouse mouse = OSXEnvironmentPlugin.createMouseFromDevice(oSXHIDDevice, list3);
            if (mouse != null) {
                list2.add(mouse);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && (usagePair.getUsage() == GenericDesktopUsage.KEYBOARD || usagePair.getUsage() == GenericDesktopUsage.KEYPAD)) {
            Keyboard keyboard = OSXEnvironmentPlugin.createKeyboardFromDevice(oSXHIDDevice, list3);
            if (keyboard != null) {
                list2.add(keyboard);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.JOYSTICK) {
            AbstractController abstractController2 = OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list3, Controller$Type.STICK);
            if (abstractController2 != null) {
                list2.add(abstractController2);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.MULTI_AXIS_CONTROLLER) {
            AbstractController abstractController3 = OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list3, Controller$Type.STICK);
            if (abstractController3 != null) {
                list2.add(abstractController3);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.GAME_PAD && (abstractController = OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list3, Controller$Type.GAMEPAD)) != null) {
            list2.add(abstractController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Controller[] enumerateControllers() {
        Controller[] controllerArray;
        ArrayList arrayList;
        block12: {
            arrayList = new ArrayList();
            try {
                controllerArray = new OSXHIDDeviceIterator();
                block9: while (true) {
                    while (true) {
                        try {
                            OSXHIDDevice oSXHIDDevice = controllerArray.next();
                            if (oSXHIDDevice == null) {
                                break block12;
                            }
                            boolean bl2 = false;
                            try {
                                int n2 = arrayList.size();
                                OSXEnvironmentPlugin.createControllersFromDevice(oSXHIDDevice, arrayList);
                                bl2 = n2 != arrayList.size();
                            }
                            catch (IOException iOException) {
                                OSXEnvironmentPlugin.logln(new StringBuffer().append("Failed to create controllers from device: ").append(oSXHIDDevice.getProductName()).toString());
                            }
                            if (bl2) continue block9;
                            oSXHIDDevice.release();
                            continue block9;
                        }
                        catch (IOException iOException) {
                            OSXEnvironmentPlugin.logln(new StringBuffer().append("Failed to enumerate device: ").append(iOException.getMessage()).toString());
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    controllerArray.close();
                }
            }
            catch (IOException iOException) {
                OSXEnvironmentPlugin.log(new StringBuffer().append("Failed to enumerate devices: ").append(iOException.getMessage()).toString());
                return new Controller[0];
            }
        }
        controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }

    static boolean access$002(boolean bl2) {
        supported = bl2;
        return supported;
    }

    static {
        String string = OSXEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (string.equals("Mac OS X")) {
            supported = true;
            OSXEnvironmentPlugin.loadLibrary("jinput-osx");
        }
    }
}

