/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridj.BridJ$1;
import org.bridj.BridJ$CastingType;
import org.bridj.BridJ$Switch;
import org.bridj.BridJRuntime;
import org.bridj.BridJRuntime$TypeInfo;
import org.bridj.CLong;
import org.bridj.CRuntime;
import org.bridj.CallbackNativeImplementer;
import org.bridj.HeadersReconstructor;
import org.bridj.IntValuedEnum;
import org.bridj.NativeEntities;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.PlatformSupport;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.StructUtils;
import org.bridj.TimeT;
import org.bridj.ann.Library;
import org.bridj.ann.Runtime;
import org.bridj.demangling.Demangler$MemberRef;
import org.bridj.demangling.Demangler$Symbol;
import org.bridj.util.ASMUtils;
import org.bridj.util.AnnotationUtils;
import org.bridj.util.StringUtils;
import org.bridj.util.Utils;

public class BridJ {
    static final Map librariesByClass = new HashMap();
    static final Map librariesFilesByName = new HashMap();
    static final Map librariesByFile = new HashMap();
    private static NativeEntities orphanEntities = new NativeEntities();
    static final Map classRuntimes = new HashMap();
    static final Map strongNativeObjects = new HashMap();
    static ThreadLocal currentlyCastingNativeObject = new BridJ$1();
    private static final ConcurrentHashMap registeredObjects = new ConcurrentHashMap();
    private static Map runtimes = new HashMap();
    static Map typeInfos = new HashMap();
    public static final boolean debug;
    public static final boolean debugNeverFree;
    public static final boolean debugPointers;
    public static final boolean debugPointerReleases;
    public static final boolean veryVerbose;
    public static final boolean verbose;
    public static final boolean quiet;
    public static final boolean logCalls;
    public static final boolean warnStructFields;
    public static final boolean protectedMode;
    public static final boolean enableDestructors;
    public static final boolean alignDoubles;
    public static final boolean cachePointers;
    static volatile int minLogLevelValue;
    static Logger logger;
    static Map libHandles;
    static volatile List nativeLibraryPaths;
    static List additionalPaths;
    static Map libraryActualNames;
    static Map libraryAliases;
    static Map libraryDependencies;
    private static final Pattern numPat;
    static Map nativeLibraryFiles;
    static Boolean directModeEnabled;

    public static long sizeOf(Type type) {
        Class clazz = Utils.getClass(type);
        if (clazz.isPrimitive()) {
            return StructUtils.primTypeLength(clazz);
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return Pointer.SIZE;
        }
        if (clazz == CLong.class) {
            return CLong.SIZE;
        }
        if (clazz == TimeT.class) {
            return TimeT.SIZE;
        }
        if (clazz == SizeT.class) {
            return SizeT.SIZE;
        }
        if (clazz == Integer.class || clazz == Float.class) {
            return 4L;
        }
        if (clazz == Character.class || clazz == Short.class) {
            return 2L;
        }
        if (clazz == Long.class || clazz == Double.class) {
            return 8L;
        }
        if (clazz == Boolean.class || clazz == Byte.class) {
            return 1L;
        }
        if (NativeObject.class.isAssignableFrom(clazz)) {
            return BridJ.getRuntime(clazz).getTypeInfo(type).sizeOf();
        }
        if (IntValuedEnum.class.isAssignableFrom(clazz)) {
            return 4L;
        }
        throw new RuntimeException("Unable to compute size of type " + Utils.toString(type));
    }

    public static synchronized NativeObject protectFromGC(NativeObject nativeObject) {
        long l2 = Pointer.getAddress(nativeObject, null);
        strongNativeObjects.put(l2, nativeObject);
        return nativeObject;
    }

    public static synchronized NativeObject unprotectFromGC(NativeObject nativeObject) {
        long l2 = Pointer.getAddress(nativeObject, null);
        NativeObject nativeObject2 = (NativeObject)strongNativeObjects.remove(l2);
        if (nativeObject2 != nativeObject) {
            throw new IllegalStateException("Unprotected object " + nativeObject2 + " instead of " + nativeObject + " for address " + l2);
        }
        return nativeObject;
    }

    public static void delete(NativeObject nativeObject) {
        BridJ.setJavaObjectFromNativePeer(Pointer.getAddress(nativeObject, null), null);
        Pointer.getPointer(nativeObject, null).release();
    }

    public static synchronized void register() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        if (stackTraceElementArray.length < 2) {
            throw new RuntimeException("No useful stack trace : cannot register with register(), please use register(Class) instead.");
        }
        String string = stackTraceElementArray[1].getClassName();
        try {
            Class<?> clazz = Class.forName(string, false, Platform.getClassLoader());
            BridJ.register(clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to register class " + string, exception);
        }
    }

    public static Class subclassWithSynchronizedNativeMethods(Class clazz) throws IOException {
        CallbackNativeImplementer callbackNativeImplementer = ((CRuntime)BridJ.getRuntimeByRuntimeClass(CRuntime.class)).getCallbackNativeImplementer();
        return ASMUtils.createSubclassWithSynchronizedNativeMethodsAndNoStaticFields(clazz, callbackNativeImplementer);
    }

    public static boolean isCastingNativeObjectInCurrentThread() {
        return ((Stack)currentlyCastingNativeObject.get()).peek() != BridJ$CastingType.None;
    }

    public static boolean isCastingNativeObjectReturnTypeInCurrentThread() {
        return ((Stack)currentlyCastingNativeObject.get()).peek() == BridJ$CastingType.CastingNativeObjectReturnType;
    }

    public static synchronized void setJavaObjectFromNativePeer(long l2, NativeObject nativeObject) {
        if (nativeObject == null) {
            registeredObjects.remove(l2);
        } else {
            registeredObjects.put(l2, nativeObject);
        }
    }

    public static synchronized Object getJavaObjectFromNativePeer(long l2) {
        return registeredObjects.get(l2);
    }

    private static NativeObject createNativeObjectFromPointer(Pointer pointer, Type type, BridJ$CastingType bridJ$CastingType) {
        Stack stack = (Stack)currentlyCastingNativeObject.get();
        stack.push(bridJ$CastingType);
        try {
            BridJRuntime bridJRuntime = BridJ.getRuntime(Utils.getClass(type));
            BridJRuntime$TypeInfo bridJRuntime$TypeInfo = BridJ.getTypeInfo(bridJRuntime, type);
            NativeObject nativeObject = bridJRuntime$TypeInfo.cast(pointer);
            if (debug) {
                BridJ.info("Created native object from pointer " + pointer);
            }
            NativeObject nativeObject2 = nativeObject;
            return nativeObject2;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to cast pointer to native object of type " + Utils.getClass(type).getName(), exception);
        }
        finally {
            stack.pop();
        }
    }

    public static void copyNativeObjectToAddress(NativeObject nativeObject, Type type, Pointer pointer) {
        BridJRuntime bridJRuntime = BridJ.getRuntime(Utils.getClass(type));
        BridJ.getTypeInfo(bridJRuntime, type).copyNativeObjectToAddress(nativeObject, pointer);
    }

    public static NativeObject createNativeObjectFromPointer(Pointer pointer, Type type) {
        return BridJ.createNativeObjectFromPointer(pointer, type, BridJ$CastingType.CastingNativeObject);
    }

    public static NativeObject createNativeObjectFromReturnValuePointer(Pointer pointer, Type type) {
        return BridJ.createNativeObjectFromPointer(pointer, type, BridJ$CastingType.CastingNativeObjectReturnType);
    }

    public static synchronized BridJRuntime getRuntimeByRuntimeClass(Class clazz) {
        BridJRuntime bridJRuntime = (BridJRuntime)runtimes.get(clazz);
        if (bridJRuntime == null) {
            try {
                bridJRuntime = (BridJRuntime)clazz.newInstance();
                runtimes.put(clazz, bridJRuntime);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to instantiate runtime " + clazz.getName(), exception);
            }
        }
        return bridJRuntime;
    }

    public static Class getRuntimeClass(Class clazz) {
        Runtime runtime = (Runtime)AnnotationUtils.getInheritableAnnotation(Runtime.class, clazz, new Annotation[0]);
        Class clazz2 = null;
        clazz2 = runtime != null ? runtime.value() : CRuntime.class;
        return clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridJRuntime getRuntime(Class clazz) {
        Map map = classRuntimes;
        synchronized (map) {
            BridJRuntime bridJRuntime = (BridJRuntime)classRuntimes.get(clazz);
            if (bridJRuntime == null) {
                Class clazz2 = BridJ.getRuntimeClass(clazz);
                bridJRuntime = BridJ.getRuntimeByRuntimeClass(clazz2);
                classRuntimes.put(clazz, bridJRuntime);
                if (veryVerbose) {
                    BridJ.info("Runtime for " + clazz.getName() + " : " + clazz2.getName());
                }
            }
            return bridJRuntime;
        }
    }

    public static BridJRuntime register(Class clazz) {
        BridJRuntime bridJRuntime = BridJ.getRuntime(clazz);
        if (bridJRuntime == null) {
            for (Class<?> clazz2 : clazz.getClasses()) {
                BridJ.register(clazz2);
            }
        } else {
            bridJRuntime.register(clazz);
        }
        return bridJRuntime;
    }

    public static void unregister(Class clazz) {
        BridJRuntime bridJRuntime = BridJ.getRuntime(clazz);
        if (bridJRuntime == null) {
            for (Class<?> clazz2 : clazz.getClasses()) {
                BridJ.register(clazz2);
            }
        } else {
            bridJRuntime.unregister(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BridJRuntime$TypeInfo getTypeInfo(BridJRuntime bridJRuntime, Type type) {
        Map map = typeInfos;
        synchronized (map) {
            BridJRuntime$TypeInfo bridJRuntime$TypeInfo = (BridJRuntime$TypeInfo)typeInfos.get(type);
            if (bridJRuntime$TypeInfo == null) {
                bridJRuntime$TypeInfo = bridJRuntime.getTypeInfo(type);
                typeInfos.put(type, bridJRuntime$TypeInfo);
            }
            return bridJRuntime$TypeInfo;
        }
    }

    static void checkOptions() {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (BridJ$Switch bridJ$Switch : BridJ$Switch.values()) {
            hashSet.add(bridJ$Switch.propertyName);
            hashSet2.add(bridJ$Switch.envName);
        }
        boolean bl2 = false;
        for (String string : System.getenv().keySet()) {
            if (!string.startsWith("BRIDJ_") || hashSet2.contains(string) || string.endsWith("_LIBRARY") || string.endsWith("_DEPENDENCIES")) continue;
            BridJ.error("Unknown environment variable : " + string + "=\"" + System.getenv(string) + "\"");
            bl2 = true;
        }
        Object object = System.getProperties().propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (!string.startsWith("bridj.") || hashSet.contains(string) || string.endsWith(".library") || string.endsWith(".dependencies")) continue;
            BridJ.error("Unknown property : " + string + "=\"" + System.getProperty(string) + "\"");
            bl2 = true;
        }
        if (bl2) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Available options (ENVIRONMENT_VAR_NAME / javaPropertyName) :\n");
            for (BridJ$Switch bridJ$Switch : BridJ$Switch.values()) {
                ((StringBuilder)object).append(bridJ$Switch.getFullDescription() + "\n");
            }
            BridJ.error(((StringBuilder)object).toString());
        }
    }

    public static void setMinLogLevel(Level level) {
        minLogLevelValue = level.intValue();
    }

    static boolean shouldLog(Level level) {
        return !quiet && (verbose || level.intValue() >= minLogLevelValue);
    }

    static synchronized Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(BridJ.class.getName());
        }
        return logger;
    }

    public static boolean info(String string) {
        return BridJ.info(string, null);
    }

    public static boolean info(String string, Throwable throwable) {
        return BridJ.log(Level.INFO, string, throwable);
    }

    public static boolean debug(String string) {
        if (!debug) {
            return true;
        }
        return BridJ.info(string, null);
    }

    public static boolean error(String string) {
        return BridJ.error(string, null);
    }

    public static boolean error(String string, Throwable throwable) {
        return BridJ.log(Level.INFO, string, throwable);
    }

    public static boolean warning(String string) {
        return BridJ.warning(string, null);
    }

    public static boolean warning(String string, Throwable throwable) {
        return BridJ.log(Level.INFO, string, throwable);
    }

    private static boolean log(Level level, String string, Throwable throwable) {
        if (!BridJ.shouldLog(level)) {
            return true;
        }
        BridJ.getLogger().log(level, string, throwable);
        return true;
    }

    static void logCall(Method method) {
        BridJ.info("Calling method " + method);
    }

    public static synchronized NativeEntities getNativeEntities(AnnotatedElement annotatedElement) throws IOException {
        NativeLibrary nativeLibrary = BridJ.getNativeLibrary(annotatedElement);
        if (nativeLibrary != null) {
            return nativeLibrary.getNativeEntities();
        }
        return BridJ.getOrphanEntities();
    }

    public static synchronized NativeLibrary getNativeLibrary(AnnotatedElement annotatedElement) throws IOException {
        Library library;
        NativeLibrary nativeLibrary = (NativeLibrary)librariesByClass.get(annotatedElement);
        if (nativeLibrary == null && (library = BridJ.getLibrary(annotatedElement)) != null) {
            String string = library.value();
            String string2 = BridJ.getDependenciesEnv(string);
            List<String> list2 = (List<String>)libraryDependencies.get(string);
            List<String> list3 = Arrays.asList(string2 == null ? library.dependencies() : string2.split(","));
            if (list2 == null) {
                list2 = list3;
            } else {
                list2.addAll(list3);
            }
            for (String string3 : list2) {
                NativeLibrary nativeLibrary2;
                if (verbose) {
                    BridJ.info("Trying to load dependency '" + string3 + "' of '" + string + "'");
                }
                if ((nativeLibrary2 = BridJ.getNativeLibrary(string3)) != null) continue;
                throw new RuntimeException("Failed to load dependency '" + string3 + "' of library '" + string + "'");
            }
            nativeLibrary = BridJ.getNativeLibrary(string);
            if (nativeLibrary != null) {
                librariesByClass.put(annotatedElement, nativeLibrary);
            }
        }
        return nativeLibrary;
    }

    public static synchronized void releaseAll() {
        strongNativeObjects.clear();
        System.gc();
        for (NativeLibrary nativeLibrary : librariesByFile.values()) {
            nativeLibrary.release();
        }
        librariesByFile.clear();
        librariesByClass.clear();
        BridJ.getOrphanEntities().release();
        System.gc();
    }

    public static synchronized void releaseLibrary(String string) {
        File file = (File)librariesFilesByName.remove(string);
        if (file != null) {
            BridJ.releaseLibrary(file);
        }
    }

    public static synchronized void releaseLibrary(File file) {
        NativeLibrary nativeLibrary = (NativeLibrary)librariesByFile.remove(file);
        if (nativeLibrary != null) {
            nativeLibrary.release();
        }
    }

    public static synchronized void addLibraryPath(String string) {
        additionalPaths.add(string);
        nativeLibraryPaths = null;
    }

    private static void addPathsFromEnv(List list2, String string) {
        String string2 = System.getenv(string);
        if (verbose) {
            BridJ.info("Environment var " + string + " = " + string2);
        }
        BridJ.addPaths(list2, string2);
    }

    private static void addPathsFromProperty(List list2, String string) {
        String string2 = System.getProperty(string);
        if (verbose) {
            BridJ.info("Property " + string + " = " + string2);
        }
        BridJ.addPaths(list2, string2);
    }

    private static void addPaths(List list2, String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(File.pathSeparator);
        if (stringArray.length == 0) {
            return;
        }
        if (stringArray.length == 1) {
            list2.add(stringArray[0]);
            return;
        }
        list2.addAll(Arrays.asList(stringArray));
    }

    static synchronized List getNativeLibraryPaths() {
        if (nativeLibraryPaths == null) {
            String[] stringArray;
            Object object;
            nativeLibraryPaths = new ArrayList();
            nativeLibraryPaths.addAll(additionalPaths);
            nativeLibraryPaths.add(null);
            nativeLibraryPaths.add(".");
            BridJ.addPathsFromEnv(nativeLibraryPaths, "LD_LIBRARY_PATH");
            BridJ.addPathsFromEnv(nativeLibraryPaths, "DYLD_LIBRARY_PATH");
            BridJ.addPathsFromEnv(nativeLibraryPaths, "PATH");
            BridJ.addPathsFromProperty(nativeLibraryPaths, "java.library.path");
            BridJ.addPathsFromProperty(nativeLibraryPaths, "sun.boot.library.path");
            BridJ.addPathsFromProperty(nativeLibraryPaths, "gnu.classpath.boot.library.path");
            File file = new File(System.getProperty("java.home"));
            nativeLibraryPaths.add(new File(file, "bin").toString());
            if (Platform.isMacOSX()) {
                nativeLibraryPaths.add(new File(file, "../Libraries").toString());
            }
            if (Platform.isUnix()) {
                Object object2 = object = Platform.is64Bits() ? "64" : "32";
                if (Platform.isLinux()) {
                    String[] stringArray2;
                    if (Platform.isArm()) {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "gnueabi";
                        stringArray2 = stringArray3;
                        stringArray3[1] = "gnueabihf";
                    } else {
                        String[] stringArray4 = new String[1];
                        stringArray2 = stringArray4;
                        stringArray4[0] = "gnu";
                    }
                    for (String string : stringArray = stringArray2) {
                        String string2 = Platform.getMachine() + "-linux-" + string;
                        nativeLibraryPaths.add("/lib/" + string2);
                        nativeLibraryPaths.add("/usr/lib/" + string2);
                    }
                    nativeLibraryPaths.add("/usr/lib" + (String)object);
                    nativeLibraryPaths.add("/lib" + (String)object);
                } else if (Platform.isSolaris()) {
                    nativeLibraryPaths.add("/usr/lib/" + (String)object);
                    nativeLibraryPaths.add("/lib/" + (String)object);
                }
                nativeLibraryPaths.add("/usr/lib");
                nativeLibraryPaths.add("/lib");
                nativeLibraryPaths.add("/usr/local/lib");
            }
            object = nativeLibraryPaths.iterator();
            while (object.hasNext()) {
                stringArray = (String[])object.next();
                if (null != stringArray && new File((String)stringArray).isDirectory()) continue;
                object.remove();
            }
        }
        return nativeLibraryPaths;
    }

    public static synchronized void setNativeLibraryActualName(String string, String string2) {
        libraryActualNames.put(string, string2);
    }

    public static synchronized void addNativeLibraryAlias(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)libraryAliases.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            libraryAliases.put(string, arrayList);
        }
        if (!arrayList.contains(string2)) {
            arrayList.add(string2);
        }
    }

    public static synchronized void addNativeLibraryDependencies(String string, String ... stringArray) {
        ArrayList<String> arrayList = (ArrayList<String>)libraryDependencies.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            libraryDependencies.put(string, arrayList);
        }
        for (String string2 : stringArray) {
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
    }

    static double parseVersion(String string) {
        Matcher matcher = numPat.matcher(string);
        double d2 = 0.0;
        double d3 = 1.0;
        while (matcher.find()) {
            d2 += (double)Integer.parseInt(matcher.group(1)) * d3;
            d3 /= 1000.0;
        }
        return d2;
    }

    static File findFileWithGreaterVersion(File file, String[] stringArray, String string) {
        Pattern pattern = Pattern.compile(Pattern.quote(string) + "((:?\\.\\d+)+)");
        double d2 = 0.0;
        String string2 = null;
        for (String string3 : stringArray) {
            Matcher matcher = pattern.matcher(string3);
            if (!matcher.matches()) continue;
            double d3 = BridJ.parseVersion(matcher.group(1));
            if (string2 != null && !(d3 > d2)) continue;
            string2 = string3;
            d2 = d3;
        }
        if (string2 == null) {
            return null;
        }
        return new File(file, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getNativeLibraryFile(String string) {
        if (string == null) {
            return null;
        }
        try {
            Map map = nativeLibraryFiles;
            synchronized (map) {
                File file = (File)nativeLibraryFiles.get(string);
                if (debug) {
                    BridJ.info("Library named '" + string + "' is associated to file '" + nativeLibraryFiles + "'", null);
                }
                if (file == null) {
                    file = BridJ.findNativeLibraryFile(string);
                    nativeLibraryFiles.put(string, file);
                }
                return file;
            }
        }
        catch (Throwable throwable) {
            BridJ.warning("Library not found : " + string, debug ? throwable : null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNativeLibraryFile(String string, File file) {
        if (string == null) {
            return;
        }
        Map map = nativeLibraryFiles;
        synchronized (map) {
            nativeLibraryFiles.put(string, file);
        }
    }

    private static String getLibraryEnv(String string) {
        String string2 = System.getenv("BRIDJ_" + string.toUpperCase() + "_LIBRARY");
        if (string2 == null) {
            string2 = System.getProperty("bridj." + string + ".library");
        }
        return string2;
    }

    private static String getDependenciesEnv(String string) {
        String string2 = System.getenv("BRIDJ_" + string.toUpperCase() + "_DEPENDENCIES");
        if (string2 == null) {
            string2 = System.getProperty("bridj." + string + ".dependencies");
        }
        return string2;
    }

    static File findNativeLibraryFile(String string) throws IOException {
        String string2 = (String)libraryActualNames.get(string);
        List list2 = (List)libraryAliases.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Platform.isWindows() && (string.equals("c") || string.equals("m"))) {
            arrayList.add("msvcrt");
        }
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        arrayList.add(string2 == null ? string : string2);
        List list3 = BridJ.getNativeLibraryPaths();
        if (debug) {
            BridJ.info("Looking for library '" + string + "' " + (string2 != null ? "('" + string2 + "') " : "") + "in paths " + list3, null);
        }
        for (String string3 : arrayList) {
            Object object;
            Object object2;
            Object object3;
            String string4 = BridJ.getLibraryEnv(string3);
            if (string4 != null && ((File)(object3 = new File(string4))).exists()) {
                try {
                    return ((File)object3).getCanonicalFile();
                }
                catch (IOException iOException) {
                    BridJ.error(null, iOException);
                }
            }
            object3 = Platform.getPossibleFileNames(string3);
            if (debug) {
                BridJ.info("Possible file names for library '" + string + "' with name '" + string3 + "': " + object3, null);
            }
            Object object4 = list3.iterator();
            while (object4.hasNext()) {
                String string5 = (String)object4.next();
                File file = string5 == null ? null : new File(string5);
                object2 = new File(string3);
                if (!((File)object2).isFile() && file != null) {
                    Object object5;
                    object = object3.iterator();
                    while (object.hasNext() && !((File)(object2 = new File(file, (String)(object5 = (String)object.next())))).isFile()) {
                    }
                    if (!((File)object2).isFile() && Platform.isLinux() && (object = file.list()) != null) {
                        object5 = object3.iterator();
                        while (object5.hasNext()) {
                            String string6 = (String)object5.next();
                            File file2 = BridJ.findFileWithGreaterVersion(file, (String[])object, string6);
                            if (file2 == null || !((File)(object2 = file2)).isFile()) continue;
                            if (!verbose) break;
                            BridJ.info("File '" + string6 + "' was not found, used versioned file '" + object2 + "' instead.");
                            break;
                        }
                    }
                }
                if (!((File)object2).isFile()) continue;
                try {
                    return ((File)object2).getCanonicalFile();
                }
                catch (IOException iOException) {
                    BridJ.error(null, iOException);
                }
            }
            if (Platform.isMacOSX()) {
                object4 = new String[]{"/System/Library/Frameworks", "/System/Library/Frameworks/ApplicationServices.framework/Frameworks", new File(System.getProperty("user.home"), "Library/Frameworks").toString()};
                int n2 = ((String[])object4).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object2 = object4[i2];
                    try {
                        object = new File(new File((String)object2, string3 + ".framework"), string3);
                        if (!((File)object).isFile()) continue;
                        return ((File)object).getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return null;
                    }
                }
            }
            if ((object4 = Platform.isAndroid() ? new File("lib" + string3 + ".so") : Platform.extractEmbeddedLibraryResource(string3)) == null || !object4.isFile()) continue;
            return object4;
        }
        throw new FileNotFoundException(StringUtils.implode(arrayList, (Object)", "));
    }

    public static boolean isDirectModeEnabled() {
        if (directModeEnabled == null) {
            directModeEnabled = BridJ$Switch.Direct.enabled && !logCalls && !protectedMode;
            if (veryVerbose) {
                BridJ.info("directModeEnabled = " + directModeEnabled);
            }
        }
        return directModeEnabled;
    }

    static void setDirectModeEnabled(boolean bl2) {
        directModeEnabled = bl2;
    }

    public static synchronized NativeLibrary getNativeLibrary(String string) throws IOException {
        if (string == null) {
            return null;
        }
        NativeLibrary nativeLibrary = (NativeLibrary)libHandles.get(string);
        if (nativeLibrary != null) {
            return nativeLibrary;
        }
        File file = BridJ.getNativeLibraryFile(string);
        return BridJ.getNativeLibrary(string, file);
    }

    public static NativeLibrary getNativeLibrary(String string, File file) throws IOException {
        NativeLibrary nativeLibrary = NativeLibrary.load(file == null ? string : file.toString());
        if (nativeLibrary == null && (nativeLibrary = PlatformSupport.getInstance().loadNativeLibrary(string)) == null) {
            boolean bl2 = Platform.isWindows();
            if ("c".equals(string) || "m".equals(string) && bl2) {
                nativeLibrary = new NativeLibrary(bl2 ? "msvcrt" : null, 0L, 0L);
            }
        }
        if (nativeLibrary == null) {
            if (file != null && file.exists()) {
                throw new RuntimeException("Library '" + string + "' was not loaded successfully from file '" + file + "'");
            }
            throw new FileNotFoundException("Library '" + string + "' was not found in path '" + BridJ.getNativeLibraryPaths() + "'" + (file != null && file.exists() ? " (failed to load " + file + ")" : ""));
        }
        if (verbose) {
            BridJ.info("Loaded library '" + string + "' from '" + file + "'", null);
        }
        libHandles.put(string, nativeLibrary);
        return nativeLibrary;
    }

    public static String getNativeLibraryName(AnnotatedElement annotatedElement) {
        Library library = BridJ.getLibrary(annotatedElement);
        return library == null ? null : library.value();
    }

    static Library getLibrary(AnnotatedElement annotatedElement) {
        return (Library)AnnotationUtils.getInheritableAnnotation(Library.class, annotatedElement, new Annotation[0]);
    }

    public static Demangler$Symbol getSymbolByAddress(long l2) {
        for (NativeLibrary nativeLibrary : libHandles.values()) {
            Demangler$Symbol symbol = nativeLibrary.getSymbol(l2);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public static void setOrphanEntities(NativeEntities nativeEntities) {
        orphanEntities = nativeEntities;
    }

    public static NativeEntities getOrphanEntities() {
        return orphanEntities;
    }

    static void initialize(NativeObject nativeObject) {
        BridJRuntime$TypeInfo bridJRuntime$TypeInfo;
        Class<?> clazz = nativeObject.getClass();
        BridJRuntime bridJRuntime = BridJ.getRuntime(clazz);
        Type type = bridJRuntime.getType(nativeObject);
        nativeObject.typeInfo = bridJRuntime$TypeInfo = BridJ.getTypeInfo(bridJRuntime, type);
        bridJRuntime$TypeInfo.initialize(nativeObject);
    }

    static void initialize(NativeObject nativeObject, Pointer pointer, Object ... objectArray) {
        BridJRuntime$TypeInfo bridJRuntime$TypeInfo;
        Class<?> clazz = nativeObject.getClass();
        BridJRuntime bridJRuntime = BridJ.getRuntime(clazz);
        Type type = bridJRuntime.getType(clazz, objectArray, null);
        nativeObject.typeInfo = bridJRuntime$TypeInfo = BridJ.getTypeInfo(bridJRuntime, type);
        bridJRuntime$TypeInfo.initialize(nativeObject, pointer);
    }

    static void initialize(NativeObject nativeObject, int n2, Object[] objectArray) {
        BridJRuntime$TypeInfo bridJRuntime$TypeInfo;
        Class<?> clazz = nativeObject.getClass();
        BridJRuntime bridJRuntime = BridJ.getRuntime(clazz);
        int[] nArray = new int[1];
        Type type = bridJRuntime.getType(clazz, objectArray, nArray);
        int n3 = nArray[0];
        Object[] objectArray2 = Utils.takeRight(objectArray, objectArray.length - n3);
        nativeObject.typeInfo = bridJRuntime$TypeInfo = BridJ.getTypeInfo(bridJRuntime, type);
        bridJRuntime$TypeInfo.initialize(nativeObject, n2, objectArray2);
    }

    static NativeObject clone(NativeObject nativeObject) throws CloneNotSupportedException {
        return nativeObject.typeInfo.clone(nativeObject);
    }

    public static NativeObject readFromNative(NativeObject nativeObject) {
        nativeObject.typeInfo.readFromNative(nativeObject);
        return nativeObject;
    }

    public static NativeObject writeToNative(NativeObject nativeObject) {
        nativeObject.typeInfo.writeToNative(nativeObject);
        return nativeObject;
    }

    public static String describe(NativeObject nativeObject) {
        return nativeObject.typeInfo.describe(nativeObject);
    }

    public static String describe(Type type) {
        BridJRuntime bridJRuntime = BridJ.getRuntime(Utils.getClass(type));
        BridJRuntime$TypeInfo bridJRuntime$TypeInfo = BridJ.getTypeInfo(bridJRuntime, type);
        return bridJRuntime$TypeInfo == null ? Utils.toString(type) : bridJRuntime$TypeInfo.describe();
    }

    public static void main(String[] stringArray) {
        ArrayList<NativeLibrary> arrayList = new ArrayList<NativeLibrary>();
        try {
            File file = new File(".");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                if (string.equals("-d")) {
                    file = new File(stringArray[++i2]);
                    continue;
                }
                try {
                    NativeLibrary nativeLibrary = BridJ.getNativeLibrary(string);
                    arrayList.add(nativeLibrary);
                    PrintWriter printWriter = new PrintWriter(new File(file, new File(string).getName() + ".symbols.txt"));
                    for (Demangler$Symbol demangler$Symbol : nativeLibrary.getSymbols()) {
                        printWriter.print(demangler$Symbol.getSymbol());
                        printWriter.print(" // ");
                        try {
                            Demangler$MemberRef demangler$MemberRef = demangler$Symbol.getParsedRef();
                            printWriter.print(" // " + demangler$MemberRef);
                        }
                        catch (Throwable throwable) {
                            printWriter.print("?");
                        }
                        printWriter.println();
                    }
                    printWriter.close();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            PrintWriter printWriter = new PrintWriter(new File(file, "out.h"));
            HeadersReconstructor.reconstructHeaders(arrayList, printWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static {
        BridJ.checkOptions();
        debug = BridJ$Switch.Debug.enabled;
        debugNeverFree = BridJ$Switch.DebugNeverFree.enabled;
        debugPointers = BridJ$Switch.DebugPointers.enabled;
        debugPointerReleases = BridJ$Switch.DebugPointerReleases.enabled || debugPointers;
        veryVerbose = BridJ$Switch.VeryVerbose.enabled;
        verbose = debug || veryVerbose || BridJ$Switch.Verbose.enabled;
        quiet = BridJ$Switch.Quiet.enabled;
        logCalls = BridJ$Switch.LogCalls.enabled;
        warnStructFields = BridJ$Switch.LogCalls.enabled;
        protectedMode = BridJ$Switch.Protected.enabled;
        enableDestructors = BridJ$Switch.Destructors.enabled;
        alignDoubles = BridJ$Switch.AlignDouble.enabled;
        cachePointers = BridJ$Switch.CachePointers.enabled;
        minLogLevelValue = (verbose ? Level.WARNING : Level.INFO).intValue();
        libHandles = new HashMap();
        additionalPaths = new ArrayList();
        libraryActualNames = new HashMap();
        libraryAliases = new HashMap();
        libraryDependencies = new HashMap();
        numPat = Pattern.compile("\\b(\\d+)\\b");
        nativeLibraryFiles = new HashMap();
    }
}

