/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.bridj.Pointer;
import org.bridj.relocated.org.objectweb.asm.ClassReader;
import org.bridj.relocated.org.objectweb.asm.ClassVisitor;
import org.bridj.relocated.org.objectweb.asm.ClassWriter;
import org.bridj.relocated.org.objectweb.asm.MethodVisitor;
import org.bridj.util.ASMUtils$1;
import org.bridj.util.ClassDefiner;
import org.bridj.util.JNIUtils;

public class ASMUtils {
    public static String typeDesc(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz == Pointer.class) {
                return "Pointer";
            }
            if (clazz.isPrimitive()) {
                String string = clazz.getSimpleName();
                return Character.toUpperCase(string.charAt(0)) + string.substring(1);
            }
            if (clazz.isArray()) {
                return ASMUtils.typeDesc(clazz.getComponentType()) + "Array";
            }
            return clazz.getName().replace('.', '_');
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        StringBuilder stringBuilder = new StringBuilder(ASMUtils.typeDesc(parameterizedType.getRawType()));
        for (Type type2 : parameterizedType.getActualTypeArguments()) {
            stringBuilder.append("_").append(ASMUtils.typeDesc(type2));
        }
        return stringBuilder.toString();
    }

    public static void addSuperCall(ClassVisitor classVisitor, String string) {
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    public static Class createSubclassWithSynchronizedNativeMethodsAndNoStaticFields(Class clazz, ClassDefiner classDefiner) throws IOException {
        String string = "$SynchronizedNative";
        String string2 = JNIUtils.getNativeName(clazz);
        String string3 = clazz.getName() + string;
        String string4 = string2 + string;
        ClassWriter classWriter = new ClassWriter(0);
        ASMUtils$1 aSMUtils$1 = new ASMUtils$1(262144, classWriter, string4, string2);
        ClassReader classReader = new ClassReader(clazz.getName());
        classReader.accept(aSMUtils$1, 0);
        return classDefiner.defineClass(string3, classWriter.toByteArray());
    }
}

