/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.opengl.swt.GLData;
import org.lwjgl.opengl.swt.PlatformGLCanvas;
import org.lwjgl.system.Platform;

public class GLCanvas
extends Canvas {
    GLData effective;
    long context;
    long xWindow;
    long glWindow;
    private static PlatformGLCanvas platformCanvas;

    public GLCanvas(Composite composite, int n2, GLData gLData) {
        super(composite, platformCanvas.checkStyle(composite, n2));
        if (Platform.get() == Platform.WINDOWS) {
            platformCanvas.resetStyle(composite);
        }
        if (gLData == null) {
            SWT.error((int)4);
        }
        this.effective = new GLData();
        this.context = platformCanvas.create(this, gLData, this.effective);
    }

    public GLData getGLData() {
        this.checkWidget();
        return this.effective;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return platformCanvas.isCurrent(this.context);
    }

    public void setCurrent() {
        this.checkWidget();
        if (platformCanvas.isCurrent(this.context)) {
            return;
        }
        platformCanvas.makeCurrent(this, this.context);
    }

    public void swapBuffers() {
        this.checkWidget();
        platformCanvas.swapBuffers(this);
    }

    public boolean delayBeforeSwapNV(float f2) {
        this.checkWidget();
        return platformCanvas.delayBeforeSwapNV(this, f2);
    }

    static {
        String string;
        switch (Platform.get()) {
            case WINDOWS: {
                string = "org.lwjgl.opengl.swt.PlatformWin32GLCanvas";
                break;
            }
            case LINUX: {
                string = "org.lwjgl.opengl.swt.PlatformLinuxGLCanvas";
                break;
            }
            case MACOSX: {
                string = "org.lwjgl.opengl.swt.PlatformMacOSXGLCanvas";
                break;
            }
            default: {
                throw new AssertionError((Object)"NYI");
            }
        }
        try {
            Class<?> clazz = GLCanvas.class.getClassLoader().loadClass(string);
            platformCanvas = (PlatformGLCanvas)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)("Platform-specific GLCanvas class not found: " + string));
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)("Could not instantiate platform-specific GLCanvas class: " + string));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)("Could not instantiate platform-specific GLCanvas class: " + string));
        }
    }
}

