/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingClockRegister$Buffer;

public class IOURingClockRegister
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CLOCKID;
    public static final int __RESV;

    protected IOURingClockRegister(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingClockRegister create(long l2, ByteBuffer byteBuffer) {
        return new IOURingClockRegister(l2, byteBuffer);
    }

    public IOURingClockRegister(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingClockRegister.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int clockid() {
        return IOURingClockRegister.nclockid(this.address());
    }

    public IOURingClockRegister clockid(int n2) {
        IOURingClockRegister.nclockid(this.address(), n2);
        return this;
    }

    public IOURingClockRegister set(IOURingClockRegister iOURingClockRegister) {
        MemoryUtil.memCopy(iOURingClockRegister.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingClockRegister malloc() {
        return new IOURingClockRegister(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingClockRegister calloc() {
        return new IOURingClockRegister(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingClockRegister create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingClockRegister(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingClockRegister create(long l2) {
        return new IOURingClockRegister(l2, null);
    }

    public static IOURingClockRegister createSafe(long l2) {
        return l2 == 0L ? null : new IOURingClockRegister(l2, null);
    }

    public static IOURingClockRegister$Buffer malloc(int n2) {
        return new IOURingClockRegister$Buffer(MemoryUtil.nmemAllocChecked(IOURingClockRegister.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingClockRegister$Buffer calloc(int n2) {
        return new IOURingClockRegister$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingClockRegister$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingClockRegister.__create(n2, SIZEOF);
        return new IOURingClockRegister$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingClockRegister$Buffer create(long l2, int n2) {
        return new IOURingClockRegister$Buffer(l2, n2);
    }

    public static IOURingClockRegister$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingClockRegister$Buffer(l2, n2);
    }

    public static IOURingClockRegister malloc(MemoryStack memoryStack) {
        return new IOURingClockRegister(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingClockRegister calloc(MemoryStack memoryStack) {
        return new IOURingClockRegister(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingClockRegister$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingClockRegister$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingClockRegister$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingClockRegister$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nclockid(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CLOCKID);
    }

    public static IntBuffer n__resv(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)__RESV, 3);
    }

    public static int n__resv(long l2, int n2) {
        return MemoryUtil.memGetInt(l2 + (long)__RESV + Checks.check(n2, 3) * 4L);
    }

    public static void nclockid(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CLOCKID, n2);
    }

    public static void n__resv(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)__RESV, intBuffer.remaining() * 4);
    }

    public static void n__resv(long l2, int n2, int n3) {
        MemoryUtil.memPutInt(l2 + (long)__RESV + Checks.check(n2, 3) * 4L, n3);
    }

    static {
        Struct$Layout struct$Layout = IOURingClockRegister.__struct(IOURingClockRegister.__member(4), IOURingClockRegister.__array(4, 3));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        CLOCKID = struct$Layout.offsetof(0);
        __RESV = struct$Layout.offsetof(1);
    }
}

