/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.graphics.ImageUtil;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public NSImage handle;
    GC memGC;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;
    private ImageFileNameProvider imageFileNameProvider;
    private ImageDataProvider imageDataProvider;
    private int styleFlag = 0;
    private AlphaInfo alphaInfo_100;
    private AlphaInfo alphaInfo_200;

    Image(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, int width, int height) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(width, height);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Image srcImage, int flag) {
        super(device);
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep rep200;
            this.type = srcImage.type;
            NSSize size = srcImage.handle.size();
            int srcWidth = (int)size.width;
            int srcHeight = (int)size.height;
            this.alphaInfo_100 = new AlphaInfo();
            this.copyAlphaInfo(srcImage.alphaInfo_100, this.alphaInfo_100);
            if (srcImage.alphaInfo_200 != null) {
                this.alphaInfo_200 = new AlphaInfo();
                this.copyAlphaInfo(srcImage.alphaInfo_200, this.alphaInfo_200);
            }
            this.handle = (NSImage)new NSImage().alloc();
            this.handle = this.handle.initWithSize(size);
            this.handle.setCacheMode(3L);
            this.createRepFromSourceAndApplyFlag(srcImage.getRepresentation(100), srcWidth, srcHeight, flag);
            this.imageFileNameProvider = srcImage.imageFileNameProvider;
            this.imageDataProvider = srcImage.imageDataProvider;
            this.styleFlag = srcImage.styleFlag | flag;
            if ((this.imageFileNameProvider != null || this.imageDataProvider != null) && (rep200 = srcImage.getRepresentation(200)) != null) {
                this.createRepFromSourceAndApplyFlag(rep200, srcWidth * 2, srcHeight * 2, flag);
            }
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    private void copyAlphaInfo(AlphaInfo src_alphaInfo, AlphaInfo dest_alphaInfo) {
        dest_alphaInfo.transparentPixel = src_alphaInfo.transparentPixel;
        dest_alphaInfo.alpha = src_alphaInfo.alpha;
        if (src_alphaInfo.alphaData != null) {
            dest_alphaInfo.alphaData = new byte[src_alphaInfo.alphaData.length];
            System.arraycopy(src_alphaInfo.alphaData, 0, dest_alphaInfo.alphaData, 0, dest_alphaInfo.alphaData.length);
        }
    }

    private void createRepFromSourceAndApplyFlag(NSBitmapImageRep srcRep, int srcWidth, int srcHeight, int flag) {
        long srcData = srcRep.bitmapData();
        long srcBitmapFormat = srcRep.bitmapFormat();
        long srcBpp = srcRep.bitsPerPixel();
        long srcBpr = srcRep.bytesPerRow();
        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        rep = rep.initWithBitmapDataPlanes(0L, srcWidth, srcHeight, srcRep.bitsPerSample(), srcRep.samplesPerPixel(), srcRep.hasAlpha(), srcRep.isPlanar(), OS.NSDeviceRGBColorSpace, srcBitmapFormat, srcRep.bytesPerRow(), srcBpp);
        this.handle.addRepresentation(rep);
        rep.release();
        long data = rep.bitmapData();
        C.memmove(data, srcData, (long)(srcWidth * srcHeight * 4));
        if (flag != 0) {
            int blueOffset;
            int greenOffset;
            int redOffset;
            if (srcBpp == 32L && (srcBitmapFormat & 1L) == 0L) {
                redOffset = 0;
                greenOffset = 1;
                blueOffset = 2;
            } else {
                redOffset = 1;
                greenOffset = 2;
                blueOffset = 3;
            }
            switch (flag) {
                case 1: {
                    Color zeroColor = this.device.getSystemColor(18);
                    RGB zeroRGB = zeroColor.getRGB();
                    byte zeroRed = (byte)zeroRGB.red;
                    byte zeroGreen = (byte)zeroRGB.green;
                    byte zeroBlue = (byte)zeroRGB.blue;
                    Color oneColor = this.device.getSystemColor(22);
                    RGB oneRGB = oneColor.getRGB();
                    byte oneRed = (byte)oneRGB.red;
                    byte oneGreen = (byte)oneRGB.green;
                    byte oneBlue = (byte)oneRGB.blue;
                    byte[] line = new byte[(int)srcBpr];
                    for (int y = 0; y < srcHeight; ++y) {
                        C.memmove(line, data + (long)y * srcBpr, srcBpr);
                        int offset = 0;
                        for (int x = 0; x < srcWidth; ++x) {
                            int red = line[offset + redOffset] & 0xFF;
                            int green = line[offset + greenOffset] & 0xFF;
                            int blue = line[offset + blueOffset] & 0xFF;
                            int intensity = red * red + green * green + blue * blue;
                            if (intensity < 98304) {
                                line[offset + redOffset] = zeroRed;
                                line[offset + greenOffset] = zeroGreen;
                                line[offset + blueOffset] = zeroBlue;
                            } else {
                                line[offset + redOffset] = oneRed;
                                line[offset + greenOffset] = oneGreen;
                                line[offset + blueOffset] = oneBlue;
                            }
                            offset += 4;
                        }
                        C.memmove(data + (long)y * srcBpr, line, srcBpr);
                    }
                    break;
                }
                case 2: {
                    byte[] line = new byte[(int)srcBpr];
                    for (int y = 0; y < srcHeight; ++y) {
                        C.memmove(line, data + (long)y * srcBpr, srcBpr);
                        int offset = 0;
                        for (int x = 0; x < srcWidth; ++x) {
                            byte intensity;
                            int red = line[offset + redOffset] & 0xFF;
                            int green = line[offset + greenOffset] & 0xFF;
                            int blue = line[offset + blueOffset] & 0xFF;
                            byte by = intensity = (byte)(red + red + green + green + green + green + green + blue >> 3);
                            line[offset + blueOffset] = by;
                            line[offset + greenOffset] = by;
                            line[offset + redOffset] = by;
                            offset += 4;
                        }
                        C.memmove(data + (long)y * srcBpr, line, srcBpr);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(bounds.width, bounds.height);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData data) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(data);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            mask = ImageData.convertMask(mask);
            ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
            image.maskPad = mask.scanlinePad;
            image.maskData = mask.data;
            this.init(image);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, InputStream stream) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(new ImageData(stream));
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, String filename) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (filename == null) {
                SWT.error(4);
            }
            this.initNative(filename);
            if (this.handle == null) {
                this.init(new ImageData(filename));
            }
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        this.imageFileNameProvider = imageFileNameProvider;
        String filename = imageFileNameProvider.getImagePath(100);
        if (filename == null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.initNative(filename);
            if (this.handle == null) {
                this.init(new ImageData(filename));
            }
            this.init();
            String filename2x = imageFileNameProvider.getImagePath(200);
            if (filename2x != null) {
                this.alphaInfo_200 = new AlphaInfo();
                NSImageRep id2 = NSImageRep.imageRepWithContentsOfFile(NSString.stringWith(filename2x));
                NSImageRep rep = new NSImageRep(id2);
                this.handle.addRepresentation(rep);
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        this.imageDataProvider = imageDataProvider;
        ImageData data = imageDataProvider.getImageData(100);
        if (data == null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(data);
            this.init();
            ImageData data2x = imageDataProvider.getImageData(200);
            if (data2x != null) {
                this.alphaInfo_200 = new AlphaInfo();
                NSBitmapImageRep rep = this.createRepresentation(data2x, this.alphaInfo_200);
                this.handle.addRepresentation(rep);
                rep.release();
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    private AlphaInfo _getAlphaInfoAtCurrentZoom(NSBitmapImageRep rep) {
        int deviceZoom = DPIUtil.getDeviceZoom();
        if (deviceZoom != 100 && (this.imageFileNameProvider != null || this.imageDataProvider != null) && this.alphaInfo_100.alphaData != null && this.alphaInfo_200 != null) {
            if (this.alphaInfo_200.alphaData == null) {
                this.initAlpha_200(rep);
            }
            return this.alphaInfo_200;
        }
        return this.alphaInfo_100;
    }

    ImageData _getImageData(NSBitmapImageRep imageRep, AlphaInfo info) {
        long width = imageRep.pixelsWide();
        long height = imageRep.pixelsHigh();
        long bpr = imageRep.bytesPerRow();
        long bpp = imageRep.bitsPerPixel();
        long bitmapData = imageRep.bitmapData();
        long bitmapFormat = imageRep.bitmapFormat();
        long dataSize = height * bpr;
        byte[] srcData = new byte[(int)dataSize];
        C.memmove(srcData, bitmapData, dataSize);
        PaletteData palette = bpp == 32L && (bitmapFormat & 1L) == 0L ? new PaletteData(-16777216, 0xFF0000, 65280) : new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData((int)width, (int)height, (int)bpp, palette, 1, srcData);
        data.bytesPerLine = (int)bpr;
        if (imageRep.hasAlpha() && info.transparentPixel == -1 && info.alpha == -1 && info.alphaData == null) {
            byte[] alphaD = new byte[(int)(dataSize / 4L)];
            int offset = (bitmapFormat & 1L) != 0L ? 0 : 3;
            int a = 0;
            for (int i = offset; i < srcData.length && a < alphaD.length; i += 4, ++a) {
                alphaD[a] = srcData[i];
            }
            data.alphaData = alphaD;
        } else {
            data.transparentPixel = info.transparentPixel;
            if (info.transparentPixel == -1 && this.type == 1) {
                int maskPad = 2;
                long maskBpl = ((width + 7L) / 8L + (long)(maskPad - 1)) / (long)maskPad * (long)maskPad;
                byte[] maskData = new byte[(int)(height * maskBpl)];
                int offset = 0;
                int maskOffset = 0;
                int y = 0;
                while ((long)y < height) {
                    int x = 0;
                    while ((long)x < width) {
                        if (srcData[offset] != 0) {
                            int n = maskOffset + (x >> 3);
                            maskData[n] = (byte)(maskData[n] | 1 << 7 - (x & 7));
                        } else {
                            int n = maskOffset + (x >> 3);
                            maskData[n] = (byte)(maskData[n] & ~(1 << 7 - (x & 7)));
                        }
                        offset += 4;
                        ++x;
                    }
                    maskOffset = (int)((long)maskOffset + maskBpl);
                    ++y;
                }
                data.maskData = maskData;
                data.maskPad = maskPad;
            }
            data.alpha = info.alpha;
            if (info.alpha == -1 && info.alphaData != null) {
                data.alphaData = new byte[info.alphaData.length];
                System.arraycopy(info.alphaData, 0, data.alphaData, 0, info.alphaData.length);
            }
        }
        if (bpp == 32L) {
            int offset;
            for (int i = offset = (bitmapFormat & 1L) != 0L ? 0 : 3; i < srcData.length; i += 4) {
                srcData[i] = 0;
            }
        }
        return data;
    }

    public static Image cocoa_new(Device device, int type, NSImage nsImage) {
        Image image = new Image(device);
        image.type = type;
        image.handle = nsImage;
        image.alphaInfo_100 = new AlphaInfo();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAlpha() {
        AlphaInfo info = this.alphaInfo_100;
        if (info.transparentPixel == -1 && info.alpha == -1 && info.alphaData == null) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep imageRep = this.getRepresentation();
            long height = imageRep.pixelsHigh();
            long bpr = imageRep.bytesPerRow();
            long bitmapData = imageRep.bitmapData();
            long format = imageRep.bitmapFormat();
            long dataSize = height * bpr;
            byte[] srcData = new byte[(int)dataSize];
            C.memmove(srcData, bitmapData, dataSize);
            if (info.transparentPixel != -1) {
                if ((format & 1L) != 0L) {
                    int i = 0;
                    while ((long)i < dataSize) {
                        int pixel = (srcData[i + 1] & 0xFF) << 16 | (srcData[i + 2] & 0xFF) << 8 | srcData[i + 3] & 0xFF;
                        srcData[i] = (byte)(pixel == info.transparentPixel ? 0 : 255);
                        i += 4;
                    }
                } else {
                    int i = 0;
                    while ((long)i < dataSize) {
                        int pixel = (srcData[i + 0] & 0xFF) << 16 | (srcData[i + 1] & 0xFF) << 8 | srcData[i + 2] & 0xFF;
                        srcData[i] = (byte)(pixel == info.transparentPixel ? 0 : 255);
                        i += 4;
                    }
                }
            } else if (info.alpha != -1) {
                int i;
                byte a = (byte)info.alpha;
                int n = i = (format & 1L) != 0L ? 0 : 3;
                while ((long)i < dataSize) {
                    srcData[i] = a;
                    i += 4;
                }
            } else {
                long width = imageRep.pixelsWide();
                int offset = 0;
                int alphaOffset = (format & 1L) != 0L ? 0 : 3;
                int y = 0;
                while ((long)y < height) {
                    int x = 0;
                    while ((long)x < width && alphaOffset < info.alphaData.length && offset < srcData.length) {
                        srcData[offset] = info.alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                        ++x;
                    }
                    ++y;
                }
            }
            imageRep.setAlpha(true);
            C.memmove(bitmapData, srcData, dataSize);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    private NSBitmapImageRep createRepresentation(ImageData imageData, AlphaInfo alphaInfo) {
        boolean hasAlpha;
        RGB rgb;
        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        PaletteData palette = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || palette.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        int dataSize = imageData.width * imageData.height * 4;
        int bpr = imageData.width * 4;
        byte[] buffer = new byte[dataSize];
        if (palette.isDirect) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rgbs = palette.getRGBs();
            int length = rgbs.length;
            byte[] srcReds = new byte[length];
            byte[] srcGreens = new byte[length];
            byte[] srcBlues = new byte[length];
            for (int i = 0; i < rgbs.length; ++i) {
                rgb = rgbs[i];
                if (rgb == null) continue;
                srcReds[i] = (byte)rgb.red;
                srcGreens[i] = (byte)rgb.green;
                srcBlues[i] = (byte)rgb.blue;
            }
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        }
        int transparency = imageData.getTransparencyType();
        boolean bl = hasAlpha = transparency != 0;
        if (transparency == 2 || imageData.transparentPixel != -1) {
            int n = this.type = imageData.transparentPixel != -1 ? 0 : 1;
            if (imageData.transparentPixel != -1) {
                int transRed = 0;
                int transGreen = 0;
                int transBlue = 0;
                if (palette.isDirect) {
                    RGB rgb2 = palette.getRGB(imageData.transparentPixel);
                    transRed = rgb2.red;
                    transGreen = rgb2.green;
                    transBlue = rgb2.blue;
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    if (imageData.transparentPixel < rgbs.length) {
                        rgb = rgbs[imageData.transparentPixel];
                        transRed = rgb.red;
                        transGreen = rgb.green;
                        transBlue = rgb.blue;
                    }
                }
                alphaInfo.transparentPixel = transRed << 16 | transGreen << 8 | transBlue;
            }
            ImageData maskImage = imageData.getTransparencyMask();
            byte[] maskData = maskImage.data;
            int maskBpl = maskImage.bytesPerLine;
            int offset = 0;
            int maskOffset = 0;
            for (int y = 0; y < imageData.height; ++y) {
                for (int x = 0; x < imageData.width; ++x) {
                    buffer[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                    offset += 4;
                }
                maskOffset += maskBpl;
            }
        } else {
            this.type = 0;
            if (imageData.alpha != -1) {
                hasAlpha = true;
                alphaInfo.alpha = imageData.alpha;
                byte a = (byte)alphaInfo.alpha;
                for (int dataIndex = 0; dataIndex < buffer.length; dataIndex += 4) {
                    buffer[dataIndex] = a;
                }
            } else if (imageData.alphaData != null) {
                hasAlpha = true;
                alphaInfo.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, alphaInfo.alphaData, 0, alphaInfo.alphaData.length);
                int offset = 0;
                int alphaOffset = 0;
                for (int y = 0; y < imageData.height; ++y) {
                    for (int x = 0; x < imageData.width; ++x) {
                        buffer[offset] = alphaInfo.alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                    }
                }
            }
        }
        rep = rep.initWithBitmapDataPlanes(0L, imageData.width, imageData.height, 8L, hasAlpha ? 4L : 3L, hasAlpha, false, OS.NSDeviceRGBColorSpace, 3L, bpr, 32L);
        C.memmove(rep.bitmapData(), buffer, (long)dataSize);
        return rep;
    }

    @Override
    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        this.handle.release();
        this.handle = null;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.alphaInfo_100.transparentPixel != image.alphaInfo_100.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        return this.handle == image.handle;
    }

    NSBitmapImageRep getRepresentation(int scaleFactor) {
        NSArray reps = this.handle.representations();
        NSSize size = this.handle.size();
        long count = reps.count();
        NSSize targetSize = new NSSize();
        targetSize.width = (int)size.width * scaleFactor / 100;
        targetSize.height = (int)size.height * scaleFactor / 100;
        int i = 0;
        while ((long)i < count) {
            NSBitmapImageRep rep = new NSBitmapImageRep(reps.objectAtIndex(i));
            if (targetSize.width == (double)rep.pixelsWide() && targetSize.height == (double)rep.pixelsHigh() && rep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return rep;
            }
            ++i;
        }
        NSBitmapImageRep newRep = this.createImageRep(targetSize);
        int i2 = 0;
        while ((long)i2 < count) {
            this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0L)));
            ++i2;
        }
        this.handle.addRepresentation(newRep);
        return newRep;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSBitmapImageRep imageRep = this.getRepresentation();
        AlphaInfo alphaInfo = this._getAlphaInfoAtCurrentZoom(imageRep);
        if (alphaInfo.transparentPixel == -1) {
            return null;
        }
        int red = alphaInfo.transparentPixel >> 16 & 0xFF;
        int green = alphaInfo.transparentPixel >> 8 & 0xFF;
        int blue = alphaInfo.transparentPixel >> 0 & 0xFF;
        return Color.cocoa_new(this.device, new double[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.width != -1 && this.height != -1) {
                Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
                return rectangle;
            }
            NSSize size = this.handle.size();
            this.width = (int)size.width;
            this.height = (int)size.height;
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    @Deprecated
    public Rectangle getBoundsInPixels() {
        Rectangle bounds = this.getBounds();
        int scaleFactor = (int)NSScreen.mainScreen().backingScaleFactor();
        bounds.width *= scaleFactor;
        bounds.height *= scaleFactor;
        return bounds;
    }

    public ImageData getImageData() {
        return this.getImageData(100);
    }

    @Deprecated
    public ImageData getImageDataAtCurrentZoom() {
        return this.getImageData(DPIUtil.getDeviceZoom());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (zoom == 100) {
                NSBitmapImageRep imageRep = this.getRepresentation(100);
                ImageData imageData = this._getImageData(imageRep, this.alphaInfo_100);
                return imageData;
            }
            if (zoom == 200) {
                NSBitmapImageRep imageRep200 = this.getRepresentation(200);
                if (this.alphaInfo_100.alphaData != null && this.alphaInfo_200 != null && this.alphaInfo_200.alphaData == null) {
                    this.initAlpha_200(imageRep200);
                }
                if (this.alphaInfo_200 == null) {
                    this.initAlpha_200(imageRep200);
                }
                ImageData imageData = this._getImageData(imageRep200, this.alphaInfo_200);
                return imageData;
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
        return DPIUtil.autoScaleImageData(this.device, this.getImageData(100), zoom, 100);
    }

    NSBitmapImageRep getRepresentation() {
        return this.getRepresentation(DPIUtil.getDeviceZoom());
    }

    NSBitmapImageRep createImageRep(NSSize targetSize) {
        return ImageUtil.createImageRep(this, targetSize);
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.width = width;
        this.height = height;
        this.handle = (NSImage)new NSImage().alloc();
        NSSize size = new NSSize();
        size.width = width;
        size.height = height;
        this.handle = this.handle.initWithSize(size);
        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, 3L, false, false, OS.NSDeviceRGBColorSpace, 3L, width * 4, 32L);
        C.memset(rep.bitmapData(), 255, width * height * 4);
        this.handle.addRepresentation(rep);
        rep.release();
        this.handle.setCacheMode(3L);
        if (this.alphaInfo_100 == null) {
            this.alphaInfo_100 = new AlphaInfo();
        }
    }

    void init(ImageData image) {
        if (image == null) {
            SWT.error(4);
        }
        if (this.handle != null) {
            this.handle.release();
        }
        this.handle = (NSImage)new NSImage().alloc();
        NSSize size = new NSSize();
        size.width = this.width;
        size.height = this.height;
        this.handle = this.handle.initWithSize(size);
        this.width = image.width;
        this.height = image.height;
        if (this.alphaInfo_100 == null) {
            this.alphaInfo_100 = new AlphaInfo();
        }
        NSBitmapImageRep rep = this.createRepresentation(image, this.alphaInfo_100);
        this.handle.addRepresentation(rep);
        rep.release();
        this.handle.setCacheMode(3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAlpha_200(NSBitmapImageRep nativeRep) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int width = (int)nativeRep.pixelsWide();
            int height = (int)nativeRep.pixelsHigh();
            boolean hasAlpha = nativeRep.hasAlpha();
            int bpr = width * 4;
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, hasAlpha ? 4L : 3L, hasAlpha, false, OS.NSDeviceRGBColorSpace, 3L, bpr, 32L);
            if (this.alphaInfo_200 == null) {
                this.alphaInfo_200 = new AlphaInfo();
            }
            this.alphaInfo_200.init(nativeRep, rep);
            rep.release();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAlpha_100(NSBitmapImageRep nativeRep) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int width = (int)nativeRep.pixelsWide();
            int height = (int)nativeRep.pixelsHigh();
            boolean hasAlpha = nativeRep.hasAlpha();
            int bpr = width * 4;
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, hasAlpha ? 4L : 3L, hasAlpha, false, OS.NSDeviceRGBColorSpace, 3L, bpr, 32L);
            if (this.alphaInfo_100 == null) {
                this.alphaInfo_100 = new AlphaInfo();
            }
            this.alphaInfo_100.init(nativeRep, rep);
            rep.release();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNative(String filename) {
        NSAutoreleasePool pool = null;
        NSImage nativeImage = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            nativeImage = new NSImage();
            nativeImage.alloc();
            nativeImage = nativeImage.initWithContentsOfFile(NSString.stringWith(filename));
            if (nativeImage == null) {
                return;
            }
            NSImageRep nativeRep = nativeImage.bestRepresentationForDevice(null);
            if (!nativeRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return;
            }
            this.width = (int)nativeRep.pixelsWide();
            this.height = (int)nativeRep.pixelsHigh();
            boolean hasAlpha = nativeRep.hasAlpha();
            int bpr = this.width * 4;
            this.handle = (NSImage)new NSImage().alloc();
            NSSize size = new NSSize();
            size.width = this.width;
            size.height = this.height;
            this.handle = this.handle.initWithSize(size);
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, this.width, this.height, 8L, hasAlpha ? 4L : 3L, hasAlpha, false, OS.NSDeviceRGBColorSpace, 3L, bpr, 32L);
            this.handle.addRepresentation(rep);
            rep.release();
            this.handle.setCacheMode(3L);
            if (this.alphaInfo_100 == null) {
                this.alphaInfo_100 = new AlphaInfo();
            }
            this.alphaInfo_100.init(nativeRep, rep);
            this.type = filename.toLowerCase().endsWith(".ico") ? 1 : 0;
        }
        finally {
            if (nativeImage != null) {
                nativeImage.release();
            }
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long internal_new_GC(GCData data) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSGraphicsContext flippedContext;
            int scaleFactor = DPIUtil.getDeviceZoom() / 100;
            NSBitmapImageRep imageRep = this.getRepresentation();
            NSGraphicsContext context = NSGraphicsContext.graphicsContextWithBitmapImageRep(imageRep);
            if (context == null) {
                imageRep.setAlpha(false);
                context = NSGraphicsContext.graphicsContextWithBitmapImageRep(imageRep);
            }
            context = flippedContext = NSGraphicsContext.graphicsContextWithGraphicsPort(context.graphicsPort(), true);
            context.retain();
            if (data != null) {
                data.flippedContext = flippedContext;
            }
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(context);
            NSAffineTransform transform = NSAffineTransform.transform();
            NSSize size = this.handle.size();
            transform.translateXBy(0.0, size.height * (double)scaleFactor);
            transform.scaleXBy(scaleFactor, -scaleFactor);
            transform.set();
            NSGraphicsContext.static_restoreGraphicsState();
            if (data != null) {
                int mask = 0x6000000;
                if ((data.style & mask) == 0) {
                    data.style |= 0x2000000;
                }
                data.device = this.device;
                data.background = this.device.COLOR_WHITE.handle;
                data.foreground = this.device.COLOR_BLACK.handle;
                data.font = this.device.systemFont;
                data.image = this;
            }
            long l = context.id;
            return l;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        long context = hDC;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (context != 0L) {
                NSBitmapImageRep imageRep = this.getRepresentation();
                imageRep.bitmapData();
                NSGraphicsContext contextObj = new NSGraphicsContext(context);
                contextObj.release();
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int blueOffset;
            int greenOffset;
            int redOffset;
            NSBitmapImageRep imageRep = this.getRepresentation();
            AlphaInfo alphaInfo = this._getAlphaInfoAtCurrentZoom(imageRep);
            if (alphaInfo.transparentPixel == -1) {
                return;
            }
            byte red = (byte)(alphaInfo.transparentPixel >> 16 & 0xFF);
            byte green = (byte)(alphaInfo.transparentPixel >> 8 & 0xFF);
            byte blue = (byte)(alphaInfo.transparentPixel >> 0 & 0xFF);
            byte newRed = (byte)((int)(color.handle[0] * 255.0) & 0xFF);
            byte newGreen = (byte)((int)(color.handle[1] * 255.0) & 0xFF);
            byte newBlue = (byte)((int)(color.handle[2] * 255.0) & 0xFF);
            long height = imageRep.pixelsHigh();
            long bpr = imageRep.bytesPerRow();
            long data = imageRep.bitmapData();
            long format = imageRep.bitmapFormat();
            long bpp = imageRep.bitsPerPixel();
            if (bpp == 32L && (format & 1L) == 0L) {
                redOffset = 0;
                greenOffset = 1;
                blueOffset = 2;
            } else {
                redOffset = 1;
                greenOffset = 2;
                blueOffset = 3;
            }
            byte[] line = new byte[(int)bpr];
            int i = 0;
            int offset = 0;
            while ((long)i < height) {
                C.memmove(line, data + (long)offset, bpr);
                for (int j = 0; j < line.length; j += 4) {
                    if (line[j + redOffset] != red || line[j + greenOffset] != green || line[j + blueOffset] != blue) continue;
                    line[j + redOffset] = newRed;
                    line[j + greenOffset] = newGreen;
                    line[j + blueOffset] = newBlue;
                }
                C.memmove(data + (long)offset, line, bpr);
                ++i;
                offset = (int)((long)offset + bpr);
            }
            alphaInfo.transparentPixel = (newRed & 0xFF) << 16 | (newGreen & 0xFF) << 8 | newBlue & 0xFF;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    static class AlphaInfo {
        byte[] alphaData;
        int alpha = -1;
        int transparentPixel = -1;

        AlphaInfo() {
        }

        void init(NSImageRep nativeRep, NSBitmapImageRep rep) {
            int width = (int)nativeRep.pixelsWide();
            int height = (int)nativeRep.pixelsHigh();
            this.transparentPixel = -1;
            this.alpha = -1;
            boolean hasAlpha = rep.hasAlpha();
            int bpr = width * 4;
            NSRect rect = new NSRect();
            rect.width = width;
            rect.height = height;
            long colorspace = OS.CGColorSpaceCreateDeviceRGB();
            long ctx = OS.CGBitmapContextCreate(rep.bitmapData(), width, height, 8L, bpr, colorspace, 6);
            OS.CGColorSpaceRelease(colorspace);
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(ctx, false));
            nativeRep.drawInRect(rect);
            NSGraphicsContext.static_restoreGraphicsState();
            OS.CGContextRelease(ctx);
            if (hasAlpha) {
                long bitmapBytesPerRow = width;
                long bitmapByteCount = bitmapBytesPerRow * (long)height;
                long alphaBitmapData = C.malloc(bitmapByteCount);
                long alphaBitmapCtx = OS.CGBitmapContextCreate(alphaBitmapData, width, height, 8L, bitmapBytesPerRow, 0L, 7);
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(alphaBitmapCtx, false));
                nativeRep.drawInRect(rect);
                NSGraphicsContext.static_restoreGraphicsState();
                byte[] alphaData = new byte[(int)bitmapByteCount];
                C.memmove(alphaData, alphaBitmapData, bitmapByteCount);
                C.free(alphaBitmapData);
                OS.CGContextRelease(alphaBitmapCtx);
                byte[] srcData = new byte[height * bpr];
                C.memmove(srcData, rep.bitmapData(), (long)srcData.length);
                int a = 0;
                int p = 0;
                while (a < alphaData.length) {
                    srcData[p] = alphaData[a];
                    float alpha = alphaData[a] & 0xFF;
                    if (alpha != 0.0f) {
                        srcData[p + 1] = (byte)((float)(srcData[p + 1] & 0xFF) / alpha * 255.0f);
                        srcData[p + 2] = (byte)((float)(srcData[p + 2] & 0xFF) / alpha * 255.0f);
                        srcData[p + 3] = (byte)((float)(srcData[p + 3] & 0xFF) / alpha * 255.0f);
                    }
                    ++a;
                    p += 4;
                }
                C.memmove(rep.bitmapData(), srcData, (long)srcData.length);
                int transparentOffset = -1;
                int i = 0;
                for (i = 0; i < alphaData.length; ++i) {
                    byte alpha = alphaData[i];
                    if (transparentOffset == -1 && alpha == 0) {
                        transparentOffset = i;
                    }
                    if (alpha != 0 && alpha != -1) break;
                }
                this.alpha = -1;
                if (i == alphaData.length && transparentOffset != -1) {
                    NSColor color = rep.colorAtX(transparentOffset % width, transparentOffset / width);
                    int red = (int)(color.redComponent() * 255.0);
                    int green = (int)(color.greenComponent() * 255.0);
                    int blue = (int)(color.blueComponent() * 255.0);
                    this.transparentPixel = red << 16 | green << 8 | blue;
                    for (int j = 0; j < srcData.length; j += 4) {
                        int pixel;
                        if (srcData[j] == 0 || (pixel = (srcData[j + 1] & 0xFF) << 16 | (srcData[j + 2] & 0xFF) << 8 | srcData[j + 3] & 0xFF) != this.transparentPixel) continue;
                        this.transparentPixel = -1;
                        break;
                    }
                }
                if (this.transparentPixel == -1) {
                    this.alphaData = alphaData;
                }
            }
        }
    }
}

