/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public abstract class Device
implements Drawable {
    protected static final int CHANGE_SCALEFACTOR = 1;
    int gsettingsProc;
    Callback gsettingsCallback;
    boolean isConnected = false;
    int displaySettings;
    protected int xDisplay;
    int shellHandle;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    GdkColor[] gdkColors;
    int[] colorRefCount;
    boolean disposed;
    int logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"", "GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS", "GIO"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static int XErrorProc;
    static int XIOErrorProc;
    static int XNullErrorProc;
    static int XNullIOErrorProc;
    static Device[] Devices;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_TRANSPARENT;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    Point dpi;
    protected int scaleFactor;
    int emptyTab;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            Device.register(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.xDisplay = 0;
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != object) continue;
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
        }
    }

    static synchronized Device findDevice(int n) {
        for (int i = 0; i < Devices.length; ++i) {
            Device device = Devices[i];
            if (device == null || device.xDisplay != n) continue;
            return device;
        }
        return null;
    }

    static synchronized void deregister(Device device) {
        for (int i = 0; i < Devices.length; ++i) {
            if (device != Devices[i]) continue;
            Device.Devices[i] = null;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    private Rectangle getBoundsInPixels() {
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n;
                int n2 = 0;
                int n3 = this.objects.length;
                for (n = 0; n < n3; ++n) {
                    if (this.objects[n] == null) continue;
                    ++n2;
                }
                n = 0;
                deviceData.objects = new Object[n2];
                deviceData.errors = new Error[n2];
                for (int i = 0; i < n3; ++i) {
                    if (this.objects[i] == null) continue;
                    deviceData.objects[n] = this.objects[i];
                    deviceData.errors[n] = this.errors[i];
                    ++n;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        int n = OS.gdk_pango_context_get();
        OS.pango_context_list_families(n, nArray3, nArray4);
        int n2 = 0;
        FontData[] fontDataArray = new FontData[string != null ? 4 : nArray4[0]];
        for (int i = 0; i < nArray4[0]; ++i) {
            Object object;
            Object object2;
            int n3;
            int n4;
            OS.memmove(nArray, nArray3[0] + i * OS.PTR_SIZEOF, OS.PTR_SIZEOF);
            boolean bl2 = true;
            if (string != null) {
                n4 = OS.pango_font_family_get_name(nArray[0]);
                n3 = OS.strlen(n4);
                object2 = new byte[n3];
                OS.memmove((byte[])object2, n4, n3);
                object = new String(Converter.mbcsToWcs((byte[])object2));
                bl2 = string.equalsIgnoreCase((String)object);
            }
            if (!bl2) continue;
            OS.pango_font_family_list_faces(nArray[0], nArray5, nArray6);
            for (n4 = 0; n4 < nArray6[0]; ++n4) {
                OS.memmove(nArray2, nArray5[0] + n4 * OS.PTR_SIZEOF, OS.PTR_SIZEOF);
                n3 = OS.pango_font_face_describe(nArray2[0]);
                object2 = Font.gtk_new(this, n3);
                object = ((Font)object2).getFontData()[0];
                if (n2 == fontDataArray.length) {
                    FontData[] fontDataArray2 = new FontData[fontDataArray.length + nArray4[0]];
                    System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n2);
                    fontDataArray = fontDataArray2;
                }
                fontDataArray[n2++] = object;
                OS.pango_font_description_free(n3);
            }
            OS.g_free(nArray5[0]);
            if (string != null) break;
        }
        OS.g_free(nArray3[0]);
        OS.g_object_unref(n);
        if (n2 == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray3 = new FontData[n2];
        System.arraycopy(fontDataArray, 0, fontDataArray3, 0, n2);
        return fontDataArray3;
    }

    Point getScreenDPI() {
        int n = OS.gdk_screen_width_mm();
        int n2 = OS.gdk_screen_width();
        int n3 = Compatibility.round(254 * n2, n * 10);
        return new Point(n3, n3);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 37: {
                return this.COLOR_TRANSPARENT;
            }
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        int n;
        int n2;
        int n3;
        boolean bl;
        this.dpi = this.getDPI();
        this.scaleFactor = this.getDeviceZoom();
        DPIUtil.setDeviceZoom(this.scaleFactor);
        boolean bl2 = bl = OS.IsAIX && OS.PTR_SIZEOF == 8;
        if ((this.debug || bl) && this.xDisplay != 0) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = this.getClass();
            synchronized (clazz2) {
                int n4;
                for (n4 = 0; n4 < Devices.length && Devices[n4] == null; ++n4) {
                }
                if (n4 == Devices.length) {
                    XErrorCallback = new Callback(clazz, "XErrorProc", 2);
                    XNullErrorProc = XErrorCallback.getAddress();
                    if (XNullErrorProc == 0) {
                        SWT.error(3);
                    }
                    if ((XNullIOErrorProc = (XIOErrorCallback = new Callback(clazz, "XIOErrorProc", 1)).getAddress()) == 0) {
                        SWT.error(3);
                    }
                    XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
                    XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
                }
            }
            if (this.debug) {
                OS.XSynchronize(this.xDisplay, true);
            }
        }
        if (this.xDisplay != 0) {
            this.logCallback = new Callback(this, "logProc", 4);
            this.logProc = this.logCallback.getAddress();
            if (this.logProc == 0) {
                SWT.error(3);
            }
            if (this.debug) {
                int n5 = -1;
                for (int i = 0; i < this.log_domains.length; ++i) {
                    byte[] byArray = Converter.wcsToMbcs(this.log_domains[i], true);
                    this.handler_ids[i] = OS.g_log_set_handler(byArray, n5, this.logProc, 0);
                }
            }
        }
        this.COLOR_TRANSPARENT = new Color(this, 255, 255, 255, 0);
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.emptyTab = OS.pango_tab_array_new(1, false);
        if (this.emptyTab == 0) {
            SWT.error(2);
        }
        OS.pango_tab_array_set_tab(this.emptyTab, 0, 0, 1);
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0) {
            SWT.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        if (OS.GTK3) {
            n3 = OS.gtk_widget_get_style_context(this.shellHandle);
            n2 = OS.gtk_style_context_get_font(n3, 0);
        } else {
            n3 = OS.gtk_widget_get_style(this.shellHandle);
            n2 = OS.gtk_style_get_font_desc(n3);
        }
        n2 = OS.pango_font_description_copy(n2);
        Point point = this.getDPI();
        Point point2 = this.getScreenDPI();
        if (point.y != point2.y) {
            n = OS.pango_font_description_get_size(n2);
            OS.pango_font_description_set_size(n2, n * point.y / point2.y);
        }
        this.systemFont = Font.gtk_new(this, n2);
        if (OS.GTK3) {
            n = OS.gdk_screen_get_default();
            int n6 = OS.gtk_css_provider_new();
            String string = "";
            if (n != 0 && n6 != 0) {
                Throwable throwable;
                BufferedReader bufferedReader;
                String string2 = "";
                String string3 = System.getProperty("org.eclipse.swt.internal.gtk.cssFile");
                if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0) && string3 != null) {
                    try {
                        bufferedReader = new BufferedReader(new FileReader(new File(string3)));
                        throwable = null;
                        try {
                            string2 = bufferedReader.lines().collect(Collectors.joining("\n"));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (bufferedReader != null) {
                                if (throwable != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    bufferedReader.close();
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                string = OS.GTK_VERSION < OS.VERSION(3, 20, 0) ? "/org/eclipse/swt/internal/gtk/swtgtk_pre320.css" : "/org/eclipse/swt/internal/gtk/swtgtk_320.css";
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(Device.class.getResourceAsStream(string)));
                    throwable = null;
                    try {
                        String string4 = bufferedReader.lines().collect(Collectors.joining("\n"));
                        String string5 = string4 + string2;
                        OS.gtk_style_context_add_provider_for_screen(n, n6, 600);
                        OS.gtk_css_provider_load_from_data(n6, Converter.wcsToMbcs(string5, true), -1, null);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (bufferedReader != null) {
                            if (throwable != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                bufferedReader.close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public abstract int internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(string, true);
        return OS.FcConfigAppFontAddFile(0, byArray);
    }

    int logProc(int n, int n2, int n3, int n4) {
        if (DEBUG) {
            new Error().printStackTrace();
        }
        if (this.warningLevel == 0) {
            if (DEBUG || this.debug) {
                new Error().printStackTrace();
            }
            OS.g_log_default_handler(n, n2, n3, 0);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != null) continue;
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    static synchronized void register(Device device) {
        for (int i = 0; i < Devices.length; ++i) {
            if (Devices[i] != null) continue;
            Device.Devices[i] = device;
            return;
        }
        Device[] deviceArray = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, deviceArray, 0, Devices.length);
        deviceArray[Device.Devices.length] = device;
        Devices = deviceArray;
    }

    protected void release() {
        int n;
        if (this.shellHandle != 0) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.gdkColors != null && !OS.GTK3) {
            n = OS.gdk_colormap_get_system();
            for (int i = 0; i < this.gdkColors.length; ++i) {
                GdkColor gdkColor = this.gdkColors[i];
                if (gdkColor == null) continue;
                while (this.colorRefCount[i] > 0) {
                    OS.gdk_colormap_free_colors(n, gdkColor, 1);
                    int n2 = i;
                    this.colorRefCount[n2] = this.colorRefCount[n2] - 1;
                }
            }
        }
        this.gdkColors = null;
        this.colorRefCount = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        if (this.emptyTab != 0) {
            OS.pango_tab_array_free(this.emptyTab);
        }
        this.emptyTab = 0;
        if (this.xDisplay != 0) {
            for (n = 0; n < this.handler_ids.length; ++n) {
                if (this.handler_ids[n] == 0) continue;
                byte[] byArray = Converter.wcsToMbcs(this.log_domains[n], true);
                OS.g_log_remove_handler(byArray, this.handler_ids[n]);
                this.handler_ids[n] = 0;
            }
            this.logCallback.dispose();
            this.logCallback = null;
            this.handler_ids = null;
            this.log_domains = null;
            this.logProc = 0;
        }
        if (this.gsettingsCallback != null) {
            this.gsettingsCallback.dispose();
            this.gsettingsCallback = null;
        }
        this.gsettingsProc = 0;
    }

    public void setWarnings(boolean bl) {
        block8: {
            block7: {
                this.checkDevice();
                if (!bl) break block7;
                if (--this.warningLevel != 0) break block8;
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0) {
                    for (int i = 0; i < this.handler_ids.length; ++i) {
                        if (this.handler_ids[i] == 0) continue;
                        byte[] byArray = Converter.wcsToMbcs(this.log_domains[i], true);
                        OS.g_log_remove_handler(byArray, this.handler_ids[i]);
                        this.handler_ids[i] = 0;
                    }
                }
                break block8;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0) {
                    int n = -1;
                    for (int i = 0; i < this.log_domains.length; ++i) {
                        byte[] byArray = Converter.wcsToMbcs(this.log_domains[i], true);
                        this.handler_ids[i] = OS.g_log_set_handler(byArray, n, this.logProc, 0);
                    }
                }
            }
        }
    }

    static int XErrorProc(int n, int n2) {
        Device device = Device.findDevice(n);
        if (device != null) {
            if (device.warningLevel == 0) {
                boolean bl;
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                boolean bl2 = bl = OS.IsAIX && OS.PTR_SIZEOF == 8;
                if (!bl) {
                    OS.Call(XErrorProc, n, n2);
                }
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, n, n2);
        }
        return 0;
    }

    static int XIOErrorProc(int n) {
        Device device = Device.findDevice(n);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, n, 0);
        return 0;
    }

    int _getDPIx() {
        return this.scaleFactor * 96 / 100;
    }

    protected int getDeviceZoom() {
        int n = OS.gdk_screen_get_default();
        int n2 = (int)OS.gdk_screen_get_resolution(n);
        if (n2 <= 0) {
            n2 = 96;
        }
        if (OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            int n3 = OS.gdk_screen_get_monitor_at_point(n, 0, 0);
            int n4 = OS.gdk_screen_get_monitor_scale_factor(n, n3);
            n2 *= n4;
        }
        return DPIUtil.mapDPIToZoom(n2);
    }

    protected int gsettingsProc(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.scaleFactor = this.getDeviceZoom();
                DPIUtil.setDeviceZoom(this.scaleFactor);
            }
        }
        return 0;
    }

    static {
        Devices = new Device[4];
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

