/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;

public class FileData {
    private FileWriter fstream;
    private BufferedWriter out;
    private double yaw;
    private double roll;
    private double pitch;
    private Boolean isRecording = false;
    private Boolean isPlaying = false;
    private FileReader fr;
    private BufferedReader br;

    public boolean createFile() {
        this.isRecording = this.isRecording == false;
        if (this.isRecording.booleanValue()) {
            try {
                this.fstream = new FileWriter("SensorData.txt");
                this.out = new BufferedWriter(this.fstream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        try {
            this.out.close();
            this.fstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void recordData(double yaw, double roll, double pitch) {
        if (this.isRecording.booleanValue()) {
            try {
                String s = yaw + "," + roll + "," + pitch + "\n";
                this.out.write(s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean openFile() {
        if (this.isRecording.booleanValue()) {
            return false;
        }
        this.isPlaying = this.isPlaying == false;
        try {
            this.fr = new FileReader("SensorData.txt");
            this.br = new BufferedReader(this.fr);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean playData() {
        if (this.isRecording.booleanValue()) {
            return false;
        }
        if (this.isPlaying.booleanValue()) {
            try {
                String nextToken = this.br.readLine();
                if (nextToken == null) {
                    this.isPlaying = false;
                    return false;
                }
                Scanner scanner = new Scanner(nextToken).useDelimiter(",");
                this.yaw = Double.parseDouble(scanner.next());
                this.roll = Double.parseDouble(scanner.next());
                this.pitch = Double.parseDouble(scanner.next());
                scanner.close();
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public int getYaw() {
        return (int)this.yaw;
    }

    public int getRoll() {
        return (int)this.roll;
    }

    public int getPitch() {
        return (int)this.pitch;
    }
}

