/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

public class Vector {
    public double x;
    public double y;
    public double z;

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector(Vector v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(double[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
    }

    public void scale(double factor) {
        this.x = factor * this.x;
        this.y = factor * this.y;
        this.z = factor * this.z;
    }

    public void yaw(double yaw) {
        Vector v = new Vector(this);
        double yawRad = Math.toRadians(yaw);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        this.x = cos * v.x + sin * v.y;
        this.y = -sin * v.x + cos * v.y;
        this.z = v.z;
    }

    public void pitch(double pitch) {
        Vector v = new Vector(this);
        double pitchRad = Math.toRadians(pitch);
        double cos = Math.cos(pitchRad);
        double sin = Math.sin(pitchRad);
        this.x = v.x;
        this.y = cos * v.y + sin * v.z;
        this.z = -sin * v.y + cos * v.z;
    }

    public void roll(double roll) {
        Vector v = new Vector(this);
        double rollRad = Math.toRadians(roll);
        double cos = Math.cos(rollRad);
        double sin = Math.sin(rollRad);
        this.x = cos * v.x + sin * v.z;
        this.y = v.y;
        this.z = -sin * v.x + cos * v.z;
    }

    public void rollpitchyaw(double roll, double pitch, double yaw) {
        this.roll(roll);
        this.pitch(pitch);
        this.yaw(yaw);
    }

    public void reverserollpitchyaw(double roll, double pitch, double yaw) {
        this.yaw(-yaw);
        this.pitch(-pitch);
        this.roll(-roll);
    }
}

