/*
 * Decompiled with CFR 0.152.
 */
package com.j_phone.amuse.j3d;

import ru.woesss.j2me.micro3d.MathUtil;

public class Vector3D {
    public int x;
    public int y;
    public int z;

    public Vector3D() {
    }

    public Vector3D(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int innerProduct(Vector3D vector3D) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public static int innerProduct(Vector3D vector3D, Vector3D vector3D2) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        return vector3D.innerProduct(vector3D2);
    }

    public void outerProduct(Vector3D vector3D) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        int n2 = this.x;
        int n3 = this.y;
        int n4 = this.z;
        this.x = n3 * vector3D.z - n4 * vector3D.y;
        this.y = n4 * vector3D.x - n2 * vector3D.z;
        this.z = n2 * vector3D.y - n3 * vector3D.x;
    }

    public static Vector3D outerProduct(Vector3D vector3D, Vector3D vector3D2) {
        if (vector3D == null || vector3D2 == null) {
            throw new NullPointerException();
        }
        int n2 = vector3D.y * vector3D2.z - vector3D.z * vector3D2.y;
        int n3 = vector3D.z * vector3D2.x - vector3D.x * vector3D2.z;
        int n4 = vector3D.x * vector3D2.y - vector3D.y * vector3D2.x;
        return new Vector3D(n2, n3, n4);
    }

    public void set(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
    }

    public void setX(int n2) {
        this.x = n2;
    }

    public void setY(int n2) {
        this.y = n2;
    }

    public void setZ(int n2) {
        this.z = n2;
    }

    public void unit() {
        int n2 = this.x;
        int n3 = this.y;
        int n4 = this.z;
        int n5 = Integer.numberOfLeadingZeros(Math.abs(n2) | Math.abs(n3) | Math.abs(n4)) - 17;
        if (n5 > 0) {
            n2 <<= n5;
            n3 <<= n5;
            n4 <<= n5;
        } else if (n5 < 0) {
            n5 = -n5;
            n2 >>= n5;
            n3 >>= n5;
            n4 >>= n5;
        }
        int n6 = MathUtil.uSqrt(n2 * n2 + n3 * n3 + n4 * n4);
        if (n6 != 0) {
            this.x = (n2 << 12) / n6;
            this.y = (n3 << 12) / n6;
            this.z = (n4 << 12) / n6;
        } else {
            this.x = 0;
            this.y = 0;
            this.z = 4096;
        }
    }
}

