/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.graphics.j3d;

import com.jblend.graphics.j3d.AffineTrans;
import com.jblend.graphics.j3d.Effect3D;
import com.jblend.graphics.j3d.Figure;
import com.jblend.graphics.j3d.FigureLayout;
import com.jblend.graphics.j3d.Light;
import com.jblend.graphics.j3d.Texture;
import com.jblend.graphics.j3d.Vector3D;
import java.util.WeakHashMap;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureImpl;

public class RenderProxy {
    private static final WeakHashMap a = new WeakHashMap();

    public static void drawCommandList(Graphics graphics, Texture[] textureArray, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D, int[] nArray) {
        if (figureLayout == null || effect3D == null || nArray == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.a(graphics);
        RenderProxy.a(figureLayout.a, render.getViewMatrix(), 0);
        RenderProxy.a(render, textureArray);
        RenderProxy.a(render, figureLayout.a);
        render.setCenter(figureLayout.c + n2, figureLayout.d + n3);
        RenderProxy.a(render, figureLayout);
        RenderProxy.a(render, effect3D);
        render.drawCommandList(nArray);
    }

    public static void drawCommandList(Graphics graphics, Texture texture, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D, int[] nArray) {
        if (figureLayout == null || effect3D == null || nArray == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.a(graphics);
        RenderProxy.a(figureLayout.a, render.getViewMatrix(), 0);
        RenderProxy.a(render, figureLayout.a);
        render.setCenter(figureLayout.c + n2, figureLayout.d + n3);
        RenderProxy.a(render, figureLayout);
        RenderProxy.a(render, effect3D);
        if (texture != null) {
            render.setTexture(texture.impl);
        }
        render.drawCommandList(nArray);
    }

    public static void drawFigure(Graphics graphics, Figure figure, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D) {
        if (figure == null || figureLayout == null || effect3D == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.a(graphics);
        RenderProxy.a(figureLayout.a, render.getViewMatrix(), 0);
        render.setCenter(figureLayout.c + n2, figureLayout.d + n3);
        RenderProxy.a(render, figureLayout);
        RenderProxy.a(render, effect3D);
        Texture texture = figure.a[0];
        if (texture != null) {
            render.setTexture(texture.impl);
        }
        render.drawFigure(figure.a);
    }

    public static void flush(Graphics graphics) {
        RenderProxy.a(graphics).flushToBuffer();
    }

    public static void renderFigure(Graphics graphics, Figure figure, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D) {
        if (figure == null || figureLayout == null || effect3D == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.a(graphics);
        RenderProxy.a(figureLayout.a, render.getViewMatrix(), 0);
        RenderProxy.a(render, figure.a);
        render.setCenter(figureLayout.c + n2, figureLayout.d + n3);
        RenderProxy.a(render, figureLayout);
        RenderProxy.a(render, effect3D);
        render.postFigure(figure.a);
    }

    public static void renderPrimitives(Graphics graphics, Texture texture, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        if (figureLayout == null || effect3D == null || nArray == null || nArray2 == null || nArray3 == null || nArray4 == null) {
            throw new NullPointerException();
        }
        if (n4 < 0 || n5 <= 0 || n5 >= 256) {
            throw new IllegalArgumentException();
        }
        Render render = RenderProxy.a(graphics);
        RenderProxy.a(figureLayout.a, render.getViewMatrix(), 0);
        render.setCenter(figureLayout.c + n2, figureLayout.d + n3);
        RenderProxy.a(render, figureLayout);
        RenderProxy.a(render, effect3D);
        if (texture != null) {
            render.setTexture(texture.impl);
        }
        render.postPrimitives(n4 | n5 << 16, nArray, 0, nArray2, 0, nArray3, 0, nArray4, 0);
    }

    private static Render a(Graphics graphics) {
        Render render = (Render)a.get(graphics);
        if (render == null) {
            render = new Render();
            render.bind(graphics, false);
            a.put(graphics, render);
        }
        return render;
    }

    private static void a(AffineTrans affineTrans, float[] fArray, int n2) {
        int n3 = n2 * 12;
        fArray[n3++] = (float)affineTrans.m00 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m10 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m20 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m01 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m11 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m21 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m02 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m12 * 2.4414062E-4f;
        fArray[n3++] = (float)affineTrans.m22 * 2.4414062E-4f;
        fArray[n3++] = affineTrans.m03;
        fArray[n3++] = affineTrans.m13;
        fArray[n3] = affineTrans.m23;
    }

    private static void a(Render render, Texture[] textureArray) {
        int n2;
        if (textureArray != null && (n2 = textureArray.length) > 0) {
            if (n2 > 16) {
                n2 = 16;
            }
            TextureImpl[] textureImplArray = new TextureImpl[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Texture texture = textureArray[i2];
                if (texture == null) {
                    throw new NullPointerException();
                }
                textureImplArray[i2] = texture.impl;
            }
            render.setTextureArray(textureImplArray);
        }
    }

    private static void a(Render render, Effect3D effect3D) {
        Object object;
        int n2;
        int n3;
        int n4 = render.getAttributes();
        Light light = effect3D.a;
        if (light != null) {
            n3 = light.b;
            n2 = light.a;
            object = light.a;
            render.setLight(n3, n2, ((Vector3D)object).x, ((Vector3D)object).y, ((Vector3D)object).z);
            n4 |= 1;
        } else {
            n4 &= 0xFFFFFFFE;
        }
        n3 = effect3D.a;
        if (n3 == Effect3D.TOON_SHADING) {
            n4 |= 4;
            render.setToonParam(effect3D.d, effect3D.b, effect3D.c);
        } else {
            n4 &= 0xFFFFFFFB;
        }
        n2 = effect3D.a ? 1 : 0;
        n4 = n2 != 0 ? (n4 |= 8) : (n4 &= 0xFFFFFFF7);
        object = effect3D.a;
        if (object != null) {
            n4 |= 2;
            render.setSphereTexture(((Texture)object).impl);
        } else {
            n4 &= 0xFFFFFFFD;
        }
        render.setAttribute(n4);
    }

    private static void a(Render render, FigureLayout figureLayout) {
        switch (figureLayout.l) {
            case -1879048192: {
                int n2 = figureLayout.a;
                int n3 = figureLayout.b;
                render.setOrthographicScale(n2, n3);
                break;
            }
            case -1862270976: {
                int n4 = figureLayout.e;
                int n5 = figureLayout.f;
                render.setOrthographicWH(n4, n5);
                break;
            }
            case -1845493760: {
                int n6 = figureLayout.g;
                int n7 = figureLayout.h;
                int n8 = figureLayout.i;
                render.setPerspectiveFov(n6, n7, n8);
                break;
            }
            case -1828716544: {
                int n9 = figureLayout.j;
                int n10 = figureLayout.k;
                int n11 = figureLayout.g;
                int n12 = figureLayout.h;
                render.setPerspectiveWH(n11, n12, n9, n10);
                break;
            }
        }
    }

    private static void a(Render render, AffineTrans[] affineTransArray) {
        if (affineTransArray != null) {
            int n2 = affineTransArray.length;
            float[] fArray = new float[n2 * 12];
            for (int i2 = 0; i2 < n2; ++i2) {
                RenderProxy.a(affineTransArray[i2], fArray, i2);
            }
            render.setViewTransArray(fArray);
        }
    }
}

