/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.ui.maker;

import com.nttdocomo.io.ConnectionException;
import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.UIException;
import com.nttdocomo.ui.maker.ImageImpl;
import com.nttdocomo.ui.maker.MediaImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MediaImage
extends MediaImpl
implements com.nttdocomo.ui.MediaImage {
    public MediaImage(String string) {
        super(string);
    }

    public MediaImage(InputStream inputStream) {
        super(inputStream);
    }

    public MediaImage(byte[] byArray) {
        super(byArray);
    }

    @Override
    public Image getImage() {
        return (Image)this.resource;
    }

    @Override
    public int getWidth() {
        return this.getImage().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getImage().getHeight();
    }

    @Override
    public void use() throws ConnectionException, UIException {
        try {
            this.useResource();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            throw new UIException();
        }
    }

    protected byte[] readPNGFromStream(DataInputStream dataInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(dataInputStream.readInt());
        dataOutputStream.writeInt(dataInputStream.readInt());
        boolean bl2 = false;
        while (!bl2) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            if (n3 == 1229278788) {
                bl2 = true;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                dataOutputStream.writeByte(dataInputStream.readByte());
            }
            dataOutputStream.writeInt(dataInputStream.readInt());
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    protected Object loadResource(InputStream inputStream) throws IOException {
        Object object = null;
        if (inputStream.markSupported()) {
            inputStream.mark(4);
            byte[] byArray = new byte[4];
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray);
            if (new String(byArray).equals("\u2030PNG")) {
                dataInputStream.reset();
                object = this.loadResource(this.readPNGFromStream(dataInputStream));
            } else {
                inputStream.reset();
            }
        }
        if (object == null) {
            object = new ImageImpl(javax.microedition.lcdui.Image.createImage(inputStream));
        }
        return object;
    }

    @Override
    protected Object loadResource(byte[] byArray) throws IOException {
        return new ImageImpl(javax.microedition.lcdui.Image.createImage(byArray, 0, byArray.length));
    }

    @Override
    public void unuse() {
    }

    @Override
    public void dispose() {
        this.resource = null;
    }
}

