/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Klass;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure$1;
import com.sun.jna.Structure$2;
import com.sun.jna.Structure$3;
import com.sun.jna.Structure$AutoAllocated;
import com.sun.jna.Structure$ByReference;
import com.sun.jna.Structure$ByValue;
import com.sun.jna.Structure$FFIType;
import com.sun.jna.Structure$FieldOrder;
import com.sun.jna.Structure$LayoutInfo;
import com.sun.jna.Structure$StructField;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Structure {
    private static final Logger LOG = Logger.getLogger(Structure.class.getName());
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    protected static final int CALCULATE_SIZE = -1;
    static final Map layoutInfo = new WeakHashMap();
    static final Map fieldOrder = new WeakHashMap();
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private String encoding;
    private int actualAlignType;
    private int structAlignment;
    private Map structFields;
    private final Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;
    private long typeInfo;
    private boolean autoRead = true;
    private boolean autoWrite = true;
    private Structure[] array;
    private boolean readCalled;
    private static final ThreadLocal reads = new Structure$1();
    private static final ThreadLocal busy = new Structure$2();
    private static final Pointer PLACEHOLDER_MEMORY = new Structure$3(0L);

    protected Structure() {
        this(0);
    }

    protected Structure(TypeMapper typeMapper) {
        this(null, 0, typeMapper);
    }

    protected Structure(int n2) {
        this(null, n2);
    }

    protected Structure(int n2, TypeMapper typeMapper) {
        this(null, n2, typeMapper);
    }

    protected Structure(Pointer pointer) {
        this(pointer, 0);
    }

    protected Structure(Pointer pointer, int n2) {
        this(pointer, n2, null);
    }

    protected Structure(Pointer pointer, int n2, TypeMapper typeMapper) {
        this.setAlignType(n2);
        this.setStringEncoding(Native.getStringEncoding(this.getClass()));
        this.initializeTypeMapper(typeMapper);
        this.validateFields();
        if (pointer != null) {
            this.useMemory(pointer, 0, true);
        } else {
            this.allocateMemory(-1);
        }
        this.initializeFields();
    }

    Map fields() {
        return this.structFields;
    }

    TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    private void initializeTypeMapper(TypeMapper typeMapper) {
        if (typeMapper == null) {
            typeMapper = Native.getTypeMapper(this.getClass());
        }
        this.typeMapper = typeMapper;
        this.layoutChanged();
    }

    private void layoutChanged() {
        if (this.size != -1) {
            this.size = -1;
            if (this.memory instanceof Structure$AutoAllocated) {
                this.memory = null;
            }
            this.ensureAllocated();
        }
    }

    protected void setStringEncoding(String string) {
        this.encoding = string;
    }

    protected String getStringEncoding() {
        return this.encoding;
    }

    protected void setAlignType(int n2) {
        this.alignType = n2;
        if (n2 == 0 && (n2 = Native.getStructureAlignment(this.getClass())) == 0) {
            n2 = Platform.isWindows() ? 3 : 2;
        }
        this.actualAlignType = n2;
        this.layoutChanged();
    }

    protected Memory autoAllocate(int n2) {
        return new Structure$AutoAllocated(n2);
    }

    protected void useMemory(Pointer pointer) {
        this.useMemory(pointer, 0);
    }

    protected void useMemory(Pointer pointer, int n2) {
        this.useMemory(pointer, n2, false);
    }

    void useMemory(Pointer pointer, int n2, boolean bl2) {
        try {
            this.nativeStrings.clear();
            if (this instanceof Structure$ByValue && !bl2) {
                byte[] byArray = new byte[this.size()];
                pointer.read(0L, byArray, 0, byArray.length);
                this.memory.write(0L, byArray, 0, byArray.length);
            } else {
                this.memory = pointer.share(n2);
                if (this.size == -1) {
                    this.size = this.calculateSize(false);
                }
                if (this.size != -1) {
                    this.memory = pointer.share(n2, this.size);
                }
            }
            this.array = null;
            this.readCalled = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Structure exceeds provided memory bounds", indexOutOfBoundsException);
        }
    }

    protected void ensureAllocated() {
        this.ensureAllocated(false);
    }

    private void ensureAllocated(boolean bl2) {
        if (this.memory == null) {
            this.allocateMemory(bl2);
        } else if (this.size == -1) {
            this.size = this.calculateSize(true, bl2);
            if (!(this.memory instanceof Structure$AutoAllocated)) {
                try {
                    this.memory = this.memory.share(0L, this.size);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Structure exceeds provided memory bounds", indexOutOfBoundsException);
                }
            }
        }
    }

    protected void allocateMemory() {
        this.allocateMemory(false);
    }

    private void allocateMemory(boolean bl2) {
        this.allocateMemory(this.calculateSize(true, bl2));
    }

    protected void allocateMemory(int n2) {
        if (n2 == -1) {
            n2 = this.calculateSize(false);
        } else if (n2 <= 0) {
            throw new IllegalArgumentException("Structure size must be greater than zero: " + n2);
        }
        if (n2 != -1) {
            if (this.memory == null || this.memory instanceof Structure$AutoAllocated) {
                this.memory = this.autoAllocate(n2);
            }
            this.size = n2;
        }
    }

    public int size() {
        this.ensureAllocated();
        return this.size;
    }

    public void clear() {
        this.ensureAllocated();
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    static Set busy() {
        return (Set)busy.get();
    }

    static Map reading() {
        return (Map)reads.get();
    }

    void conditionalAutoRead() {
        if (!this.readCalled) {
            this.autoRead();
        }
    }

    public void read() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.readCalled = true;
        this.ensureAllocated();
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        if (this instanceof Structure$ByReference) {
            Structure.reading().put(this.getPointer(), this);
        }
        try {
            for (Structure$StructField structure$StructField : this.fields().values()) {
                this.readField(structure$StructField);
            }
        }
        finally {
            Structure.busy().remove(this);
            if (Structure.reading().get(this.getPointer()) == this) {
                Structure.reading().remove(this.getPointer());
            }
        }
    }

    protected int fieldOffset(String string) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = (Structure$StructField)this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: " + string);
        }
        return structure$StructField.offset;
    }

    public Object readField(String string) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = (Structure$StructField)this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: " + string);
        }
        return this.readField(structure$StructField);
    }

    Object getFieldValue(Field field) {
        try {
            return field.get(this);
        }
        catch (Exception exception) {
            throw new Error("Exception reading field '" + field.getName() + "' in " + this.getClass(), exception);
        }
    }

    void setFieldValue(Field field, Object object) {
        this.setFieldValue(field, object, false);
    }

    private void setFieldValue(Field field, Object object, boolean bl2) {
        try {
            field.set(this, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            int n2 = field.getModifiers();
            if (Modifier.isFinal(n2)) {
                if (bl2) {
                    throw new UnsupportedOperationException("This VM does not support Structures with final fields (field '" + field.getName() + "' within " + this.getClass() + ")", illegalAccessException);
                }
                throw new UnsupportedOperationException("Attempt to write to read-only field '" + field.getName() + "' within " + this.getClass(), illegalAccessException);
            }
            throw new Error("Unexpectedly unable to write to field '" + field.getName() + "' within " + this.getClass(), illegalAccessException);
        }
    }

    static Structure updateStructureByReference(Class clazz, Structure structure, Pointer pointer) {
        if (pointer == null) {
            structure = null;
        } else if (structure == null || !pointer.equals(structure.getPointer())) {
            Structure structure2 = (Structure)Structure.reading().get(pointer);
            if (structure2 != null && clazz.equals(structure2.getClass())) {
                structure = structure2;
                structure.autoRead();
            } else {
                structure = Structure.newInstance(clazz, pointer);
                structure.conditionalAutoRead();
            }
        } else {
            structure.autoRead();
        }
        return structure;
    }

    protected Object readField(Structure$StructField structure$StructField) {
        Pointer pointer;
        Object object;
        int n2 = structure$StructField.offset;
        Class clazz = structure$StructField.type;
        FromNativeConverter fromNativeConverter = structure$StructField.readConverter;
        if (fromNativeConverter != null) {
            clazz = fromNativeConverter.nativeType();
        }
        Object object2 = object = Structure.class.isAssignableFrom(clazz) || Callback.class.isAssignableFrom(clazz) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz) || NativeMapped.class.isAssignableFrom(clazz) || clazz.isArray() ? this.getFieldValue(structure$StructField.field) : null;
        Object object3 = clazz == String.class ? ((pointer = this.memory.getPointer(n2)) == null ? null : pointer.getString(0L, this.encoding)) : this.memory.getValue(n2, clazz, object);
        if (fromNativeConverter != null) {
            object3 = fromNativeConverter.fromNative(object3, structure$StructField.context);
            if (object != null && object.equals(object3)) {
                object3 = object;
            }
        }
        if (clazz.equals(String.class) || clazz.equals(WString.class)) {
            this.nativeStrings.put(structure$StructField.name + ".ptr", this.memory.getPointer(n2));
            this.nativeStrings.put(structure$StructField.name + ".val", object3);
        }
        this.setFieldValue(structure$StructField.field, object3, true);
        return object3;
    }

    public void write() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.ensureAllocated();
        if (this instanceof Structure$ByValue) {
            this.getTypeInfo();
        }
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        try {
            for (Structure$StructField structure$StructField : this.fields().values()) {
                if (structure$StructField.isVolatile) continue;
                this.writeField(structure$StructField);
            }
        }
        finally {
            Structure.busy().remove(this);
        }
    }

    public void writeField(String string) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = (Structure$StructField)this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: " + string);
        }
        this.writeField(structure$StructField);
    }

    public void writeField(String string, Object object) {
        this.ensureAllocated();
        Structure$StructField structure$StructField = (Structure$StructField)this.fields().get(string);
        if (structure$StructField == null) {
            throw new IllegalArgumentException("No such field: " + string);
        }
        this.setFieldValue(structure$StructField.field, object);
        this.writeField(structure$StructField);
    }

    protected void writeField(Structure$StructField structure$StructField) {
        CharSequence charSequence;
        if (structure$StructField.isReadOnly) {
            return;
        }
        int n2 = structure$StructField.offset;
        Object object = this.getFieldValue(structure$StructField.field);
        Class clazz = structure$StructField.type;
        ToNativeConverter toNativeConverter = structure$StructField.writeConverter;
        if (toNativeConverter != null) {
            object = toNativeConverter.toNative(object, new StructureWriteContext(this, structure$StructField.field));
            clazz = toNativeConverter.nativeType();
        }
        if (String.class == clazz || WString.class == clazz) {
            boolean bl2;
            boolean bl3 = bl2 = clazz == WString.class;
            if (object != null) {
                if (this.nativeStrings.containsKey(structure$StructField.name + ".ptr") && object.equals(this.nativeStrings.get(structure$StructField.name + ".val"))) {
                    return;
                }
                charSequence = bl2 ? new NativeString(object.toString(), true) : new NativeString(object.toString(), this.encoding);
                this.nativeStrings.put(structure$StructField.name, charSequence);
                object = ((NativeString)charSequence).getPointer();
            } else {
                this.nativeStrings.remove(structure$StructField.name);
            }
            this.nativeStrings.remove(structure$StructField.name + ".ptr");
            this.nativeStrings.remove(structure$StructField.name + ".val");
        }
        try {
            this.memory.setValue(n2, object, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            charSequence = "Structure field \"" + structure$StructField.name + "\" was declared as " + structure$StructField.type + (structure$StructField.type == clazz ? "" : " (native type " + clazz + ")") + ", which is not supported within a Structure";
            throw new IllegalArgumentException((String)charSequence, illegalArgumentException);
        }
    }

    protected List getFieldOrder() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Class<?> clazz = this.getClass(); clazz != Structure.class; clazz = clazz.getSuperclass()) {
            Structure$FieldOrder structure$FieldOrder = clazz.getAnnotation(Structure$FieldOrder.class);
            if (structure$FieldOrder == null) continue;
            linkedList.addAll(0, Arrays.asList(structure$FieldOrder.value()));
        }
        return Collections.unmodifiableList(linkedList);
    }

    protected void sortFields(List list2, List list3) {
        block0: for (int i2 = 0; i2 < list3.size(); ++i2) {
            String string = (String)list3.get(i2);
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                Field field = (Field)list2.get(i3);
                if (!string.equals(field.getName())) continue;
                Collections.swap(list2, i2, i3);
                continue block0;
            }
        }
    }

    protected List getFieldList() {
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = this.getClass();
        while (!clazz.equals(Structure.class)) {
            ArrayList<Field> arrayList2 = new ArrayList<Field>();
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                int n2 = fieldArray[i2].getModifiers();
                if (Modifier.isStatic(n2) || !Modifier.isPublic(n2)) continue;
                arrayList2.add(fieldArray[i2]);
            }
            arrayList.addAll(0, arrayList2);
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List fieldOrder() {
        Class<?> clazz = this.getClass();
        Map map = fieldOrder;
        synchronized (map) {
            List list2 = (List)fieldOrder.get(clazz);
            if (list2 == null) {
                list2 = this.getFieldOrder();
                fieldOrder.put(clazz, list2);
            }
            return list2;
        }
    }

    public static List createFieldsOrder(List list2, String ... stringArray) {
        return Structure.createFieldsOrder(list2, Arrays.asList(stringArray));
    }

    public static List createFieldsOrder(List list2, List list3) {
        ArrayList arrayList = new ArrayList(list2.size() + list3.size());
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        return Collections.unmodifiableList(arrayList);
    }

    public static List createFieldsOrder(String string) {
        return Collections.unmodifiableList(Collections.singletonList(string));
    }

    public static List createFieldsOrder(String ... stringArray) {
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    private static List sort(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    protected List getFields(boolean bl2) {
        HashSet hashSet3;
        List list2 = this.getFieldList();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (HashSet hashSet3 : list2) {
            hashSet2.add(((Field)((Object)hashSet3)).getName());
        }
        List list3 = this.fieldOrder();
        if (list3.size() != list2.size() && list2.size() > 1) {
            if (bl2) {
                throw new Error("Structure.getFieldOrder() on " + this.getClass() + (list3.size() < list2.size() ? " does not provide enough" : " provides too many") + " names [" + list3.size() + "] (" + Structure.sort(list3) + ") to match declared fields [" + list2.size() + "] (" + Structure.sort(hashSet2) + ")");
            }
            return null;
        }
        hashSet3 = new HashSet(list3);
        if (!hashSet3.equals(hashSet2)) {
            throw new Error("Structure.getFieldOrder() on " + this.getClass() + " returns names (" + Structure.sort(list3) + ") which do not match declared field names (" + Structure.sort(hashSet2) + ")");
        }
        this.sortFields(list2, list3);
        return list2;
    }

    protected int calculateSize(boolean bl2) {
        return this.calculateSize(bl2, false);
    }

    static int size(Class clazz) {
        return Structure.size(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int size(Class clazz, Structure structure) {
        int n2;
        Structure$LayoutInfo structure$LayoutInfo;
        Map map = layoutInfo;
        synchronized (map) {
            structure$LayoutInfo = (Structure$LayoutInfo)layoutInfo.get(clazz);
        }
        int n3 = n2 = structure$LayoutInfo != null && !Structure$LayoutInfo.access$000(structure$LayoutInfo) ? Structure$LayoutInfo.access$100(structure$LayoutInfo) : -1;
        if (n2 == -1) {
            if (structure == null) {
                structure = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
            }
            n2 = structure.size();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calculateSize(boolean bl2, boolean bl3) {
        Structure$LayoutInfo structure$LayoutInfo;
        int n2 = -1;
        Class<?> clazz = this.getClass();
        Map map = layoutInfo;
        synchronized (map) {
            structure$LayoutInfo = (Structure$LayoutInfo)layoutInfo.get(clazz);
        }
        if (structure$LayoutInfo == null || this.alignType != Structure$LayoutInfo.access$200(structure$LayoutInfo) || this.typeMapper != Structure$LayoutInfo.access$300(structure$LayoutInfo)) {
            structure$LayoutInfo = this.deriveLayout(bl2, bl3);
        }
        if (structure$LayoutInfo != null) {
            this.structAlignment = Structure$LayoutInfo.access$400(structure$LayoutInfo);
            this.structFields = Structure$LayoutInfo.access$500(structure$LayoutInfo);
            if (!Structure$LayoutInfo.access$000(structure$LayoutInfo)) {
                map = layoutInfo;
                synchronized (map) {
                    if (!layoutInfo.containsKey(clazz) || this.alignType != 0 || this.typeMapper != null) {
                        layoutInfo.put(clazz, structure$LayoutInfo);
                    }
                }
            }
            n2 = Structure$LayoutInfo.access$100(structure$LayoutInfo);
        }
        return n2;
    }

    private void validateField(String string, Class clazz) {
        ToNativeConverter toNativeConverter;
        if (this.typeMapper != null && (toNativeConverter = this.typeMapper.getToNativeConverter(clazz)) != null) {
            this.validateField(string, toNativeConverter.nativeType());
            return;
        }
        if (clazz.isArray()) {
            this.validateField(string, clazz.getComponentType());
        } else {
            try {
                this.getNativeSize(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "Invalid Structure field in " + this.getClass() + ", field name '" + string + "' (" + clazz + "): " + illegalArgumentException.getMessage();
                throw new IllegalArgumentException(string2, illegalArgumentException);
            }
        }
    }

    private void validateFields() {
        List list2 = this.getFieldList();
        for (Field field : list2) {
            this.validateField(field.getName(), field.getType());
        }
    }

    private Structure$LayoutInfo deriveLayout(boolean bl2, boolean bl3) {
        int n2 = 0;
        List list2 = this.getFields(bl2);
        if (list2 == null) {
            return null;
        }
        Structure$LayoutInfo structure$LayoutInfo = new Structure$LayoutInfo(null);
        Structure$LayoutInfo.access$202(structure$LayoutInfo, this.alignType);
        Structure$LayoutInfo.access$302(structure$LayoutInfo, this.typeMapper);
        boolean bl4 = true;
        for (Field field : list2) {
            int n3 = field.getModifiers();
            Class clazz = field.getType();
            if (clazz.isArray()) {
                Structure$LayoutInfo.access$002(structure$LayoutInfo, true);
            }
            Structure$StructField structure$StructField = new Structure$StructField();
            structure$StructField.isVolatile = Modifier.isVolatile(n3);
            structure$StructField.isReadOnly = Modifier.isFinal(n3);
            if (structure$StructField.isReadOnly) {
                if (!Platform.RO_FIELDS) {
                    throw new IllegalArgumentException("This VM does not support read-only fields (field '" + field.getName() + "' within " + this.getClass() + ")");
                }
                field.setAccessible(true);
            }
            structure$StructField.field = field;
            structure$StructField.name = field.getName();
            structure$StructField.type = clazz;
            if (Callback.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
                throw new IllegalArgumentException("Structure Callback field '" + field.getName() + "' must be an interface");
            }
            if (clazz.isArray() && Structure.class.equals(clazz.getComponentType())) {
                String string = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(string);
            }
            int n4 = 1;
            if (Modifier.isPublic(field.getModifiers())) {
                Object object;
                ToNativeConverter toNativeConverter;
                Object object2 = this.getFieldValue(structure$StructField.field);
                if (object2 == null && clazz.isArray()) {
                    if (bl2) {
                        throw new IllegalStateException("Array fields must be initialized");
                    }
                    return null;
                }
                Class clazz2 = clazz;
                if (NativeMapped.class.isAssignableFrom(clazz)) {
                    toNativeConverter = NativeMappedConverter.getInstance(clazz);
                    clazz2 = ((NativeMappedConverter)toNativeConverter).nativeType();
                    structure$StructField.writeConverter = toNativeConverter;
                    structure$StructField.readConverter = toNativeConverter;
                    structure$StructField.context = new StructureReadContext(this, field);
                } else if (this.typeMapper != null) {
                    toNativeConverter = this.typeMapper.getToNativeConverter(clazz);
                    object = this.typeMapper.getFromNativeConverter(clazz);
                    if (toNativeConverter != null && object != null) {
                        clazz2 = (object2 = toNativeConverter.toNative(object2, new StructureWriteContext(this, structure$StructField.field))) != null ? object2.getClass() : Pointer.class;
                        structure$StructField.writeConverter = toNativeConverter;
                        structure$StructField.readConverter = object;
                        structure$StructField.context = new StructureReadContext(this, field);
                    } else if (toNativeConverter != null || object != null) {
                        String string = "Structures require bidirectional type conversion for " + clazz;
                        throw new IllegalArgumentException(string);
                    }
                }
                if (object2 == null) {
                    object2 = this.initializeField(structure$StructField.field, clazz);
                }
                try {
                    structure$StructField.size = this.getNativeSize(clazz2, object2);
                    n4 = this.getNativeAlignment(clazz2, object2, bl4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!bl2 && this.typeMapper == null) {
                        return null;
                    }
                    object = "Invalid Structure field in " + this.getClass() + ", field name '" + structure$StructField.name + "' (" + structure$StructField.type + "): " + illegalArgumentException.getMessage();
                    throw new IllegalArgumentException((String)object, illegalArgumentException);
                }
                if (n4 == 0) {
                    throw new Error("Field alignment is zero for field '" + structure$StructField.name + "' within " + this.getClass());
                }
                Structure$LayoutInfo.access$402(structure$LayoutInfo, Math.max(Structure$LayoutInfo.access$400(structure$LayoutInfo), n4));
                if (n2 % n4 != 0) {
                    n2 += n4 - n2 % n4;
                }
                if (this instanceof Union) {
                    structure$StructField.offset = 0;
                    n2 = Math.max(n2, structure$StructField.size);
                } else {
                    structure$StructField.offset = n2;
                    n2 += structure$StructField.size;
                }
                Structure$LayoutInfo.access$500(structure$LayoutInfo).put(structure$StructField.name, structure$StructField);
                if (Structure$LayoutInfo.access$700(structure$LayoutInfo) == null || Structure$LayoutInfo.access$700((Structure$LayoutInfo)structure$LayoutInfo).size < structure$StructField.size || Structure$LayoutInfo.access$700((Structure$LayoutInfo)structure$LayoutInfo).size == structure$StructField.size && Structure.class.isAssignableFrom(structure$StructField.type)) {
                    Structure$LayoutInfo.access$702(structure$LayoutInfo, structure$StructField);
                }
            }
            bl4 = false;
        }
        if (n2 > 0) {
            int n5 = this.addPadding(n2, Structure$LayoutInfo.access$400(structure$LayoutInfo));
            if (this instanceof Structure$ByValue && !bl3) {
                this.getTypeInfo();
            }
            Structure$LayoutInfo.access$102(structure$LayoutInfo, n5);
            return structure$LayoutInfo;
        }
        throw new IllegalArgumentException("Structure " + this.getClass() + " has unknown or zero size (ensure all fields are public)");
    }

    private void initializeFields() {
        List list2 = this.getFieldList();
        for (Field field : list2) {
            try {
                Object object = field.get(this);
                if (object != null) continue;
                this.initializeField(field, field.getType());
            }
            catch (Exception exception) {
                throw new Error("Exception reading field '" + field.getName() + "' in " + this.getClass(), exception);
            }
        }
    }

    private Object initializeField(Field field, Class clazz) {
        Object object = null;
        if (Structure.class.isAssignableFrom(clazz) && !Structure$ByReference.class.isAssignableFrom(clazz)) {
            try {
                object = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
                this.setFieldValue(field, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = "Can't determine size of nested structure";
                throw new IllegalArgumentException(string, illegalArgumentException);
            }
        } else if (NativeMapped.class.isAssignableFrom(clazz)) {
            NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
            object = nativeMappedConverter.defaultValue();
            this.setFieldValue(field, object);
        }
        return object;
    }

    private int addPadding(int n2) {
        return this.addPadding(n2, this.structAlignment);
    }

    private int addPadding(int n2, int n3) {
        if (this.actualAlignType != 1 && n2 % n3 != 0) {
            n2 += n3 - n2 % n3;
        }
        return n2;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    protected int getNativeAlignment(Class clazz, Object object, boolean bl2) {
        int n2 = 1;
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
            clazz = nativeMappedConverter.nativeType();
            object = nativeMappedConverter.toNative(object, new ToNativeContext());
        }
        int n3 = Native.getNativeSize(clazz, object);
        if (clazz.isPrimitive() || Long.class == clazz || Integer.class == clazz || Short.class == clazz || Character.class == clazz || Byte.class == clazz || Boolean.class == clazz || Float.class == clazz || Double.class == clazz) {
            n2 = n3;
        } else if (Pointer.class.isAssignableFrom(clazz) && !Function.class.isAssignableFrom(clazz) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz) || Callback.class.isAssignableFrom(clazz) || WString.class == clazz || String.class == clazz) {
            n2 = Native.POINTER_SIZE;
        } else if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure$ByReference.class.isAssignableFrom(clazz)) {
                n2 = Native.POINTER_SIZE;
            } else {
                if (object == null) {
                    object = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
                }
                n2 = ((Structure)object).getStructAlignment();
            }
        } else if (clazz.isArray()) {
            n2 = this.getNativeAlignment(clazz.getComponentType(), null, bl2);
        } else {
            throw new IllegalArgumentException("Type " + clazz + " has unknown native alignment");
        }
        if (this.actualAlignType == 1) {
            n2 = 1;
        } else if (this.actualAlignType == 3) {
            n2 = Math.min(8, n2);
        } else if (this.actualAlignType == 2) {
            if (!(bl2 && Platform.isMac() && Platform.isPPC())) {
                n2 = Math.min(Native.MAX_ALIGNMENT, n2);
            }
            if (!bl2 && Platform.isAIX() && (clazz == Double.TYPE || clazz == Double.class)) {
                n2 = 4;
            }
        }
        return n2;
    }

    public String toString() {
        return this.toString(Boolean.getBoolean("jna.dump_memory"));
    }

    public String toString(boolean bl2) {
        return this.toString(0, true, bl2);
    }

    private String format(Class clazz) {
        String string = clazz.getName();
        int n2 = string.lastIndexOf(".");
        return string.substring(n2 + 1);
    }

    private String toString(int n2, boolean bl2, boolean bl3) {
        Object object;
        this.ensureAllocated();
        String string = System.getProperty("line.separator");
        String string2 = this.format(this.getClass()) + "(" + this.getPointer() + ")";
        if (!(this.getPointer() instanceof Memory)) {
            string2 = string2 + " (" + this.size() + " bytes)";
        }
        String string3 = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string3 = string3 + "  ";
        }
        String string4 = string;
        if (!bl2) {
            string4 = "...}";
        } else {
            Iterator iterator = this.fields().values().iterator();
            while (iterator.hasNext()) {
                object = (Structure$StructField)iterator.next();
                Object object2 = this.getFieldValue(((Structure$StructField)object).field);
                String string5 = this.format(((Structure$StructField)object).type);
                String string6 = "";
                string4 = string4 + string3;
                if (((Structure$StructField)object).type.isArray() && object2 != null) {
                    string5 = this.format(((Structure$StructField)object).type.getComponentType());
                    string6 = "[" + Array.getLength(object2) + "]";
                }
                string4 = string4 + String.format("  %s %s%s@0x%X", string5, ((Structure$StructField)object).name, string6, ((Structure$StructField)object).offset);
                if (object2 instanceof Structure) {
                    object2 = ((Structure)object2).toString(n2 + 1, !(object2 instanceof Structure$ByReference), bl3);
                }
                string4 = string4 + "=";
                string4 = object2 instanceof Long ? string4 + String.format("0x%08X", (Long)object2) : (object2 instanceof Integer ? string4 + String.format("0x%04X", (Integer)object2) : (object2 instanceof Short ? string4 + String.format("0x%02X", (Short)object2) : (object2 instanceof Byte ? string4 + String.format("0x%01X", (Byte)object2) : string4 + String.valueOf(object2).trim())));
                string4 = string4 + string;
                if (iterator.hasNext()) continue;
                string4 = string4 + string3 + "}";
            }
        }
        if (n2 == 0 && bl3) {
            int n3 = 4;
            string4 = string4 + string + "memory dump" + string;
            object = this.getPointer().getByteArray(0L, this.size());
            for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                if (i3 % 4 == 0) {
                    string4 = string4 + "[";
                }
                if (object[i3] >= 0 && object[i3] < 16) {
                    string4 = string4 + "0";
                }
                string4 = string4 + Integer.toHexString(object[i3] & 0xFF);
                if (i3 % 4 != 3 || i3 >= ((Object)object).length - 1) continue;
                string4 = string4 + "]" + string;
            }
            string4 = string4 + "]";
        }
        return string2 + " {" + string4;
    }

    public Structure[] toArray(Structure[] structureArray) {
        int n2;
        this.ensureAllocated();
        if (this.memory instanceof Structure$AutoAllocated) {
            Memory memory = (Memory)this.memory;
            n2 = structureArray.length * this.size();
            if (memory.size() < (long)n2) {
                this.useMemory(this.autoAllocate(n2));
            }
        }
        structureArray[0] = this;
        int n3 = this.size();
        for (n2 = 1; n2 < structureArray.length; ++n2) {
            structureArray[n2] = Structure.newInstance(this.getClass(), this.memory.share(n2 * n3, n3));
            structureArray[n2].conditionalAutoRead();
        }
        if (!(this instanceof Structure$ByValue)) {
            this.array = structureArray;
        }
        return structureArray;
    }

    public Structure[] toArray(int n2) {
        return this.toArray((Structure[])Array.newInstance(this.getClass(), n2));
    }

    private Class baseClass() {
        if ((this instanceof Structure$ByReference || this instanceof Structure$ByValue) && Structure.class.isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    public boolean dataEquals(Structure structure) {
        return this.dataEquals(structure, false);
    }

    public boolean dataEquals(Structure structure, boolean bl2) {
        byte[] byArray;
        byte[] byArray2;
        if (bl2) {
            structure.getPointer().clear(structure.size());
            structure.write();
            this.getPointer().clear(this.size());
            this.write();
        }
        if ((byArray2 = structure.getPointer().getByteArray(0L, structure.size())).length == (byArray = this.getPointer().getByteArray(0L, this.size())).length) {
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray2[i2] == byArray[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof Structure && object.getClass() == this.getClass() && ((Structure)object).getPointer().equals(this.getPointer());
    }

    public int hashCode() {
        Pointer pointer = this.getPointer();
        if (pointer != null) {
            return this.getPointer().hashCode();
        }
        return this.getClass().hashCode();
    }

    protected void cacheTypeInfo(Pointer pointer) {
        this.typeInfo = pointer.peer;
    }

    Pointer getFieldTypeInfo(Structure$StructField structure$StructField) {
        ToNativeConverter toNativeConverter;
        Class clazz = structure$StructField.type;
        Object object = this.getFieldValue(structure$StructField.field);
        if (this.typeMapper != null && (toNativeConverter = this.typeMapper.getToNativeConverter(clazz)) != null) {
            clazz = toNativeConverter.nativeType();
            object = toNativeConverter.toNative(object, new ToNativeContext());
        }
        return Structure$FFIType.access$800(object, clazz);
    }

    Pointer getTypeInfo() {
        Pointer pointer = Structure.getTypeInfo(this);
        this.cacheTypeInfo(pointer);
        return pointer;
    }

    public void setAutoSynch(boolean bl2) {
        this.setAutoRead(bl2);
        this.setAutoWrite(bl2);
    }

    public void setAutoRead(boolean bl2) {
        this.autoRead = bl2;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    public void setAutoWrite(boolean bl2) {
        this.autoWrite = bl2;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    static Pointer getTypeInfo(Object object) {
        return Structure$FFIType.get(object);
    }

    private static Structure newInstance(Class clazz, long l2) {
        try {
            Structure structure = Structure.newInstance(clazz, l2 == 0L ? PLACEHOLDER_MEMORY : new Pointer(l2));
            if (l2 != 0L) {
                structure.conditionalAutoRead();
            }
            return structure;
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "JNA: Error creating structure", throwable);
            return null;
        }
    }

    public static Structure newInstance(Class clazz, Pointer pointer) throws IllegalArgumentException {
        try {
            Constructor constructor = clazz.getConstructor(Pointer.class);
            return (Structure)constructor.newInstance(pointer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
            String string = "Can't instantiate " + clazz;
            throw new IllegalArgumentException(string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Instantiation of " + clazz + " (Pointer) not allowed, is it public?";
            throw new IllegalArgumentException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Exception thrown while instantiating an instance of " + clazz;
            throw new IllegalArgumentException(string, invocationTargetException);
        }
        Structure structure = Structure.newInstance(clazz);
        if (pointer != PLACEHOLDER_MEMORY) {
            structure.useMemory(pointer);
        }
        return structure;
    }

    public static Structure newInstance(Class clazz) throws IllegalArgumentException {
        Structure structure = (Structure)Klass.newInstance(clazz);
        if (structure instanceof Structure$ByValue) {
            structure.allocateMemory();
        }
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Structure$StructField typeInfoField() {
        Structure$LayoutInfo structure$LayoutInfo;
        Map map = layoutInfo;
        synchronized (map) {
            structure$LayoutInfo = (Structure$LayoutInfo)layoutInfo.get(this.getClass());
        }
        if (structure$LayoutInfo != null) {
            return Structure$LayoutInfo.access$700(structure$LayoutInfo);
        }
        return null;
    }

    private static void structureArrayCheck(Structure[] structureArray) {
        if (Structure$ByReference[].class.isAssignableFrom(structureArray.getClass())) {
            return;
        }
        Pointer pointer = structureArray[0].getPointer();
        int n2 = structureArray[0].size();
        for (int i2 = 1; i2 < structureArray.length; ++i2) {
            if (structureArray[i2].getPointer().peer == pointer.peer + (long)(n2 * i2)) continue;
            String string = "Structure array elements must use contiguous memory (bad backing address at Structure array index " + i2 + ")";
            throw new IllegalArgumentException(string);
        }
    }

    public static void autoRead(Structure[] structureArray) {
        Structure.structureArrayCheck(structureArray);
        if (structureArray[0].array == structureArray) {
            structureArray[0].autoRead();
        } else {
            for (int i2 = 0; i2 < structureArray.length; ++i2) {
                if (structureArray[i2] == null) continue;
                structureArray[i2].autoRead();
            }
        }
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int i2 = 1; i2 < this.array.length; ++i2) {
                    this.array[i2].autoRead();
                }
            }
        }
    }

    public static void autoWrite(Structure[] structureArray) {
        Structure.structureArrayCheck(structureArray);
        if (structureArray[0].array == structureArray) {
            structureArray[0].autoWrite();
        } else {
            for (int i2 = 0; i2 < structureArray.length; ++i2) {
                if (structureArray[i2] == null) continue;
                structureArray[i2].autoWrite();
            }
        }
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int i2 = 1; i2 < this.array.length; ++i2) {
                    this.array[i2].autoWrite();
                }
            }
        }
    }

    protected int getNativeSize(Class clazz) {
        return this.getNativeSize(clazz, null);
    }

    protected int getNativeSize(Class clazz, Object object) {
        return Native.getNativeSize(clazz, object);
    }

    static void validate(Class clazz) {
        try {
            clazz.getConstructor(new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        throw new IllegalArgumentException("No suitable constructor found for class: " + clazz.getName());
    }

    static /* synthetic */ void access$1900(Structure structure, boolean bl2) {
        structure.ensureAllocated(bl2);
    }

    static /* synthetic */ Pointer access$2000() {
        return PLACEHOLDER_MEMORY;
    }
}

