/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Emulator;
import emulator.Settings;
import emulator.Utils;
import emulator.ui.swt.devutils.b;
import emulator.ui.swt.devutils.idea.ProjectGenerator;
import emulator.ui.swt.devutils.idea.h;
import emulator.ui.swt.devutils.idea.i;
import emulator.ui.swt.devutils.idea.k;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class j
implements ModifyListener,
SelectionListener {
    private final Shell a;
    private final Shell b;
    private final Button a;
    private final Text a;
    private final Text b;
    private final Text c;
    private final Text d;
    private final Button b;
    private final Button c;
    private final Button d;
    private final Button e;
    private final Label a;
    private final Group a;
    private final Link a;

    j(Shell shell) {
        if (!Settings.ideaJdkTablePatched) {
            throw new RuntimeException("Attempt to open utils window when IDE is not configured.");
        }
        this.b = shell;
        this.a = new Shell(shell, 1264);
        this.a.setText("Intellij IDEA support");
        this.a.setMinimumSize(450, 600);
        this.a.setSize(450, 600);
        GridLayout gridLayout = new GridLayout(1, true);
        this.a.setLayout(gridLayout);
        Group group = new Group(this.a, 0);
        group.setText("Fix a project after clone");
        group.setLayout(this.a());
        group.setLayoutData(this.a());
        new Label(group, 0).setText("Some files are gitignored by default because they contain absolute paths.");
        new Label(group, 0).setText("They should be recreated if you downloaded someone's project.");
        this.d = new Button(group, 0x800000);
        this.d.setText("Choose a project");
        this.d.addSelectionListener(this);
        this.a = new Group(this.a, 0);
        this.a.setText("Create a new project");
        this.a.setLayout(this.a());
        this.a.setLayoutData(this.a());
        this.a = new Text(this.a, 2048);
        this.a.setMessage("Project name");
        this.a.setToolTipText("Name of folder, JAR file, various configurations. Only ASCII letters, numbers, hyphen and underscore allowed.\nExample: \"mahocart_midp\"");
        this.a.setLayoutData(new RowData(400, -1));
        this.a.addModifyListener(this);
        this.b = new Text(this.a, 2048);
        this.b.setMessage("MIDlet class name");
        this.b.setToolTipText("Full name of your MIDlet class. Must be valid java type name.\n\nExample: \"ru.symansel.mahocart.MahoCartMIDlet\"");
        this.b.setLayoutData(new RowData(400, -1));
        this.b.addModifyListener(this);
        this.c = new Text(this.a, 2048);
        this.c.setMessage("Readable MIDlet name");
        this.c.setToolTipText("Name of your MIDlet, shown to user. Can contain any symbols except commas, just make sure your target device has enough fonts to display the name.\n\nExample: \"\u041c\u0410\u0425\u041e\u041a\u0410\u0420\u0422\ud83d\udea8\ud83d\udea8\ud83d\udea8\"");
        this.c.setLayoutData(new RowData(400, -1));
        this.c.addModifyListener(this);
        this.d = new Text(this.a, 2048);
        this.d.setText(Settings.lastIdeaRepoPath);
        this.d.setMessage("Project location");
        this.d.setToolTipText("Location of folder where the project's folder will be created.\n\nExample: \"" + (Utils.linux ? "/mnt/projects/" : "D:\\projects\\") + "\"");
        this.d.setLayoutData(new RowData(400, -1));
        this.d.addModifyListener(this);
        this.b = new Button(this.a, 0x800000);
        this.b.setText("Choose location via file explorer");
        this.b.addSelectionListener(this);
        this.c = new Button(this.a, 0x800000);
        this.c.setText("Create project");
        this.c.addSelectionListener(this);
        this.c.setEnabled(false);
        this.a = new Label(this.a, 0);
        this.a.setText("Hover fields to see tooltips with details.");
        this.a.setSize(400, -1);
        Group group2 = new Group(this.a, 0);
        group2.setText("Convert a project");
        group2.setLayout(this.a());
        group2.setLayoutData(this.a());
        this.a = new Button(group2, 0x800000);
        this.a.setText("Eclipse MTJ -> IDEA");
        this.a.addSelectionListener(this);
        this.a = new Link(group2, 0);
        this.a.setText("See <a>documentation</a> to learn limitations and known issues.");
        this.a.addSelectionListener(this);
        Group group3 = new Group(this.a, 0);
        group3.setText("Maintenance");
        group3.setLayout(this.a());
        group3.setLayoutData(this.a());
        this.e = new Button(group3, 8);
        this.e.setText("Reset all settings and run setup again");
        this.e.addSelectionListener(this);
        this.a.layout(true, true);
    }

    public static void a(Shell shell) {
        if (Settings.ideaPath != null && !Files.exists(Paths.get(Settings.ideaPath, new String[0]), new LinkOption[0])) {
            Settings.ideaPath = null;
        }
        if (Settings.proguardPath != null && !Files.exists(Paths.get(Settings.proguardPath, new String[0]), new LinkOption[0])) {
            Settings.proguardPath = null;
        }
        if (!Files.exists(Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("uei"), new LinkOption[0])) {
            Settings.ideaJdkTablePatched = false;
        }
        if (((ArrayList)k.a()).isEmpty()) {
            Settings.ideaJdkTablePatched = false;
        }
        if (Settings.ideaJdkTablePatched && Settings.ideaPath != null && Settings.proguardPath != null) {
            new j((Shell)shell).a.open();
        } else {
            Settings.ideaJdkTablePatched = false;
            if (Utils.linux) {
                new i(shell).a();
            } else {
                new h(shell).a();
            }
        }
    }

    private GridData a() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        return gridData;
    }

    private RowLayout a() {
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.spacing = 5;
        return rowLayout;
    }

    private void a(String string, String string2) {
        MessageBox messageBox = new MessageBox(this.a, 33);
        messageBox.setText(string);
        messageBox.setMessage(string2);
        messageBox.open();
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private static boolean a(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_') continue;
            return false;
        }
        return true;
    }

    private static String a(String string, String string2, String string3, String string4) {
        if (string.isEmpty()) {
            return "Project name must not be empty.";
        }
        if (!j.a(string)) {
            return "Project name must meet certain restrictions, check tooltip on the field.";
        }
        if (string2.isEmpty()) {
            return "Class name must not be empty.";
        }
        if (!emulator.ui.swt.devutils.b.a(string2)) {
            return "Class name must be a valid Java class name.";
        }
        if (string3.isEmpty()) {
            return "MIDlet name must not be empty.";
        }
        if (string3.indexOf(44) != -1) {
            return "MIDlet name must not contain commas.";
        }
        if (string4.isEmpty() || ".".equals(string4)) {
            return "Specify location for the project";
        }
        if (!Files.exists(Paths.get(string4, new String[0]), new LinkOption[0])) {
            return "Location for project doesn't exist.";
        }
        if (Files.exists(Paths.get(string4, string), new LinkOption[0])) {
            return "Folder with the specified name already exists. Do something with it.";
        }
        return null;
    }

    @Override
    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        String string2 = this.a.getText().trim();
        String string3 = this.b.getText().trim();
        String string4 = this.c.getText().trim();
        String string5 = this.d.getText().trim();
        if (string5.endsWith("/") || string5.endsWith("\\")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        if ((string = j.a(string2, string3, string4, string5)) != null) {
            this.a.setText(string);
        } else {
            this.a.setText("Code will be placed at " + Paths.get(string5, string2, "src"));
        }
        this.c.setEnabled(true);
        this.a.layout(true, true);
    }

    @Override
    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.b) {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.a, 4096);
            directoryDialog.setText("Choose folder where you store your projects");
            String string = directoryDialog.open();
            if (string != null) {
                this.d.setText(string);
            }
        } else if (selectionEvent.widget == this.c) {
            this.a();
        } else if (selectionEvent.widget == this.d) {
            this.b();
        } else if (selectionEvent.widget == this.a) {
            this.c();
        } else if (selectionEvent.widget == this.e) {
            Settings.ideaJdkTablePatched = false;
            Settings.proguardPath = null;
            Settings.ideaPath = null;
            this.a.close();
            this.a.dispose();
            j.a(this.b);
        } else if (selectionEvent.widget == this.a) {
            Emulator.openUrlExternallySilent("https://github.com/shinovon/KEmulator/blob/main/IdeaSupport.md");
        }
    }

    private void a() {
        String string;
        String string2 = this.a.getText().trim();
        String string3 = this.b.getText().trim();
        String string4 = this.c.getText().trim();
        String string5 = this.d.getText().trim();
        if (string5.endsWith("/") || string5.endsWith("\\")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        if ((string = j.a(string2, string3, string4, string5)) != null) {
            this.a("Project creation", string);
            return;
        }
        try {
            String string6 = ProjectGenerator.create(string5, string2, string3, string4);
            Settings.lastIdeaRepoPath = string5;
            Runtime.getRuntime().exec(new String[]{Settings.ideaPath, Paths.get(string5, string2).toString(), string6});
            this.a.close();
            this.a.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.a("Project creation", "Failed to generate project: " + exception.getMessage());
        }
    }

    private void b() {
        FileDialog fileDialog = new FileDialog(this.a, 4096);
        fileDialog.setText("Choose IDEA project file");
        fileDialog.setFilterExtensions(new String[]{"*.iml"});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        if (!string.endsWith(".iml")) {
            this.a("Project restore", "Selected not an IDEA project file.");
            return;
        }
        String string2 = Paths.get(string, new String[0]).getParent().toString();
        try {
            boolean bl2 = ProjectGenerator.restore(string2);
            if (bl2) {
                Runtime.getRuntime().exec(new String[]{Settings.ideaPath, string2});
            }
            this.a.close();
            this.a.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.a("Project restore", "Failed to generate project: " + exception.getMessage() + "\nNote that this works only with projects created by KEmulator.");
        }
    }

    private void c() {
        FileDialog fileDialog = new FileDialog(this.a, 4096);
        fileDialog.setText("Choose Eclipse application descriptor");
        fileDialog.setFilterExtensions(new String[]{"Application Descriptor"});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        try {
            String string2 = ProjectGenerator.convertEclipse(string);
            Runtime.getRuntime().exec(new String[]{Settings.ideaPath, string2});
            this.a.close();
            this.a.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof IllegalArgumentException) {
                this.a("Project conversion", "Failed to convert project: " + exception.getMessage());
            }
            this.a("Project conversion", "Failed to convert project: " + exception);
        }
    }

    private static void d() {
        if (!Settings.ideaJdkTablePatched) {
            System.out.println("IDE support is not configured, please run setup first.");
            System.exit(2);
        }
        if (!Files.exists(Paths.get(Settings.ideaPath, new String[0]), new LinkOption[0])) {
            System.out.println("IDE binary is gone. Please run setup again.");
            System.exit(2);
        }
        if (!Files.exists(Paths.get(Settings.proguardPath, new String[0]), new LinkOption[0])) {
            System.out.println("Proguard is gone. Please run setup again.");
            System.exit(2);
        }
        if (!Files.exists(Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("uei"), new LinkOption[0])) {
            System.out.println("UEI libs folder is missing. Please run setup again.");
            System.exit(2);
        }
        if (((ArrayList)k.a()).isEmpty()) {
            System.out.println("No UEI libraries found. Please run setup again.");
            System.exit(2);
        }
    }

    public static void a(String string) {
        try {
            System.out.println("Fixing project at " + string);
            ProjectGenerator.restore(string);
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Failed!");
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    public static void b(String string) {
        j.d();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("\u001b[92mPlease enter project name.\u001b[0m");
            System.out.println("Name of folder, JAR file, various configurations. Only ASCII letters, numbers, hyphen and underscore allowed.");
            System.out.print("> ");
            String string2 = bufferedReader.readLine();
            System.out.println("\u001b[92mPlease enter MIDlet class name.\u001b[0m");
            System.out.println("Full name of your MIDlet class. Must be valid java type name.");
            System.out.print("> ");
            String string3 = bufferedReader.readLine();
            System.out.println("\u001b[92mPlease enter MIDlet name.\u001b[0m");
            System.out.println("Name of your MIDlet, shown to user. Can contain any symbols except commas, just make sure your target device has enough fonts to display the name.");
            System.out.print("> ");
            String string4 = bufferedReader.readLine();
            String string5 = j.a(string2, string3, string4, string);
            if (string5 != null) {
                System.out.println(string5);
                System.exit(1);
            }
            ProjectGenerator.create(string, string2, string3, string4);
            Settings.lastIdeaRepoPath = string;
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Failed!");
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    public static void c(String string) {
        j.d();
        try {
            ProjectGenerator.convertEclipse(Paths.get(string, new String[0]).resolve("Application Descriptor").toAbsolutePath().toString());
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Failed!");
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    public static void d(String string) {
        j.d();
        try {
            Runtime.getRuntime().exec(new String[]{Settings.ideaPath, string});
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Failed!");
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }
}

