/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.BLENDFUNCTION;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.LOGPEN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TRIVERTEX;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_WIDTH = 16;
    static final int LINE_CAP = 32;
    static final int LINE_JOIN = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_TEXT = 256;
    static final int BACKGROUND_TEXT = 512;
    static final int BRUSH = 1024;
    static final int PEN = 2048;
    static final int NULL_BRUSH = 4096;
    static final int NULL_PEN = 8192;
    static final int DRAW_OFFSET = 16384;
    static final int DRAW = 22777;
    static final int FILL = 9218;
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n2) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n2);
        int n3 = drawable.internal_new_GC(gCData);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        this.init(drawable, gCData, n3);
        this.init();
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x2000000) != 0) {
            n2 &= 0xFBFFFFFF;
        }
        return n2 & 0x6000000;
    }

    void checkGC(int n2) {
        int n3;
        int n4 = this.data.state;
        if ((n4 & n2) == n2) {
            return;
        }
        n4 = (n4 ^ n2) & n2;
        this.data.state |= n2;
        int n5 = this.data.gdipGraphics;
        if (n5 != 0) {
            int n6;
            int n7;
            int n8;
            Object object;
            int n9 = this.data.gdipPen;
            float f2 = this.data.lineWidth;
            if ((n4 & 1) != 0 || n9 == 0 && (n4 & 0xF8) != 0) {
                int n10;
                if (this.data.gdipFgBrush != 0) {
                    Gdip.SolidBrush_delete(this.data.gdipFgBrush);
                }
                this.data.gdipFgBrush = 0;
                object = this.data.foregroundPattern;
                if (object != null) {
                    n10 = ((Pattern)object).handle;
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType(n10)) {
                            case 2: {
                                n10 = Gdip.Brush_Clone(n10);
                                if (n10 == 0) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform(n10, -1.0f, 1.0f, 0);
                                this.data.gdipFgBrush = n10;
                            }
                        }
                    }
                } else {
                    n8 = this.data.foreground;
                    n7 = n8 >> 16 & 0xFF | n8 & 0xFF00 | (n8 & 0xFF) << 16;
                    n6 = Gdip.Color_new(this.data.alpha << 24 | n7);
                    if (n6 == 0) {
                        SWT.error(2);
                    }
                    if ((n10 = Gdip.SolidBrush_new(n6)) == 0) {
                        SWT.error(2);
                    }
                    Gdip.Color_delete(n6);
                    this.data.gdipFgBrush = n10;
                }
                if (n9 != 0) {
                    Gdip.Pen_SetBrush(n9, n10);
                } else {
                    n9 = this.data.gdipPen = Gdip.Pen_new(n10, f2);
                }
            }
            if ((n4 & 0x10) != 0) {
                Gdip.Pen_SetWidth(n9, f2);
                switch (this.data.lineStyle) {
                    case 6: {
                        n4 |= 8;
                    }
                }
            }
            if ((n4 & 8) != 0) {
                float[] fArray = null;
                float f3 = 0.0f;
                n8 = 0;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        n8 = 2;
                        if (f2 != 0.0f) break;
                        fArray = LINE_DOT_ZERO;
                        break;
                    }
                    case 2: {
                        n8 = 1;
                        if (f2 != 0.0f) break;
                        fArray = LINE_DASH_ZERO;
                        break;
                    }
                    case 4: {
                        n8 = 3;
                        if (f2 != 0.0f) break;
                        fArray = LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        n8 = 4;
                        if (f2 != 0.0f) break;
                        fArray = LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        if (this.data.lineDashes == null) break;
                        f3 = this.data.lineDashesOffset / Math.max(1.0f, f2);
                        fArray = new float[this.data.lineDashes.length * 2];
                        for (n7 = 0; n7 < this.data.lineDashes.length; ++n7) {
                            float f4;
                            fArray[n7] = f4 = this.data.lineDashes[n7] / Math.max(1.0f, f2);
                            fArray[n7 + this.data.lineDashes.length] = f4;
                        }
                        break;
                    }
                }
                if (fArray != null) {
                    Gdip.Pen_SetDashPattern(n9, fArray, fArray.length);
                    Gdip.Pen_SetDashStyle(n9, 5);
                    Gdip.Pen_SetDashOffset(n9, f3);
                } else {
                    Gdip.Pen_SetDashStyle(n9, n8);
                }
            }
            if ((n4 & 0x80) != 0) {
                Gdip.Pen_SetMiterLimit(n9, this.data.lineMiterLimit);
            }
            if ((n4 & 0x40) != 0) {
                int n11 = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        n11 = 0;
                        break;
                    }
                    case 3: {
                        n11 = 1;
                        break;
                    }
                    case 2: {
                        n11 = 2;
                    }
                }
                Gdip.Pen_SetLineJoin(n9, n11);
            }
            if ((n4 & 0x20) != 0) {
                int n12 = 0;
                int n13 = 0;
                switch (this.data.lineCap) {
                    case 1: {
                        n13 = 0;
                        break;
                    }
                    case 2: {
                        n13 = 2;
                        n12 = 2;
                        break;
                    }
                    case 3: {
                        n13 = 1;
                    }
                }
                Gdip.Pen_SetLineCap(n9, n13, n13, n12);
            }
            if ((n4 & 2) != 0) {
                if (this.data.gdipBgBrush != 0) {
                    Gdip.SolidBrush_delete(this.data.gdipBgBrush);
                }
                this.data.gdipBgBrush = 0;
                Pattern pattern = this.data.backgroundPattern;
                if (pattern != null) {
                    this.data.gdipBrush = pattern.handle;
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType(this.data.gdipBrush)) {
                            case 2: {
                                int n14 = Gdip.Brush_Clone(this.data.gdipBrush);
                                if (n14 == 0) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform(n14, -1.0f, 1.0f, 0);
                                this.data.gdipBrush = this.data.gdipBgBrush = n14;
                            }
                        }
                    }
                } else {
                    int n15 = this.data.background;
                    n8 = n15 >> 16 & 0xFF | n15 & 0xFF00 | (n15 & 0xFF) << 16;
                    n7 = Gdip.Color_new(this.data.alpha << 24 | n8);
                    if (n7 == 0) {
                        SWT.error(2);
                    }
                    if ((n6 = Gdip.SolidBrush_new(n7)) == 0) {
                        SWT.error(2);
                    }
                    Gdip.Color_delete(n7);
                    this.data.gdipBrush = this.data.gdipBgBrush = n6;
                }
            }
            if ((n4 & 4) != 0) {
                Font font = this.data.font;
                OS.SelectObject(this.handle, font.handle);
                object = new int[1];
                n8 = GC.createGdipFont(this.handle, font.handle, n5, this.device.fontCollection, null, (int[])object);
                if (object[0] != false) {
                    OS.SelectObject(this.handle, (int)object[0]);
                }
                if (this.data.hGDIFont != 0) {
                    OS.DeleteObject(this.data.hGDIFont);
                }
                this.data.hGDIFont = (int)object[0];
                if (this.data.gdipFont != 0) {
                    Gdip.Font_delete(this.data.gdipFont);
                }
                this.data.gdipFont = n8;
            }
            if ((n4 & 0x4000) != 0) {
                float f5;
                this.data.gdipYOffset = 0.0f;
                this.data.gdipXOffset = 0.0f;
                int n16 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                object = new PointF();
                ((PointF)object).Y = 1.0f;
                ((PointF)object).X = 1.0f;
                Gdip.Graphics_GetTransform(n5, n16);
                Gdip.Matrix_TransformVectors(n16, (PointF)object, 1);
                Gdip.Matrix_delete(n16);
                float f6 = ((PointF)object).X;
                if (f6 < 0.0f) {
                    f6 = -f6;
                }
                if ((f5 = this.data.lineWidth * f6) == 0.0f || (int)f5 % 2 == 1) {
                    this.data.gdipXOffset = 0.5f / f6;
                }
                if ((f6 = ((PointF)object).Y) < 0.0f) {
                    f6 = -f6;
                }
                if ((f5 = this.data.lineWidth * f6) == 0.0f || (int)f5 % 2 == 1) {
                    this.data.gdipYOffset = 0.5f / f6;
                }
            }
            return;
        }
        if ((n4 & 0x79) != 0) {
            int n17;
            int n18;
            n3 = this.data.foreground;
            int n19 = (int)this.data.lineWidth;
            int[] nArray = null;
            int n20 = 0;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n20 = 1;
                    break;
                }
                case 3: {
                    n20 = 2;
                    break;
                }
                case 4: {
                    n20 = 3;
                    break;
                }
                case 5: {
                    n20 = 4;
                    break;
                }
                case 6: {
                    if (this.data.lineDashes == null) break;
                    n20 = 7;
                    nArray = new int[this.data.lineDashes.length];
                    for (n18 = 0; n18 < nArray.length; ++n18) {
                        nArray[n18] = (int)this.data.lineDashes[n18];
                    }
                    break;
                }
            }
            if ((n4 & 8) != 0) {
                OS.SetBkMode(this.handle, this.data.lineStyle == 1 ? 2 : 1);
            }
            n18 = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    n18 = 8192;
                    break;
                }
                case 2: {
                    n18 = 0;
                    break;
                }
                case 3: {
                    n18 = 4096;
                }
            }
            int n21 = 0;
            switch (this.data.lineCap) {
                case 2: {
                    n21 = 0;
                    break;
                }
                case 1: {
                    n21 = 512;
                    break;
                }
                case 3: {
                    n21 = 256;
                }
            }
            int n22 = n20 | n18 | n21;
            if (OS.IsWinCE || n19 == 0 && n20 != 7 || n22 == 0) {
                n17 = OS.CreatePen(n22 & 0xF, n19, n3);
            } else {
                LOGBRUSH lOGBRUSH = new LOGBRUSH();
                lOGBRUSH.lbStyle = 0;
                lOGBRUSH.lbColor = n3;
                n17 = OS.ExtCreatePen(n22 | 0x10000, Math.max(1, n19), lOGBRUSH, nArray != null ? nArray.length : 0, nArray);
            }
            OS.SelectObject(this.handle, n17);
            this.data.state |= 0x800;
            this.data.state &= 0xFFFFDFFF;
            if (this.data.hPen != 0) {
                OS.DeleteObject(this.data.hPen);
            }
            this.data.hPen = this.data.hOldPen = n17;
        } else if ((n4 & 0x800) != 0) {
            OS.SelectObject(this.handle, this.data.hOldPen);
            this.data.state &= 0xFFFFDFFF;
        } else if ((n4 & 0x2000) != 0) {
            this.data.hOldPen = OS.SelectObject(this.handle, OS.GetStockObject(8));
            this.data.state &= 0xFFFFF7FF;
        }
        if ((n4 & 2) != 0) {
            n3 = OS.CreateSolidBrush(this.data.background);
            OS.SelectObject(this.handle, n3);
            this.data.state |= 0x400;
            this.data.state &= 0xFFFFEFFF;
            if (this.data.hBrush != 0) {
                OS.DeleteObject(this.data.hBrush);
            }
            this.data.hOldBrush = this.data.hBrush = n3;
        } else if ((n4 & 0x400) != 0) {
            OS.SelectObject(this.handle, this.data.hOldBrush);
            this.data.state &= 0xFFFFEFFF;
        } else if ((n4 & 0x1000) != 0) {
            this.data.hOldBrush = OS.SelectObject(this.handle, OS.GetStockObject(5));
            this.data.state &= 0xFFFFFBFF;
        }
        if ((n4 & 0x200) != 0) {
            OS.SetBkColor(this.handle, this.data.background);
        }
        if ((n4 & 0x100) != 0) {
            OS.SetTextColor(this.handle, this.data.foreground);
        }
        if ((n4 & 4) != 0) {
            Font font = this.data.font;
            OS.SelectObject(this.handle, font.handle);
        }
    }

    public void copyArea(Image image, int n2, int n3) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.copyAreaInPixels(image, n2, n3);
    }

    void copyAreaInPixels(Image image, int n2, int n3) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = image.getBoundsInPixels();
        int n4 = OS.CreateCompatibleDC(this.handle);
        int n5 = OS.SelectObject(n4, image.handle);
        OS.BitBlt(n4, 0, 0, rectangle.width, rectangle.height, this.handle, n2, n3, 0xCC0020);
        OS.SelectObject(n4, n5);
        OS.DeleteDC(n4);
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.copyArea(n2, n3, n4, n5, n6, n7, true);
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        n6 = DPIUtil.autoScaleUp(this.drawable, n6);
        n7 = DPIUtil.autoScaleUp(this.drawable, n7);
        this.copyAreaInPixels(n2, n3, n4, n5, n6, n7, bl2);
    }

    void copyAreaInPixels(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        int n8;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n8 = this.data.hwnd) == 0) {
            OS.BitBlt(this.handle, n6, n7, n4, n5, this.handle, n2, n3, 0xCC0020);
        } else {
            RECT rECT = null;
            int n9 = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetClipRgn(this.handle, n9) == 1) {
                rECT = new RECT();
                OS.GetRgnBox(n9, rECT);
            }
            OS.DeleteObject(n9);
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, n2, n3, n2 + n4, n3 + n5);
            int n10 = bl2 ? 6 : 0;
            int n11 = OS.ScrollWindowEx(n8, n6 - n2, n7 - n3, rECT2, rECT, 0, null, n10);
            if (n11 == 0 && OS.IsWinCE) {
                OS.BitBlt(this.handle, n6, n7, n4, n5, this.handle, n2, n3, 0xCC0020);
                if (bl2) {
                    boolean bl3;
                    int n12 = n6 - n2;
                    int n13 = n7 - n3;
                    boolean bl4 = bl3 = n6 + n4 < n2 || n2 + n4 < n6 || n7 + n5 < n3 || n3 + n5 < n7;
                    if (bl3) {
                        OS.InvalidateRect(n8, rECT2, true);
                    } else {
                        int n14;
                        if (n12 != 0) {
                            n14 = n6 - n12;
                            if (n12 < 0) {
                                n14 = n6 + n4;
                            }
                            OS.SetRect(rECT2, n14, n3, n14 + Math.abs(n12), n3 + n5);
                            OS.InvalidateRect(n8, rECT2, true);
                        }
                        if (n13 != 0) {
                            n14 = n7 - n13;
                            if (n13 < 0) {
                                n14 = n7 + n5;
                            }
                            OS.SetRect(rECT2, n2, n14, n2 + n4, n14 + Math.abs(n13));
                            OS.InvalidateRect(n8, rECT2, true);
                        }
                    }
                }
            }
        }
    }

    static int createGdipFont(int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        int n6 = Gdip.Font_new(n2, n3);
        if (n6 == 0) {
            SWT.error(2);
        }
        int n7 = 0;
        if (!Gdip.Font_IsAvailable(n6)) {
            int n8;
            char[] cArray;
            Gdip.Font_delete(n6);
            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.GetObject(n3, LOGFONT.sizeof, lOGFONT);
            int n9 = Math.abs(lOGFONT.lfHeight);
            int n10 = 0;
            if (lOGFONT.lfWeight == 700) {
                n10 |= 1;
            }
            if (lOGFONT.lfItalic != 0) {
                n10 |= 2;
            }
            if (OS.IsUnicode) {
                cArray = lOGFONT.lfFaceName;
            } else {
                cArray = new char[32];
                byte[] byArray = ((LOGFONTA)lOGFONT).lfFaceName;
                OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
            }
            for (n8 = 0; n8 < cArray.length && cArray[n8] != '\u0000'; ++n8) {
            }
            String string = new String(cArray, 0, n8);
            if (string.equalsIgnoreCase("Courier")) {
                string = "Courier New";
            }
            char[] cArray2 = new char[string.length() + 1];
            string.getChars(0, string.length(), cArray2, 0);
            if (n5 != 0 && !Gdip.FontFamily_IsAvailable(n7 = Gdip.FontFamily_new(cArray2, n5))) {
                Gdip.FontFamily_delete(n7);
                n7 = Gdip.FontFamily_new(cArray2, 0);
                if (!Gdip.FontFamily_IsAvailable(n7)) {
                    Gdip.FontFamily_delete(n7);
                    n7 = 0;
                }
            }
            n6 = n7 != 0 ? Gdip.Font_new(n7, n9, n10, 2) : Gdip.Font_new(cArray2, n9, n10, 2, 0);
            if (nArray2 != null && n6 != 0) {
                int n11 = OS.GetProcessHeap();
                int n12 = OS.HeapAlloc(n11, 8, LOGFONTW.sizeof);
                Gdip.Font_GetLogFontW(n6, n4, n12);
                nArray2[0] = OS.CreateFontIndirectW(n12);
                OS.HeapFree(n11, 0, n12);
            }
        }
        if (nArray != null && n6 != 0) {
            if (n7 == 0) {
                n7 = Gdip.FontFamily_new();
                Gdip.Font_GetFamily(n6, n7);
            }
            nArray[0] = n7;
        } else if (n7 != 0) {
            Gdip.FontFamily_delete(n7);
        }
        if (n6 == 0) {
            SWT.error(2);
        }
        return n6;
    }

    static void destroyGdipBrush(int n2) {
        int n3 = Gdip.Brush_GetType(n2);
        switch (n3) {
            case 0: {
                Gdip.SolidBrush_delete(n2);
                break;
            }
            case 1: {
                Gdip.HatchBrush_delete(n2);
                break;
            }
            case 4: {
                Gdip.LinearGradientBrush_delete(n2);
                break;
            }
            case 2: {
                Gdip.TextureBrush_delete(n2);
            }
        }
    }

    @Override
    void destroy() {
        Image image;
        int n2;
        boolean bl2 = this.data.gdipGraphics != 0;
        this.disposeGdip();
        if (bl2 && (this.data.style & 0x8000000) != 0) {
            OS.SetLayout(this.handle, OS.GetLayout(this.handle) | 1);
        }
        if (this.data.hPen != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(8));
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0;
        }
        if (this.data.hBrush != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(5));
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0;
        }
        if ((n2 = this.data.hNullBitmap) != 0) {
            OS.SelectObject(this.handle, n2);
            this.data.hNullBitmap = 0;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.ps = null;
        this.data = null;
    }

    void disposeGdip() {
        if (this.data.gdipPen != 0) {
            Gdip.Pen_delete(this.data.gdipPen);
        }
        if (this.data.gdipBgBrush != 0) {
            GC.destroyGdipBrush(this.data.gdipBgBrush);
        }
        if (this.data.gdipFgBrush != 0) {
            GC.destroyGdipBrush(this.data.gdipFgBrush);
        }
        if (this.data.gdipFont != 0) {
            Gdip.Font_delete(this.data.gdipFont);
        }
        if (this.data.hGDIFont != 0) {
            OS.DeleteObject(this.data.hGDIFont);
        }
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_delete(this.data.gdipGraphics);
        }
        this.data.hGDIFont = 0;
        this.data.gdipPen = 0;
        this.data.gdipFont = 0;
        this.data.gdipFgBrush = 0;
        this.data.gdipBgBrush = 0;
        this.data.gdipBrush = 0;
        this.data.gdipGraphics = 0;
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.drawArcInPixels(n2, n3, n4, n5, n6, n7);
    }

    void drawArcInPixels(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        if (n4 == 0 || n5 == 0 || n7 == 0) {
            return;
        }
        int n8 = this.data.gdipGraphics;
        if (n8 != 0) {
            Gdip.Graphics_TranslateTransform(n8, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            if (n4 == n5) {
                Gdip.Graphics_DrawArc(n8, this.data.gdipPen, n2, n3, n4, n5, -n6, -n7);
            } else {
                int n9;
                int n10 = Gdip.GraphicsPath_new(0);
                if (n10 == 0) {
                    SWT.error(2);
                }
                if ((n9 = Gdip.Matrix_new(n4, 0.0f, 0.0f, n5, n2, n3)) == 0) {
                    SWT.error(2);
                }
                Gdip.GraphicsPath_AddArc(n10, 0.0f, 0.0f, 1.0f, 1.0f, -n6, -n7);
                Gdip.GraphicsPath_Transform(n10, n9);
                Gdip.Graphics_DrawPath(n8, this.data.gdipPen, n10);
                Gdip.Matrix_delete(n9);
                Gdip.GraphicsPath_delete(n10);
            }
            Gdip.Graphics_TranslateTransform(n8, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n2;
        }
        if (OS.IsWinCE) {
            if (n7 < 0) {
                n6 += n7;
                n7 = -n7;
            }
            if (n7 > 360) {
                n7 = 360;
            }
            int[] nArray = new int[(n7 + 1) * 2];
            int n11 = 2 * n2 + n4;
            int n12 = 2 * n3 + n5;
            int n13 = 0;
            for (int i2 = 0; i2 <= n7; ++i2) {
                nArray[n13++] = GC.cos(n6 + i2, n4) + n11 >> 1;
                nArray[n13++] = n12 - GC.sin(n6 + i2, n5) >> 1;
            }
            OS.Polyline(this.handle, nArray, nArray.length / 2);
        } else {
            int n14;
            int n15;
            int n16;
            int n17;
            if (n7 >= 360 || n7 <= -360) {
                n16 = n17 = n2 + n4;
                n14 = n15 = n3 + n5 / 2;
            } else {
                boolean bl2 = n7 < 0;
                n7 += n6;
                if (bl2) {
                    int n18 = n6;
                    n6 = n7;
                    n7 = n18;
                }
                n16 = GC.cos(n6, n4) + n2 + n4 / 2;
                n14 = -1 * GC.sin(n6, n5) + n3 + n5 / 2;
                n17 = GC.cos(n7, n4) + n2 + n4 / 2;
                n15 = -1 * GC.sin(n7, n5) + n3 + n5 / 2;
            }
            OS.Arc(this.handle, n2, n3, n2 + n4 + 1, n3 + n5 + 1, n16, n14, n17, n15);
        }
    }

    public void drawFocus(int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.drawFocusInPixels(n2, n3, n4, n5);
    }

    void drawFocusInPixels(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((this.data.uiState & 1) != 0) {
            return;
        }
        this.data.focusDrawn = true;
        int n6 = this.handle;
        int n7 = 0;
        int n8 = this.data.gdipGraphics;
        if (n8 != 0) {
            int n9 = 0;
            Gdip.Graphics_SetPixelOffsetMode(n8, 3);
            int n10 = Gdip.Region_new();
            if (n10 == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_GetClip(n8, n10);
            if (!Gdip.Region_IsInfinite(n10, n8)) {
                n9 = Gdip.Region_GetHRGN(n10, n8);
            }
            Gdip.Region_delete(n10);
            Gdip.Graphics_SetPixelOffsetMode(n8, 4);
            float[] fArray = null;
            int n11 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (n11 == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform(n8, n11);
            if (!Gdip.Matrix_IsIdentity(n11)) {
                fArray = new float[6];
                Gdip.Matrix_GetElements(n11, fArray);
            }
            Gdip.Matrix_delete(n11);
            n6 = Gdip.Graphics_GetHDC(n8);
            n7 = OS.SaveDC(n6);
            if (fArray != null) {
                OS.SetGraphicsMode(n6, 2);
                OS.SetWorldTransform(n6, fArray);
            }
            if (n9 != 0) {
                OS.SelectClipRgn(n6, n9);
                OS.DeleteObject(n9);
            }
        }
        OS.SetBkColor(n6, 0xFFFFFF);
        OS.SetTextColor(n6, 0);
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        OS.DrawFocusRect(n6, rECT);
        if (n8 != 0) {
            OS.RestoreDC(n6, n7);
            Gdip.Graphics_ReleaseHDC(n8, n6);
        } else {
            this.data.state &= 0xFFFFFCFF;
        }
    }

    public void drawImage(Image image, int n2, int n3) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.drawImageInPixels(image, n2, n3);
    }

    void drawImageInPixels(Image image, int n2, int n3) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n2, n3, -1, -1, true);
    }

    public void drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n4 == 0 || n5 == 0 || n8 == 0 || n9 == 0) {
            return;
        }
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n8 < 0 || n9 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n2, n3, n4, n5));
        Rectangle rectangle2 = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n6, n7, n8, n9));
        int n10 = DPIUtil.getDeviceZoom();
        if (n10 != 100) {
            Rectangle rectangle3 = image.getBoundsInPixels();
            int n11 = rectangle.x + rectangle.width - rectangle3.width;
            int n12 = rectangle.y + rectangle.height - rectangle3.height;
            if (n11 != 0 || n12 != 0) {
                if (n11 <= n10 / 100 && n12 <= n10 / 100) {
                    rectangle.intersect(rectangle3);
                } else {
                    SWT.error(5);
                }
            }
        }
        this.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
    }

    void drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
        image.refreshImageForZoom();
        if (this.data.gdipGraphics != 0) {
            int[] nArray = image.createGdipImage();
            int n10 = nArray[0];
            int n11 = Gdip.Image_GetWidth(n10);
            int n12 = Gdip.Image_GetHeight(n10);
            if (bl2) {
                n4 = n8 = n11;
                n5 = n9 = n12;
            } else {
                if (n2 + n4 > n11 || n3 + n5 > n12) {
                    SWT.error(5);
                }
                bl2 = n2 == 0 && n3 == 0 && n4 == n8 && n8 == n11 && n5 == n9 && n9 == n12;
            }
            Rect rect = new Rect();
            rect.X = n6;
            rect.Y = n7;
            rect.Width = n8;
            rect.Height = n9;
            int n13 = Gdip.ImageAttributes_new();
            Gdip.ImageAttributes_SetWrapMode(n13, 3);
            if (this.data.alpha != 255) {
                float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (float)this.data.alpha / 255.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                Gdip.ImageAttributes_SetColorMatrix(n13, fArray, 0, 1);
            }
            int n14 = 0;
            if ((this.data.style & 0x8000000) != 0) {
                n14 = Gdip.Graphics_Save(this.data.gdipGraphics);
                Gdip.Graphics_ScaleTransform(this.data.gdipGraphics, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(this.data.gdipGraphics, -2 * n6 - n8, 0.0f, 0);
            }
            Gdip.Graphics_DrawImage(this.data.gdipGraphics, n10, rect, n2, n3, n4, n5, 2, n13, 0, 0);
            if ((this.data.style & 0x8000000) != 0) {
                Gdip.Graphics_Restore(this.data.gdipGraphics, n14);
            }
            Gdip.ImageAttributes_delete(n13);
            Gdip.Bitmap_delete(n10);
            if (nArray[1] != 0) {
                int n15 = OS.GetProcessHeap();
                OS.HeapFree(n15, 0, nArray[1]);
            }
            return;
        }
        switch (image.type) {
            case 0: {
                this.drawBitmap(image, n2, n3, n4, n5, n6, n7, n8, n9, bl2);
                break;
            }
            case 1: {
                this.drawIcon(image, n2, n3, n4, n5, n6, n7, n8, n9, bl2);
            }
        }
    }

    void drawIcon(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
        boolean bl3;
        Object object;
        int n10 = OS.GetDeviceCaps(this.handle, 2);
        boolean bl4 = true;
        int n11 = 3;
        int n12 = 0;
        int n13 = 0;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            if ((OS.GetLayout(this.handle) & 1) != 0) {
                n11 |= 0x10;
                object = new POINT();
                OS.GetWindowOrgEx(this.handle, (POINT)object);
                n12 = ((POINT)object).x;
                n13 = ((POINT)object).y;
            }
        } else if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            boolean bl5 = bl4 = (OS.GetLayout(this.handle) & 1) == 0;
        }
        if (bl2 && n10 != 2 && bl4) {
            if (n12 != 0 || n13 != 0) {
                OS.SetWindowOrgEx(this.handle, 0, 0, null);
            }
            OS.DrawIconEx(this.handle, n6 - n12, n7 - n13, image.handle, 0, 0, 0, 0, n11);
            if (n12 != 0 || n13 != 0) {
                OS.SetWindowOrgEx(this.handle, n12, n13, null);
            }
            return;
        }
        object = new ICONINFO();
        if (OS.IsWinCE) {
            Image.GetIconInfo(image, (ICONINFO)object);
        } else {
            OS.GetIconInfo(image.handle, (ICONINFO)object);
        }
        int n14 = ((ICONINFO)object).hbmColor;
        if (n14 == 0) {
            n14 = ((ICONINFO)object).hbmMask;
        }
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n14, BITMAP.sizeof, bITMAP);
        int n15 = bITMAP.bmWidth;
        int n16 = bITMAP.bmHeight;
        if (n14 == ((ICONINFO)object).hbmMask) {
            n16 /= 2;
        }
        if (bl2) {
            n4 = n8 = n15;
            n5 = n9 = n16;
        }
        boolean bl6 = bl3 = n2 + n4 > n15 || n3 + n5 > n16;
        if (!bl3) {
            boolean bl7 = bl2 = n2 == 0 && n3 == 0 && n4 == n8 && n5 == n9 && n4 == n15 && n5 == n16;
            if (!bl4) {
                this.drawBitmapMask(image, ((ICONINFO)object).hbmColor, ((ICONINFO)object).hbmMask, n2, n3, n4, n5, n6, n7, n8, n9, bl2, n15, n16, false);
            } else if (bl2 && n10 != 2) {
                if (n12 != 0 || n13 != 0) {
                    OS.SetWindowOrgEx(this.handle, 0, 0, null);
                }
                OS.DrawIconEx(this.handle, n6 - n12, n7 - n13, image.handle, 0, 0, 0, 0, n11);
                if (n12 != 0 || n13 != 0) {
                    OS.SetWindowOrgEx(this.handle, n12, n13, null);
                }
            } else {
                boolean bl8;
                ICONINFO iCONINFO = new ICONINFO();
                iCONINFO.fIcon = true;
                int n17 = OS.CreateCompatibleDC(this.handle);
                int n18 = OS.CreateCompatibleDC(this.handle);
                int n19 = n3;
                int n20 = ((ICONINFO)object).hbmColor;
                if (n20 == 0) {
                    n20 = ((ICONINFO)object).hbmMask;
                    n19 += n16;
                }
                int n21 = OS.SelectObject(n17, n20);
                iCONINFO.hbmColor = OS.CreateCompatibleBitmap(n17, n8, n9);
                if (iCONINFO.hbmColor == 0) {
                    SWT.error(2);
                }
                int n22 = OS.SelectObject(n18, iCONINFO.hbmColor);
                boolean bl9 = bl8 = !bl2 && (n4 != n8 || n5 != n9);
                if (bl8) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(n18, 3);
                    }
                    OS.StretchBlt(n18, 0, 0, n8, n9, n17, n2, n19, n4, n5, 0xCC0020);
                } else {
                    OS.BitBlt(n18, 0, 0, n8, n9, n17, n2, n19, 0xCC0020);
                }
                OS.SelectObject(n17, ((ICONINFO)object).hbmMask);
                iCONINFO.hbmMask = OS.CreateBitmap(n8, n9, 1, 1, null);
                if (iCONINFO.hbmMask == 0) {
                    SWT.error(2);
                }
                OS.SelectObject(n18, iCONINFO.hbmMask);
                if (bl8) {
                    OS.StretchBlt(n18, 0, 0, n8, n9, n17, n2, n3, n4, n5, 0xCC0020);
                } else {
                    OS.BitBlt(n18, 0, 0, n8, n9, n17, n2, n3, 0xCC0020);
                }
                if (n10 == 2) {
                    OS.SelectObject(n17, iCONINFO.hbmColor);
                    OS.SelectObject(n18, iCONINFO.hbmMask);
                    this.drawBitmapTransparentByClipping(n17, n18, 0, 0, n8, n9, n6, n7, n8, n9, true, n8, n9);
                    OS.SelectObject(n17, n21);
                    OS.SelectObject(n18, n22);
                } else {
                    OS.SelectObject(n17, n21);
                    OS.SelectObject(n18, n22);
                    int n23 = OS.CreateIconIndirect(iCONINFO);
                    if (n23 == 0) {
                        SWT.error(2);
                    }
                    if (n12 != 0 || n13 != 0) {
                        OS.SetWindowOrgEx(this.handle, 0, 0, null);
                    }
                    OS.DrawIconEx(this.handle, n6 - n12, n7 - n13, n23, n8, n9, 0, 0, n11);
                    if (n12 != 0 || n13 != 0) {
                        OS.SetWindowOrgEx(this.handle, n12, n13, null);
                    }
                    OS.DestroyIcon(n23);
                }
                OS.DeleteObject(iCONINFO.hbmMask);
                OS.DeleteObject(iCONINFO.hbmColor);
                OS.DeleteDC(n18);
                OS.DeleteDC(n17);
            }
        }
        OS.DeleteObject(((ICONINFO)object).hbmMask);
        if (((ICONINFO)object).hbmColor != 0) {
            OS.DeleteObject(((ICONINFO)object).hbmColor);
        }
        if (bl3) {
            SWT.error(5);
        }
    }

    void drawBitmap(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(image.handle, BITMAP.sizeof, bITMAP);
        int n10 = bITMAP.bmWidth;
        int n11 = bITMAP.bmHeight;
        if (bl2) {
            n4 = n8 = n10;
            n5 = n9 = n11;
        } else {
            if (n2 + n4 > n10 || n3 + n5 > n11) {
                SWT.error(5);
            }
            bl2 = n2 == 0 && n3 == 0 && n4 == n8 && n8 == n10 && n5 == n9 && n9 == n11;
        }
        boolean bl3 = false;
        GC gC = image.memGC;
        if (gC != null && !gC.isDisposed()) {
            gC.flush();
            bl3 = true;
            GCData gCData = gC.data;
            if (gCData.hNullBitmap != 0) {
                OS.SelectObject(gC.handle, gCData.hNullBitmap);
                gCData.hNullBitmap = 0;
            }
        }
        if (image.alpha != -1 || image.alphaData != null) {
            this.drawBitmapAlpha(image, n2, n3, n4, n5, n6, n7, n8, n9, bl2, bITMAP, n10, n11);
        } else if (image.transparentPixel != -1) {
            this.drawBitmapTransparent(image, n2, n3, n4, n5, n6, n7, n8, n9, bl2, bITMAP, n10, n11);
        } else {
            this.drawBitmap(image, n2, n3, n4, n5, n6, n7, n8, n9, bl2, bITMAP, n10, n11);
        }
        if (bl3) {
            int n12;
            gC.data.hNullBitmap = n12 = OS.SelectObject(gC.handle, image.handle);
        }
    }

    void drawBitmapAlpha(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2, BITMAP bITMAP, int n10, int n11) {
        int n12;
        int n13;
        int n14;
        int n15;
        boolean bl3;
        int n16;
        boolean bl4;
        if (image.alpha == 0) {
            return;
        }
        if (image.alpha == 255) {
            this.drawBitmap(image, n2, n3, n4, n5, n6, n7, n8, n9, bl2, bITMAP, n10, n11);
            return;
        }
        boolean bl5 = OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10);
        boolean bl6 = bl4 = OS.GetDeviceCaps(this.handle, 2) == 2;
        if (bl5 && bl4 && (n16 = OS.GetDeviceCaps(this.handle, 120)) != 0) {
            if (image.alpha != -1) {
                bl5 = (n16 & 1) != 0;
            } else {
                boolean bl7 = bl5 = (n16 & 2) != 0;
            }
        }
        if (bl5) {
            BLENDFUNCTION bLENDFUNCTION = new BLENDFUNCTION();
            bLENDFUNCTION.BlendOp = 0;
            int n17 = OS.CreateCompatibleDC(this.handle);
            int n18 = OS.SelectObject(n17, image.handle);
            if (image.alpha != -1) {
                bLENDFUNCTION.SourceConstantAlpha = (byte)image.alpha;
                OS.AlphaBlend(this.handle, n6, n7, n8, n9, n17, n2, n3, n4, n5, bLENDFUNCTION);
            } else {
                int n19 = Image.createDIB(n4, n5, 32);
                if (n19 == 0) {
                    SWT.error(2);
                }
                int n20 = OS.CreateCompatibleDC(this.handle);
                int n21 = OS.SelectObject(n20, n19);
                BITMAP bITMAP2 = new BITMAP();
                OS.GetObject(n19, BITMAP.sizeof, bITMAP2);
                OS.BitBlt(n20, 0, 0, n4, n5, n17, n2, n3, 0xCC0020);
                byte[] byArray = new byte[bITMAP2.bmWidthBytes * bITMAP2.bmHeight];
                OS.MoveMemory(byArray, bITMAP2.bmBits, byArray.length);
                int n22 = n10 - n4;
                int n23 = n3 * n10 + n2;
                int n24 = 0;
                byte[] byArray2 = image.alphaData;
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n25 = byArray2[n23++] & 0xFF;
                        int n26 = (byArray[n24 + 0] & 0xFF) * n25 + 128;
                        n26 = n26 + (n26 >> 8) >> 8;
                        int n27 = (byArray[n24 + 1] & 0xFF) * n25 + 128;
                        n27 = n27 + (n27 >> 8) >> 8;
                        int n28 = (byArray[n24 + 2] & 0xFF) * n25 + 128;
                        n28 = n28 + (n28 >> 8) >> 8;
                        byArray[n24 + 0] = (byte)n26;
                        byArray[n24 + 1] = (byte)n27;
                        byArray[n24 + 2] = (byte)n28;
                        byArray[n24 + 3] = (byte)n25;
                        n24 += 4;
                    }
                    n23 += n22;
                }
                OS.MoveMemory(bITMAP2.bmBits, byArray, byArray.length);
                bLENDFUNCTION.SourceConstantAlpha = (byte)-1;
                bLENDFUNCTION.AlphaFormat = 1;
                OS.AlphaBlend(this.handle, n6, n7, n8, n9, n20, 0, 0, n4, n5, bLENDFUNCTION);
                OS.SelectObject(n20, n21);
                OS.DeleteDC(n20);
                OS.DeleteObject(n19);
            }
            OS.SelectObject(n17, n18);
            OS.DeleteDC(n17);
            return;
        }
        Rectangle rectangle = this.getClippingInPixels();
        if ((rectangle = rectangle.intersection(new Rectangle(n6, n7, n8, n9))).isEmpty()) {
            return;
        }
        int n29 = n2 + (rectangle.x - n6) * n4 / n8;
        int n30 = n2 + (rectangle.x + rectangle.width - n6) * n4 / n8;
        int n31 = n3 + (rectangle.y - n7) * n5 / n9;
        int n32 = n3 + (rectangle.y + rectangle.height - n7) * n5 / n9;
        n6 = rectangle.x;
        n7 = rectangle.y;
        n8 = rectangle.width;
        n9 = rectangle.height;
        n2 = n29;
        n3 = n31;
        n4 = Math.max(1, n30 - n29);
        n5 = Math.max(1, n32 - n31);
        int n33 = OS.CreateCompatibleDC(this.handle);
        int n34 = OS.SelectObject(n33, image.handle);
        int n35 = OS.CreateCompatibleDC(this.handle);
        int n36 = Image.createDIB(Math.max(n4, n8), Math.max(n5, n9), 32);
        if (n36 == 0) {
            SWT.error(2);
        }
        int n37 = OS.SelectObject(n35, n36);
        BITMAP bITMAP3 = new BITMAP();
        OS.GetObject(n36, BITMAP.sizeof, bITMAP3);
        int n38 = bITMAP3.bmWidthBytes * bITMAP3.bmHeight;
        OS.BitBlt(n35, 0, 0, n8, n9, this.handle, n6, n7, 0xCC0020);
        byte[] byArray = new byte[n38];
        OS.MoveMemory(byArray, bITMAP3.bmBits, n38);
        OS.BitBlt(n35, 0, 0, n4, n5, n33, n2, n3, 0xCC0020);
        byte[] byArray3 = new byte[n38];
        OS.MoveMemory(byArray3, bITMAP3.bmBits, n38);
        int n39 = image.alpha;
        boolean bl8 = bl3 = image.alpha == -1;
        if (bl3) {
            n15 = n10 - n4;
            n14 = bITMAP3.bmWidthBytes - n4 * 4;
            n13 = n3 * n10 + n2;
            n12 = 3;
            byte[] byArray4 = image.alphaData;
            for (int i4 = 0; i4 < n5; ++i4) {
                for (int i5 = 0; i5 < n4; ++i5) {
                    byArray3[n12] = byArray4[n13++];
                    n12 += 4;
                }
                n13 += n15;
                n12 += n14;
            }
        }
        OS.MoveMemory(bITMAP3.bmBits, byArray3, n38);
        if (OS.IsWinCE && (n8 > n4 || n9 > n5) || !OS.IsWinNT && !OS.IsWinCE || bl4) {
            n15 = OS.CreateCompatibleDC(this.handle);
            n14 = Image.createDIB(n8, n9, 32);
            if (n14 == 0) {
                SWT.error(2);
            }
            n13 = OS.SelectObject(n15, n14);
            if (!(bl2 || n4 == n8 && n5 == n9)) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(n35, 3);
                }
                OS.StretchBlt(n15, 0, 0, n8, n9, n35, 0, 0, n4, n5, 0xCC0020);
            } else {
                OS.BitBlt(n15, 0, 0, n8, n9, n35, 0, 0, 0xCC0020);
            }
            OS.BitBlt(n35, 0, 0, n8, n9, n15, 0, 0, 0xCC0020);
            OS.SelectObject(n15, n13);
            OS.DeleteObject(n14);
            OS.DeleteDC(n15);
        } else if (!(bl2 || n4 == n8 && n5 == n9)) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n35, 3);
            }
            OS.StretchBlt(n35, 0, 0, n8, n9, n35, 0, 0, n4, n5, 0xCC0020);
        } else {
            OS.BitBlt(n35, 0, 0, n8, n9, n35, 0, 0, 0xCC0020);
        }
        OS.MoveMemory(byArray3, bITMAP3.bmBits, n38);
        n15 = bITMAP3.bmWidthBytes - n8 * 4;
        n14 = 0;
        for (n13 = 0; n13 < n9; ++n13) {
            for (n12 = 0; n12 < n8; ++n12) {
                if (bl3) {
                    n39 = byArray3[n14 + 3] & 0xFF;
                }
                int n40 = n14;
                byArray[n40] = (byte)(byArray[n40] + ((byArray3[n14] & 0xFF) - (byArray[n14] & 0xFF)) * n39 / 255);
                int n41 = n14 + 1;
                byArray[n41] = (byte)(byArray[n41] + ((byArray3[n14 + 1] & 0xFF) - (byArray[n14 + 1] & 0xFF)) * n39 / 255);
                int n42 = n14 + 2;
                byArray[n42] = (byte)(byArray[n42] + ((byArray3[n14 + 2] & 0xFF) - (byArray[n14 + 2] & 0xFF)) * n39 / 255);
                n14 += 4;
            }
            n14 += n15;
        }
        OS.MoveMemory(bITMAP3.bmBits, byArray, n38);
        OS.BitBlt(this.handle, n6, n7, n8, n9, n35, 0, 0, 0xCC0020);
        OS.SelectObject(n35, n37);
        OS.DeleteDC(n35);
        OS.DeleteObject(n36);
        OS.SelectObject(n33, n34);
        OS.DeleteDC(n33);
    }

    void drawBitmapTransparentByClipping(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl2, int n12, int n13) {
        int n14;
        int n15;
        int n16 = OS.CreateRectRgn(0, 0, 0, 0);
        for (n15 = 0; n15 < n13; ++n15) {
            for (int i2 = 0; i2 < n12; ++i2) {
                if (OS.GetPixel(n3, i2, n15) != 0) continue;
                int n17 = OS.CreateRectRgn(i2, n15, i2 + 1, n15 + 1);
                OS.CombineRgn(n16, n16, n17, 2);
                OS.DeleteObject(n17);
            }
        }
        if (n10 != n6 || n11 != n7) {
            n15 = OS.GetRegionData(n16, 0, null);
            int[] nArray = new int[n15 / 4];
            OS.GetRegionData(n16, n15, nArray);
            float[] fArray = new float[]{(float)n10 / (float)n6, 0.0f, 0.0f, (float)n11 / (float)n7, 0.0f, 0.0f};
            n14 = OS.ExtCreateRegion(fArray, n15, nArray);
            OS.DeleteObject(n16);
            n16 = n14;
        }
        OS.OffsetRgn(n16, n8, n9);
        n15 = OS.CreateRectRgn(0, 0, 0, 0);
        int n18 = OS.GetClipRgn(this.handle, n15);
        if (n18 == 1) {
            OS.CombineRgn(n16, n16, n15, 1);
        }
        OS.SelectClipRgn(this.handle, n16);
        int n19 = 0;
        if (!OS.IsWinCE) {
            n19 = OS.GetROP2(this.handle);
        } else {
            n19 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n19);
        }
        int n20 = n14 = n19 == 7 ? 0x660046 : 0xCC0020;
        if (!(bl2 || n6 == n10 && n7 == n11)) {
            int n21 = 0;
            if (!OS.IsWinCE) {
                n21 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, n8, n9, n10, n11, n2, n4, n5, n6, n7, n14);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n21);
            }
        } else {
            OS.BitBlt(this.handle, n8, n9, n10, n11, n2, n4, n5, n14);
        }
        OS.SelectClipRgn(this.handle, n18 == 1 ? n15 : 0);
        OS.DeleteObject(n15);
        OS.DeleteObject(n16);
    }

    void drawBitmapMask(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl2, int n12, int n13, boolean bl3) {
        int n14 = n5;
        if (n2 == 0) {
            n2 = n3;
            n14 += n13;
        }
        int n15 = OS.CreateCompatibleDC(this.handle);
        int n16 = OS.SelectObject(n15, n2);
        int n17 = this.handle;
        int n18 = n8;
        int n19 = n9;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        if (bl3) {
            n20 = OS.CreateCompatibleDC(this.handle);
            n21 = OS.CreateCompatibleBitmap(this.handle, n10, n11);
            n22 = OS.SelectObject(n20, n21);
            OS.BitBlt(n20, 0, 0, n10, n11, this.handle, n8, n9, 0xCC0020);
            n17 = n20;
            n19 = 0;
            n18 = 0;
        } else {
            n23 = OS.SetBkColor(this.handle, 0xFFFFFF);
            n24 = OS.SetTextColor(this.handle, 0);
        }
        if (!(bl2 || n6 == n10 && n7 == n11)) {
            int n25 = 0;
            if (!OS.IsWinCE) {
                n25 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(n17, n18, n19, n10, n11, n15, n4, n14, n6, n7, 0x660046);
            OS.SelectObject(n15, n3);
            OS.StretchBlt(n17, n18, n19, n10, n11, n15, n4, n5, n6, n7, 8913094);
            OS.SelectObject(n15, n2);
            OS.StretchBlt(n17, n18, n19, n10, n11, n15, n4, n14, n6, n7, 0x660046);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n25);
            }
        } else {
            OS.BitBlt(n17, n18, n19, n10, n11, n15, n4, n14, 0x660046);
            OS.SetTextColor(n17, 0);
            OS.SelectObject(n15, n3);
            OS.BitBlt(n17, n18, n19, n10, n11, n15, n4, n5, 8913094);
            OS.SelectObject(n15, n2);
            OS.BitBlt(n17, n18, n19, n10, n11, n15, n4, n14, 0x660046);
        }
        if (bl3) {
            OS.BitBlt(this.handle, n8, n9, n10, n11, n20, 0, 0, 0xCC0020);
            OS.SelectObject(n20, n22);
            OS.DeleteDC(n20);
            OS.DeleteObject(n21);
        } else {
            OS.SetBkColor(this.handle, n23);
            OS.SetTextColor(this.handle, n24);
        }
        OS.SelectObject(n15, n16);
        OS.DeleteDC(n15);
    }

    void drawBitmapTransparent(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2, BITMAP bITMAP, int n10, int n11) {
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        boolean bl3 = bITMAP.bmBits != 0;
        int n17 = image.handle;
        int n18 = OS.CreateCompatibleDC(this.handle);
        int n19 = OS.SelectObject(n18, n17);
        byte[] byArray = null;
        int n20 = image.transparentColor;
        if (n20 == -1) {
            n16 = 0;
            n15 = 0;
            n14 = 0;
            n13 = 0;
            if (bITMAP.bmBitsPixel <= 8) {
                if (bl3) {
                    if (OS.IsWinCE) {
                        byte[] byArray2 = new byte[1];
                        OS.MoveMemory(byArray2, bITMAP.bmBits, 1);
                        n12 = byArray2[0];
                        int n21 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                        byArray2[0] = (byte)(image.transparentPixel << 8 - bITMAP.bmBitsPixel | byArray2[0] & ~n21);
                        OS.MoveMemory(bITMAP.bmBits, byArray2, 1);
                        int n22 = OS.GetPixel(n18, 0, 0);
                        byArray2[0] = n12;
                        OS.MoveMemory(bITMAP.bmBits, byArray2, 1);
                        n16 = (n22 & 0xFF0000) >> 16;
                        n15 = (n22 & 0xFF00) >> 8;
                        n14 = n22 & 0xFF;
                    } else {
                        int n23 = 1 << bITMAP.bmBitsPixel;
                        byte[] byArray3 = new byte[n23 * 4];
                        OS.GetDIBColorTable(n18, 0, n23, byArray3);
                        int n24 = image.transparentPixel * 4;
                        for (int i2 = 0; i2 < byArray3.length; i2 += 4) {
                            if (i2 == n24 || byArray3[n24] != byArray3[i2] || byArray3[n24 + 1] != byArray3[i2 + 1] || byArray3[n24 + 2] != byArray3[i2 + 2]) continue;
                            n13 = 1;
                            break;
                        }
                        if (n13 != 0) {
                            byte[] byArray4 = new byte[byArray3.length];
                            n16 = 255;
                            n15 = 255;
                            n14 = 255;
                            byArray4[n24] = (byte)n16;
                            byArray4[n24 + 1] = (byte)n15;
                            byArray4[n24 + 2] = (byte)n14;
                            OS.SetDIBColorTable(n18, 0, n23, byArray4);
                            byArray = byArray3;
                        } else {
                            n16 = byArray3[n24] & 0xFF;
                            n15 = byArray3[n24 + 1] & 0xFF;
                            n14 = byArray3[n24 + 2] & 0xFF;
                        }
                    }
                } else {
                    int n25 = 1 << bITMAP.bmBitsPixel;
                    BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biPlanes = bITMAP.bmPlanes;
                    bITMAPINFOHEADER.biBitCount = bITMAP.bmBitsPixel;
                    byte[] byArray5 = new byte[BITMAPINFOHEADER.sizeof + n25 * 4];
                    OS.MoveMemory(byArray5, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n18, image.handle, 0, 0, null, byArray5, 0);
                    int n26 = BITMAPINFOHEADER.sizeof + 4 * image.transparentPixel;
                    n14 = byArray5[n26 + 2] & 0xFF;
                    n15 = byArray5[n26 + 1] & 0xFF;
                    n16 = byArray5[n26] & 0xFF;
                }
            } else {
                int n27 = image.transparentPixel;
                switch (bITMAP.bmBitsPixel) {
                    case 16: {
                        n16 = (n27 & 0x1F) << 3;
                        n15 = (n27 & 0x3E0) >> 2;
                        n14 = (n27 & 0x7C00) >> 7;
                        break;
                    }
                    case 24: {
                        n16 = (n27 & 0xFF0000) >> 16;
                        n15 = (n27 & 0xFF00) >> 8;
                        n14 = n27 & 0xFF;
                        break;
                    }
                    case 32: {
                        n16 = (n27 & 0xFF000000) >>> 24;
                        n15 = (n27 & 0xFF0000) >> 16;
                        n14 = (n27 & 0xFF00) >> 8;
                    }
                }
            }
            n20 = n16 << 16 | n15 << 8 | n14;
            if (n13 == 0) {
                image.transparentColor = n20;
            }
        }
        if (OS.IsWinCE) {
            OS.TransparentImage(this.handle, n6, n7, n8, n9, n18, n2, n3, n4, n5, n20);
        } else if (byArray == null && OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            n16 = OS.SetStretchBltMode(this.handle, 3);
            OS.TransparentBlt(this.handle, n6, n7, n8, n9, n18, n2, n3, n4, n5, n20);
            OS.SetStretchBltMode(this.handle, n16);
        } else {
            n16 = OS.CreateCompatibleDC(this.handle);
            n15 = OS.CreateBitmap(n10, n11, 1, 1, null);
            n14 = OS.SelectObject(n16, n15);
            OS.SetBkColor(n18, n20);
            OS.BitBlt(n16, 0, 0, n10, n11, n18, 0, 0, 0xCC0020);
            if (byArray != null) {
                OS.SetDIBColorTable(n18, 0, 1 << bITMAP.bmBitsPixel, byArray);
            }
            if (OS.GetDeviceCaps(this.handle, 2) == 2) {
                this.drawBitmapTransparentByClipping(n18, n16, n2, n3, n4, n5, n6, n7, n8, n9, bl2, n10, n11);
            } else {
                n13 = OS.CreateCompatibleDC(this.handle);
                int n28 = OS.CreateCompatibleBitmap(this.handle, n8, n9);
                n12 = OS.SelectObject(n13, n28);
                OS.BitBlt(n13, 0, 0, n8, n9, this.handle, n6, n7, 0xCC0020);
                if (!(bl2 || n4 == n8 && n5 == n9)) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(n13, 3);
                    }
                    OS.StretchBlt(n13, 0, 0, n8, n9, n18, n2, n3, n4, n5, 0x660046);
                    OS.StretchBlt(n13, 0, 0, n8, n9, n16, n2, n3, n4, n5, 8913094);
                    OS.StretchBlt(n13, 0, 0, n8, n9, n18, n2, n3, n4, n5, 0x660046);
                } else {
                    OS.BitBlt(n13, 0, 0, n8, n9, n18, n2, n3, 0x660046);
                    OS.BitBlt(n13, 0, 0, n8, n9, n16, n2, n3, 8913094);
                    OS.BitBlt(n13, 0, 0, n8, n9, n18, n2, n3, 0x660046);
                }
                OS.BitBlt(this.handle, n6, n7, n8, n9, n13, 0, 0, 0xCC0020);
                OS.SelectObject(n13, n12);
                OS.DeleteDC(n13);
                OS.DeleteObject(n28);
            }
            OS.SelectObject(n16, n14);
            OS.DeleteDC(n16);
            OS.DeleteObject(n15);
        }
        OS.SelectObject(n18, n19);
        if (n17 != image.handle) {
            OS.DeleteObject(n17);
        }
        OS.DeleteDC(n18);
    }

    void drawBitmap(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2, BITMAP bITMAP, int n10, int n11) {
        int n12;
        int n13 = OS.CreateCompatibleDC(this.handle);
        int n14 = OS.SelectObject(n13, image.handle);
        int n15 = 0;
        if (!OS.IsWinCE) {
            n15 = OS.GetROP2(this.handle);
        } else {
            n15 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n15);
        }
        int n16 = n12 = n15 == 7 ? 0x660046 : 0xCC0020;
        if (!(bl2 || n4 == n8 && n5 == n9)) {
            int n17 = 0;
            if (!OS.IsWinCE) {
                n17 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, n6, n7, n8, n9, n13, n2, n3, n4, n5, n12);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n17);
            }
        } else {
            OS.BitBlt(this.handle, n6, n7, n8, n9, n13, n2, n3, n12);
        }
        OS.SelectObject(n13, n14);
        OS.DeleteDC(n13);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.drawLineInPixels(n2, n3, n4, n5);
    }

    void drawLineInPixels(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n6 = this.data.gdipGraphics;
        if (n6 != 0) {
            Gdip.Graphics_TranslateTransform(n6, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawLine(n6, this.data.gdipPen, n2, n3, n4, n5);
            Gdip.Graphics_TranslateTransform(n6, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n2;
            --n4;
        }
        if (OS.IsWinCE) {
            int[] nArray = new int[]{n2, n3, n4, n5};
            OS.Polyline(this.handle, nArray, nArray.length / 2);
        } else {
            OS.MoveToEx(this.handle, n2, n3, 0);
            OS.LineTo(this.handle, n4, n5);
        }
        if (this.data.lineWidth <= 1.0f) {
            OS.SetPixel(this.handle, n4, n5, this.data.foreground);
        }
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.drawOvalInPixels(n2, n3, n4, n5);
    }

    void drawOvalInPixels(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n6 = this.data.gdipGraphics;
        if (n6 != 0) {
            Gdip.Graphics_TranslateTransform(n6, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawEllipse(n6, this.data.gdipPen, n2, n3, n4, n5);
            Gdip.Graphics_TranslateTransform(n6, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n2;
        }
        OS.Ellipse(this.handle, n2, n3, n2 + n4 + 1, n3 + n5 + 1);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initGdip();
        this.checkGC(22777);
        int n2 = this.data.gdipGraphics;
        Gdip.Graphics_TranslateTransform(n2, this.data.gdipXOffset, this.data.gdipYOffset, 0);
        Gdip.Graphics_DrawPath(n2, this.data.gdipPen, path.handle);
        Gdip.Graphics_TranslateTransform(n2, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
    }

    public void drawPoint(int n2, int n3) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.drawPointInPixels(n2, n3);
    }

    void drawPointInPixels(int n2, int n3) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics != 0) {
            this.checkGC(22777);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.getFgBrush(), n2, n3, 1, 1);
            return;
        }
        OS.SetPixel(this.handle, n2, n3, this.data.foreground);
    }

    public void drawPolygon(int[] nArray) {
        if (nArray == null) {
            SWT.error(4);
        }
        this.drawPolygonInPixels(DPIUtil.autoScaleUp(this.drawable, nArray));
    }

    void drawPolygonInPixels(int[] nArray) {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n3 = this.data.gdipGraphics;
        if (n3 != 0) {
            Gdip.Graphics_TranslateTransform(n3, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawPolygon(n3, this.data.gdipPen, nArray, nArray.length / 2);
            Gdip.Graphics_TranslateTransform(n3, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                int n4 = n2;
                nArray[n4] = nArray[n4] - 1;
            }
        }
        OS.Polygon(this.handle, nArray, nArray.length / 2);
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                int n5 = n2;
                nArray[n5] = nArray[n5] + 1;
            }
        }
    }

    public void drawPolyline(int[] nArray) {
        this.drawPolylineInPixels(DPIUtil.autoScaleUp(this.drawable, nArray));
    }

    void drawPolylineInPixels(int[] nArray) {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(22777);
        int n3 = this.data.gdipGraphics;
        if (n3 != 0) {
            Gdip.Graphics_TranslateTransform(n3, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawLines(n3, this.data.gdipPen, nArray, nArray.length / 2);
            Gdip.Graphics_TranslateTransform(n3, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                int n4 = n2;
                nArray[n4] = nArray[n4] - 1;
            }
        }
        OS.Polyline(this.handle, nArray, nArray.length / 2);
        n2 = nArray.length;
        if (n2 >= 2 && this.data.lineWidth <= 1.0f) {
            OS.SetPixel(this.handle, nArray[n2 - 2], nArray[n2 - 1], this.data.foreground);
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (int i2 = 0; i2 < nArray.length; i2 += 2) {
                int n5 = i2;
                nArray[n5] = nArray[n5] + 1;
            }
        }
    }

    public void drawRectangle(int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.drawRectangleInPixels(n2, n3, n4, n5);
    }

    void drawRectangleInPixels(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n6 = this.data.gdipGraphics;
        if (n6 != 0) {
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            Gdip.Graphics_TranslateTransform(n6, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawRectangle(n6, this.data.gdipPen, n2, n3, n4, n5);
            Gdip.Graphics_TranslateTransform(n6, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            if (this.data.lineWidth > 1.0f) {
                if (this.data.lineWidth % 2.0f == 1.0f) {
                    ++n2;
                }
            } else if (this.data.hPen != 0 && OS.GetObject(this.data.hPen, 0, 0) != LOGPEN.sizeof) {
                ++n2;
            }
        }
        OS.Rectangle(this.handle, n2, n3, n2 + n4 + 1, n3 + n5 + 1);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(this.drawable, rectangle);
        this.drawRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        n6 = DPIUtil.autoScaleUp(this.drawable, n6);
        n7 = DPIUtil.autoScaleUp(this.drawable, n7);
        this.drawRoundRectangleInPixels(n2, n3, n4, n5, n6, n7);
    }

    void drawRoundRectangleInPixels(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        if (this.data.gdipGraphics != 0) {
            this.drawRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipPen, n2, n3, n4, n5, n6, n7);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n2;
        }
        if (OS.IsWinCE) {
            if (n4 == 0 || n5 == 0) {
                return;
            }
            if (n6 == 0 || n7 == 0) {
                this.drawRectangleInPixels(n2, n3, n4, n5);
                return;
            }
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            if (n6 < 0) {
                n6 = -n6;
            }
            if (n7 < 0) {
                n7 = -n7;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            if (n7 > n5) {
                n7 = n5;
            }
            if (n6 < n4) {
                this.drawLineInPixels(n2 + n6 / 2, n3, n2 + n4 - n6 / 2, n3);
                this.drawLineInPixels(n2 + n6 / 2, n3 + n5, n2 + n4 - n6 / 2, n3 + n5);
            }
            if (n7 < n5) {
                this.drawLineInPixels(n2, n3 + n7 / 2, n2, n3 + n5 - n7 / 2);
                this.drawLineInPixels(n2 + n4, n3 + n7 / 2, n2 + n4, n3 + n5 - n7 / 2);
            }
            if (n6 != 0 && n7 != 0) {
                this.drawArcInPixels(n2, n3, n6, n7, 90, 90);
                this.drawArcInPixels(n2 + n4 - n6, n3, n6, n7, 0, 90);
                this.drawArcInPixels(n2 + n4 - n6, n3 + n5 - n7, n6, n7, 0, -90);
                this.drawArcInPixels(n2, n3 + n5 - n7, n6, n7, 180, 90);
            }
        } else {
            OS.RoundRect(this.handle, n2, n3, n2 + n4 + 1, n3 + n5 + 1, n6, n7);
        }
    }

    void drawRoundRectangleGdip(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        int n13 = n7;
        int n14 = n8;
        int n15 = n9;
        if (n12 < 0) {
            n12 = 0 - n12;
            n10 -= n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
            n11 -= n13;
        }
        if (n14 < 0) {
            n14 = 0 - n14;
        }
        if (n15 < 0) {
            n15 = 0 - n15;
        }
        Gdip.Graphics_TranslateTransform(n2, this.data.gdipXOffset, this.data.gdipYOffset, 0);
        if (n14 == 0 || n15 == 0) {
            Gdip.Graphics_DrawRectangle(n2, this.data.gdipPen, n4, n5, n6, n7);
        } else {
            int n16 = Gdip.GraphicsPath_new(0);
            if (n16 == 0) {
                SWT.error(2);
            }
            if (n12 > n14) {
                if (n13 > n15) {
                    Gdip.GraphicsPath_AddArc(n16, n10 + n12 - n14, n11, n14, n15, 0.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10, n11, n14, n15, -90.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10, n11 + n13 - n15, n14, n15, -180.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10 + n12 - n14, n11 + n13 - n15, n14, n15, -270.0f, -90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc(n16, n10 + n12 - n14, n11, n14, n13, -270.0f, -180.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10, n11, n14, n13, -90.0f, -180.0f);
                }
            } else if (n13 > n15) {
                Gdip.GraphicsPath_AddArc(n16, n10, n11, n12, n15, 0.0f, -180.0f);
                Gdip.GraphicsPath_AddArc(n16, n10, n11 + n13 - n15, n12, n15, -180.0f, -180.0f);
            } else {
                Gdip.GraphicsPath_AddArc(n16, n10, n11, n12, n13, 0.0f, 360.0f);
            }
            Gdip.GraphicsPath_CloseFigure(n16);
            Gdip.Graphics_DrawPath(n2, n3, n16);
            Gdip.GraphicsPath_delete(n16);
        }
        Gdip.Graphics_TranslateTransform(n2, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
    }

    public void drawString(String string, int n2, int n3) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.drawStringInPixels(string, n2, n3, false);
    }

    public void drawString(String string, int n2, int n3, boolean bl2) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.drawStringInPixels(string, n2, n3, bl2);
    }

    void drawStringInPixels(String string, int n2, int n3, boolean bl2) {
        int n4;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((n4 = string.length()) == 0) {
            return;
        }
        char[] cArray = new char[n4];
        string.getChars(0, n4, cArray, 0);
        int n5 = this.data.gdipGraphics;
        if (n5 != 0) {
            this.checkGC(5 | (bl2 ? 0 : 2));
            this.drawText(n5, string, n2, n3, bl2 ? 1 : 0, null);
            return;
        }
        int n6 = 0;
        if (OS.IsWinCE) {
            n6 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n6);
        } else {
            n6 = OS.GetROP2(this.handle);
        }
        this.checkGC(772);
        int n7 = OS.SetBkMode(this.handle, bl2 ? 1 : 2);
        RECT rECT = null;
        SIZE sIZE = null;
        int n8 = 0;
        if ((this.data.style & 0x8000000) != 0) {
            if (!bl2) {
                sIZE = new SIZE();
                OS.GetTextExtentPoint32W(this.handle, cArray, n4, sIZE);
                rECT = new RECT();
                rECT.left = n2;
                rECT.right = n2 + sIZE.cx;
                rECT.top = n3;
                rECT.bottom = n3 + sIZE.cy;
                n8 = 4;
            }
            --n2;
        }
        if (n6 != 7) {
            OS.ExtTextOutW(this.handle, n2, n3, n8, rECT, cArray, n4, null);
        } else {
            int n9 = OS.GetTextColor(this.handle);
            if (bl2) {
                int n10;
                int n11;
                int n12;
                if (sIZE == null) {
                    sIZE = new SIZE();
                    OS.GetTextExtentPoint32W(this.handle, cArray, n4, sIZE);
                }
                if ((n12 = OS.CreateCompatibleBitmap(this.handle, n11 = sIZE.cx, n10 = sIZE.cy)) == 0) {
                    SWT.error(2);
                }
                int n13 = OS.CreateCompatibleDC(this.handle);
                int n14 = OS.SelectObject(n13, n12);
                OS.PatBlt(n13, 0, 0, n11, n10, 66);
                OS.SetBkMode(n13, 1);
                OS.SetTextColor(n13, n9);
                OS.SelectObject(n13, OS.GetCurrentObject(this.handle, 6));
                OS.ExtTextOutW(n13, 0, 0, 0, null, cArray, n4, null);
                OS.BitBlt(this.handle, n2, n3, n11, n10, n13, 0, 0, 0x660046);
                OS.SelectObject(n13, n14);
                OS.DeleteDC(n13);
                OS.DeleteObject(n12);
            } else {
                int n15 = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, n9 ^ n15);
                OS.ExtTextOutW(this.handle, n2, n3, n8, rECT, cArray, n4, null);
                OS.SetTextColor(this.handle, n9);
            }
        }
        OS.SetBkMode(this.handle, n7);
    }

    public void drawText(String string, int n2, int n3) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.drawTextInPixels(string, n2, n3);
    }

    void drawTextInPixels(String string, int n2, int n3) {
        this.drawTextInPixels(string, n2, n3, 6);
    }

    public void drawText(String string, int n2, int n3, boolean bl2) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.drawTextInPixels(string, n2, n3, bl2);
    }

    void drawTextInPixels(String string, int n2, int n3, boolean bl2) {
        int n4 = 6;
        if (bl2) {
            n4 |= 1;
        }
        this.drawTextInPixels(string, n2, n3, n4);
    }

    public void drawText(String string, int n2, int n3, int n4) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        this.drawTextInPixels(string, n2, n3, n4);
    }

    void drawTextInPixels(String string, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int n5 = this.data.gdipGraphics;
        if (n5 != 0) {
            this.checkGC(5 | ((n4 & 1) != 0 ? 0 : 2));
            this.drawText(n5, string, n2, n3, n4, null);
            return;
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, false);
        int n6 = tCHAR.length();
        if (n6 == 0) {
            return;
        }
        RECT rECT = new RECT();
        int n7 = OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF;
        OS.SetRect(rECT, n2, n3, n7, n7);
        int n8 = 0;
        if ((n4 & 2) == 0) {
            n8 |= 0x20;
        }
        if ((n4 & 4) != 0) {
            n8 |= 0x40;
        }
        if ((n4 & 8) == 0) {
            n8 |= 0x800;
        }
        if ((n4 & 8) != 0 && (this.data.uiState & 2) != 0) {
            n8 |= 0x100000;
        }
        int n9 = 0;
        if (OS.IsWinCE) {
            n9 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n9);
        } else {
            n9 = OS.GetROP2(this.handle);
        }
        this.checkGC(772);
        int n10 = OS.SetBkMode(this.handle, (n4 & 1) != 0 ? 1 : 2);
        if (n9 != 7) {
            OS.DrawText(this.handle, tCHAR, n6, rECT, n8);
        } else {
            int n11 = OS.GetTextColor(this.handle);
            if ((n4 & 1) != 0) {
                OS.DrawText(this.handle, tCHAR, tCHAR.length(), rECT, n8 | 0x400);
                int n12 = rECT.right - rECT.left;
                int n13 = rECT.bottom - rECT.top;
                int n14 = OS.CreateCompatibleBitmap(this.handle, n12, n13);
                if (n14 == 0) {
                    SWT.error(2);
                }
                int n15 = OS.CreateCompatibleDC(this.handle);
                int n16 = OS.SelectObject(n15, n14);
                OS.PatBlt(n15, 0, 0, n12, n13, 66);
                OS.SetBkMode(n15, 1);
                OS.SetTextColor(n15, n11);
                OS.SelectObject(n15, OS.GetCurrentObject(this.handle, 6));
                OS.SetRect(rECT, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                OS.DrawText(n15, tCHAR, n6, rECT, n8);
                OS.BitBlt(this.handle, n2, n3, n12, n13, n15, 0, 0, 0x660046);
                OS.SelectObject(n15, n16);
                OS.DeleteDC(n15);
                OS.DeleteObject(n14);
            } else {
                int n17 = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, n11 ^ n17);
                OS.DrawText(this.handle, tCHAR, n6, rECT, n8);
                OS.SetTextColor(this.handle, n11);
            }
        }
        OS.SetBkMode(this.handle, n10);
    }

    boolean useGDIP(int n2, char[] cArray) {
        if (OS.IsWinCE || !OS.IsUnicode) {
            return false;
        }
        short[] sArray = new short[cArray.length];
        OS.GetGlyphIndicesW(n2, cArray, cArray.length, sArray, 1);
        block3: for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] != -1) continue;
            switch (cArray[i2]) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    void drawText(int n2, String string, int n3, int n4, int n5, Point point) {
        int n6 = string.length();
        char[] cArray = new char[n6];
        string.getChars(0, n6, cArray, 0);
        int n7 = Gdip.Graphics_GetHDC(n2);
        int n8 = this.data.hGDIFont;
        if (n8 == 0 && this.data.font != null) {
            n8 = this.data.font.handle;
        }
        int n9 = 0;
        if (n8 != 0) {
            n9 = OS.SelectObject(n7, n8);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n7, tEXTMETRIC);
        boolean bl2 = this.useGDIP(n7, cArray);
        if (n8 != 0) {
            OS.SelectObject(n7, n9);
        }
        Gdip.Graphics_ReleaseHDC(n2, n7);
        if (bl2) {
            this.drawTextGDIP(n2, string, n3, n4, n5, point == null, point);
            return;
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = n3;
        int n14 = n4;
        int n15 = 0;
        int n16 = -1;
        if ((n5 & 0xE) != 0) {
            int n17 = tEXTMETRIC.tmAveCharWidth * 8;
            while (n10 < n6) {
                int n18 = n12++;
                char c2 = cArray[n10++];
                cArray[n18] = c2;
                char c3 = c2;
                switch (c3) {
                    case '\t': {
                        if ((n5 & 4) == 0) break;
                        int n19 = n12 - n11 - 1;
                        RectF rectF = this.drawText(n2, cArray, n11, n19, n13, n14, n5, n16, tEXTMETRIC, point == null);
                        n13 = (int)((double)n13 + Math.ceil(rectF.Width));
                        n13 = n3 + ((n13 - n3) / n17 + 1) * n17;
                        n16 = -1;
                        n11 = n12;
                        break;
                    }
                    case '&': {
                        if ((n5 & 8) == 0) break;
                        if (n10 == n6) {
                            --n12;
                            break;
                        }
                        if (cArray[n10] == '&') {
                            ++n10;
                            break;
                        }
                        n16 = --n12 - n11;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((n5 & 2) == 0) break;
                        int n19 = n12 - n11 - 1;
                        if (c3 == '\r' && n12 != n6 && cArray[n12] == '\n') {
                            ++n12;
                            ++n10;
                        }
                        RectF rectF = this.drawText(n2, cArray, n11, n19, n13, n14, n5, n16, tEXTMETRIC, point == null);
                        n14 = (int)((double)n14 + Math.ceil(rectF.Height));
                        n15 = Math.max(n15, n13 + (int)Math.ceil(rectF.Width));
                        n13 = n3;
                        n16 = -1;
                        n11 = n12;
                    }
                }
            }
            n6 = n12;
        }
        RectF rectF = this.drawText(n2, cArray, n11, n6 - n11, n13, n14, n5, n16, tEXTMETRIC, point == null);
        if (point != null) {
            n14 = (int)((double)n14 + Math.ceil(rectF.Height));
            point.x = n15 = Math.max(n15, n13 + (int)Math.ceil(rectF.Width));
            point.y = n14;
        }
    }

    RectF drawText(int n2, char[] cArray, int n3, int n4, int n5, int n6, int n7, int n8, TEXTMETRIC tEXTMETRIC, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl2 && n8 != -1 && (this.data.uiState & 2) == 0;
        boolean bl5 = bl3 = !bl2 || bl4 || (n7 & 1) == 0 || (this.data.style & 0x8000000) != 0 || (n7 & 2) != 0;
        if (n4 <= 0) {
            RectF rectF = null;
            if (bl3) {
                rectF = new RectF();
                rectF.Height = tEXTMETRIC.tmHeight;
            }
            return rectF;
        }
        int n9 = n4 * 3 / 2 + 16;
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n9;
        int n10 = OS.GetProcessHeap();
        int n11 = gCP_RESULTS.lpDx = OS.HeapAlloc(n10, 8, n9 * 4);
        int n12 = gCP_RESULTS.lpGlyphs = OS.HeapAlloc(n10, 8, n9 * 2);
        int n13 = 0;
        int n14 = 50;
        if (bl4) {
            n13 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n10, 8, n9 * 4);
        }
        int n15 = Gdip.Graphics_GetHDC(n2);
        int n16 = this.data.hGDIFont;
        if (n16 == 0 && this.data.font != null) {
            n16 = this.data.font.handle;
        }
        int n17 = 0;
        if (n16 != 0) {
            n17 = OS.SelectObject(n15, n16);
        }
        if (n3 != 0) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, n3, cArray2, 0, n4);
            cArray = cArray2;
        }
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(n15, OS.GetLayout(n15) | 1);
        }
        OS.GetCharacterPlacementW(n15, cArray, n4, 0, gCP_RESULTS, n14);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(n15, OS.GetLayout(n15) & 0xFFFFFFFE);
        }
        if (n16 != 0) {
            OS.SelectObject(n15, n17);
        }
        Gdip.Graphics_ReleaseHDC(n2, n15);
        n9 = gCP_RESULTS.nGlyphs;
        int n18 = n5;
        int n19 = n6 + tEXTMETRIC.tmAscent;
        int[] nArray = new int[n9];
        OS.MoveMemory(nArray, gCP_RESULTS.lpDx, n9 * 4);
        float[] fArray = new float[nArray.length * 2];
        int n20 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[n20++] = n18;
            fArray[n20++] = n19;
            n18 += nArray[i2];
        }
        RectF rectF = null;
        if (bl3) {
            rectF = new RectF();
            Gdip.Graphics_MeasureDriverString(n2, n12, n9, this.data.gdipFont, fArray, 0, 0, rectF);
        }
        if (bl2) {
            int n21;
            if ((n7 & 1) == 0) {
                Gdip.Graphics_FillRectangle(n2, this.data.gdipBrush, n5, n6, (int)Math.ceil(rectF.Width), (int)Math.ceil(rectF.Height));
            }
            n20 = 0;
            int n22 = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n22)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform(n22, -1.0f, 1.0f, 0);
                        Gdip.LinearGradientBrush_TranslateTransform(n22, (float)(-2 * n5) - rectF.Width, 0.0f, 0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform(n22, -1.0f, 1.0f, 0);
                        Gdip.TextureBrush_TranslateTransform(n22, (float)(-2 * n5) - rectF.Width, 0.0f, 0);
                    }
                }
                n20 = Gdip.Graphics_Save(n2);
                Gdip.Graphics_ScaleTransform(n2, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(n2, (float)(-2 * n5) - rectF.Width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(n2, n12, gCP_RESULTS.nGlyphs, this.data.gdipFont, n22, fArray, 0, 0);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n22)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform(n22);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform(n22);
                    }
                }
                Gdip.Graphics_Restore(n2, n20);
            }
            if (bl4 && (n21 = Gdip.Pen_new(n22, 1.0f)) != 0) {
                int n23;
                int n24;
                int[] nArray2 = new int[1];
                OS.MoveMemory(nArray2, gCP_RESULTS.lpOrder + n8 * 4, 4);
                if ((this.data.style & 0x8000000) != 0) {
                    n24 = (int)Math.ceil(rectF.Width) - (int)fArray[nArray2[0] * 2] + 2 * n5;
                    n23 = n24 - nArray[nArray2[0]];
                } else {
                    n24 = (int)fArray[nArray2[0] * 2];
                    n23 = n24 + nArray[nArray2[0]];
                }
                int n25 = n6 + tEXTMETRIC.tmAscent + 2;
                int n26 = Gdip.Graphics_GetSmoothingMode(n2);
                Gdip.Graphics_SetSmoothingMode(n2, 3);
                Gdip.Graphics_DrawLine(n2, n21, n24, n25, n23, n25);
                Gdip.Graphics_SetSmoothingMode(n2, n26);
                Gdip.Pen_delete(n21);
            }
        }
        if (n13 != 0) {
            OS.HeapFree(n10, 0, n13);
        }
        OS.HeapFree(n10, 0, n12);
        OS.HeapFree(n10, 0, n11);
        return rectF;
    }

    void drawTextGDIP(int n2, String string, int n3, int n4, int n5, boolean bl2, Point point) {
        int n6;
        float[] fArray;
        char[] cArray;
        boolean bl3 = !bl2 || (n5 & 1) == 0;
        int n7 = string.length();
        if (n7 != 0) {
            cArray = new char[n7];
            string.getChars(0, n7, cArray, 0);
        } else {
            if (bl2) {
                return;
            }
            cArray = new char[]{' '};
        }
        PointF pointF = new PointF();
        int n8 = Gdip.StringFormat_Clone(Gdip.StringFormat_GenericTypographic());
        int n9 = Gdip.StringFormat_GetFormatFlags(n8) | 0x800;
        if ((this.data.style & 0x8000000) != 0) {
            n9 |= 1;
        }
        Gdip.StringFormat_SetFormatFlags(n8, n9);
        if ((n5 & 4) != 0) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = this.measureSpace(this.data.gdipFont, n8) * 8.0f;
        } else {
            fArray = new float[1];
        }
        float[] fArray3 = fArray;
        Gdip.StringFormat_SetTabStops(n8, 0.0f, fArray3.length, fArray3);
        int n10 = n6 = (n5 & 8) != 0 ? 1 : 0;
        if ((n5 & 8) != 0 && (this.data.uiState & 2) != 0) {
            n6 = 2;
        }
        Gdip.StringFormat_SetHotkeyPrefix(n8, n6);
        RectF rectF = null;
        if (bl3) {
            rectF = new RectF();
            Gdip.Graphics_MeasureString(n2, cArray, cArray.length, this.data.gdipFont, pointF, n8, rectF);
        }
        if (bl2) {
            if ((n5 & 1) == 0) {
                Gdip.Graphics_FillRectangle(n2, this.data.gdipBrush, n3, n4, (int)Math.ceil(rectF.Width), (int)Math.ceil(rectF.Height));
            }
            int n11 = 0;
            int n12 = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n12)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform(n12, -1.0f, 1.0f, 0);
                        Gdip.LinearGradientBrush_TranslateTransform(n12, -2 * n3, 0.0f, 0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform(n12, -1.0f, 1.0f, 0);
                        Gdip.TextureBrush_TranslateTransform(n12, -2 * n3, 0.0f, 0);
                    }
                }
                n11 = Gdip.Graphics_Save(n2);
                Gdip.Graphics_ScaleTransform(n2, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(n2, -2 * n3, 0.0f, 0);
            }
            pointF.X = n3;
            pointF.Y = n4;
            Gdip.Graphics_DrawString(n2, cArray, cArray.length, this.data.gdipFont, pointF, n8, n12);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n12)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform(n12);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform(n12);
                    }
                }
                Gdip.Graphics_Restore(n2, n11);
            }
        }
        Gdip.StringFormat_delete(n8);
        if (n7 == 0) {
            rectF.Width = 0.0f;
        }
        if (point != null) {
            point.x = (int)Math.ceil(rectF.Width);
            point.y = (int)Math.ceil(rectF.Height);
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.fillArcInPixels(n2, n3, n4, n5, n6, n7);
    }

    void fillArcInPixels(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        if (n4 == 0 || n5 == 0 || n7 == 0) {
            return;
        }
        int n8 = this.data.gdipGraphics;
        if (n8 != 0) {
            if (n4 == n5) {
                Gdip.Graphics_FillPie(n8, this.data.gdipBrush, n2, n3, n4, n5, -n6, -n7);
            } else {
                int n9 = Gdip.Graphics_Save(n8);
                Gdip.Graphics_TranslateTransform(n8, n2, n3, 0);
                Gdip.Graphics_ScaleTransform(n8, n4, n5, 0);
                Gdip.Graphics_FillPie(n8, this.data.gdipBrush, 0, 0, 1, 1, -n6, -n7);
                Gdip.Graphics_Restore(n8, n9);
            }
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --n2;
        }
        if (OS.IsWinCE) {
            if (n7 < 0) {
                n6 += n7;
                n7 = -n7;
            }
            boolean bl2 = true;
            if (n7 >= 360) {
                n7 = 360;
                bl2 = false;
            }
            int[] nArray = new int[(n7 + 1) * 2 + (bl2 ? 4 : 0)];
            int n10 = 2 * n2 + n4;
            int n11 = 2 * n3 + n5;
            int n12 = bl2 ? 2 : 0;
            for (int i2 = 0; i2 <= n7; ++i2) {
                nArray[n12++] = GC.cos(n6 + i2, n4) + n10 >> 1;
                nArray[n12++] = n11 - GC.sin(n6 + i2, n5) >> 1;
            }
            if (bl2) {
                int n13 = n10 >> 1;
                nArray[nArray.length - 2] = n13;
                nArray[0] = n13;
                int n14 = n11 >> 1;
                nArray[nArray.length - 1] = n14;
                nArray[1] = n14;
            }
            OS.Polygon(this.handle, nArray, nArray.length / 2);
        } else {
            int n15;
            int n16;
            int n17;
            int n18;
            if (n7 >= 360 || n7 <= -360) {
                n17 = n18 = n2 + n4;
                n15 = n16 = n3 + n5 / 2;
            } else {
                boolean bl3 = n7 < 0;
                n7 += n6;
                if (bl3) {
                    int n19 = n6;
                    n6 = n7;
                    n7 = n19;
                }
                n17 = GC.cos(n6, n4) + n2 + n4 / 2;
                n15 = -1 * GC.sin(n6, n5) + n3 + n5 / 2;
                n18 = GC.cos(n7, n4) + n2 + n4 / 2;
                n16 = -1 * GC.sin(n7, n5) + n3 + n5 / 2;
            }
            OS.Pie(this.handle, n2, n3, n2 + n4 + 1, n3 + n5 + 1, n17, n15, n18, n16);
        }
    }

    public void fillGradientRectangle(int n2, int n3, int n4, int n5, boolean bl2) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.fillGradientRectangleInPixels(n2, n3, n4, n5, bl2);
    }

    void fillGradientRectangleInPixels(int n2, int n3, int n4, int n5, boolean bl2) {
        int n6;
        int n7;
        RGB rGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        RGB rGB2 = this.getBackground().getRGB();
        RGB rGB3 = rGB = this.getForeground().getRGB();
        RGB rGB4 = rGB2;
        boolean bl3 = false;
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (!bl2) {
                bl3 = true;
            }
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
            if (bl2) {
                bl3 = true;
            }
        }
        if (bl3) {
            rGB3 = rGB2;
            rGB4 = rGB;
        }
        if (rGB3.equals(rGB4)) {
            this.fillRectangleInPixels(n2, n3, n4, n5);
            return;
        }
        if (this.data.gdipGraphics != 0) {
            int n8;
            this.initGdip();
            PointF pointF = new PointF();
            PointF pointF2 = new PointF();
            pointF.X = n2;
            pointF.Y = n3;
            if (bl2) {
                pointF2.X = pointF.X;
                pointF2.Y = pointF.Y + (float)n5;
            } else {
                pointF2.X = pointF.X + (float)n4;
                pointF2.Y = pointF.Y;
            }
            int n9 = (rGB3.red & 0xFF) << 16 | (rGB3.green & 0xFF) << 8 | rGB3.blue & 0xFF;
            int n10 = Gdip.Color_new(this.data.alpha << 24 | n9);
            if (n10 == 0) {
                SWT.error(2);
            }
            if ((n8 = Gdip.Color_new(this.data.alpha << 24 | (n9 = (rGB4.red & 0xFF) << 16 | (rGB4.green & 0xFF) << 8 | rGB4.blue & 0xFF))) == 0) {
                SWT.error(2);
            }
            int n11 = Gdip.LinearGradientBrush_new(pointF, pointF2, n10, n8);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, n11, n2, n3, n4, n5);
            Gdip.LinearGradientBrush_delete(n11);
            Gdip.Color_delete(n10);
            Gdip.Color_delete(n8);
            return;
        }
        int n12 = 0;
        if (OS.IsWinCE) {
            n12 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n12);
        } else {
            n12 = OS.GetROP2(this.handle);
        }
        if (OS.IsWinNT && n12 != 7 && OS.GetDeviceCaps(this.handle, 2) != 2) {
            n7 = OS.GetProcessHeap();
            n6 = OS.HeapAlloc(n7, 8, GRADIENT_RECT.sizeof + TRIVERTEX.sizeof * 2);
            if (n6 == 0) {
                SWT.error(2);
            }
            int n13 = n6 + GRADIENT_RECT.sizeof;
            GRADIENT_RECT gRADIENT_RECT = new GRADIENT_RECT();
            gRADIENT_RECT.UpperLeft = 0;
            gRADIENT_RECT.LowerRight = 1;
            OS.MoveMemory(n6, gRADIENT_RECT, GRADIENT_RECT.sizeof);
            TRIVERTEX tRIVERTEX = new TRIVERTEX();
            tRIVERTEX.x = n2;
            tRIVERTEX.y = n3;
            tRIVERTEX.Red = (short)(rGB3.red << 8 | rGB3.red);
            tRIVERTEX.Green = (short)(rGB3.green << 8 | rGB3.green);
            tRIVERTEX.Blue = (short)(rGB3.blue << 8 | rGB3.blue);
            tRIVERTEX.Alpha = (short)-1;
            OS.MoveMemory(n13, tRIVERTEX, TRIVERTEX.sizeof);
            tRIVERTEX.x = n2 + n4;
            tRIVERTEX.y = n3 + n5;
            tRIVERTEX.Red = (short)(rGB4.red << 8 | rGB4.red);
            tRIVERTEX.Green = (short)(rGB4.green << 8 | rGB4.green);
            tRIVERTEX.Blue = (short)(rGB4.blue << 8 | rGB4.blue);
            tRIVERTEX.Alpha = (short)-1;
            OS.MoveMemory(n13 + TRIVERTEX.sizeof, tRIVERTEX, TRIVERTEX.sizeof);
            boolean bl4 = OS.GradientFill(this.handle, n13, 2, n6, 1, bl2 ? 1 : 0);
            OS.HeapFree(n7, 0, n6);
            if (bl4) {
                return;
            }
        }
        n6 = (n7 = OS.GetDeviceCaps(this.handle, 12)) >= 24 ? 8 : (n7 >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, n2, n3, n4, n5, bl2, rGB3, rGB4, n6, n6, n6);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.fillOvalInPixels(n2, n3, n4, n5);
    }

    void fillOvalInPixels(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_FillEllipse(this.data.gdipGraphics, this.data.gdipBrush, n2, n3, n4, n5);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --n2;
        }
        OS.Ellipse(this.handle, n2, n3, n2 + n4 + 1, n3 + n5 + 1);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initGdip();
        this.checkGC(9218);
        int n2 = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(path.handle, n2);
        Gdip.Graphics_FillPath(this.data.gdipGraphics, this.data.gdipBrush, path.handle);
    }

    public void fillPolygon(int[] nArray) {
        if (nArray == null) {
            SWT.error(4);
        }
        this.fillPolygonInPixels(DPIUtil.autoScaleUp(this.drawable, nArray));
    }

    void fillPolygonInPixels(int[] nArray) {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            int n3 = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
            Gdip.Graphics_FillPolygon(this.data.gdipGraphics, this.data.gdipBrush, nArray, nArray.length / 2, n3);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                int n4 = n2;
                nArray[n4] = nArray[n4] - 1;
            }
        }
        OS.Polygon(this.handle, nArray, nArray.length / 2);
        if ((this.data.style & 0x8000000) != 0) {
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                int n5 = n2;
                nArray[n5] = nArray[n5] + 1;
            }
        }
    }

    public void fillRectangle(int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.fillRectangleInPixels(n2, n3, n4, n5);
    }

    void fillRectangleInPixels(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, n2, n3, n4, n5);
            return;
        }
        int n6 = 0;
        if (OS.IsWinCE) {
            n6 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n6);
        } else {
            n6 = OS.GetROP2(this.handle);
        }
        int n7 = n6 == 7 ? 5898313 : 15728673;
        OS.PatBlt(this.handle, n2, n3, n4, n5, n7);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(this.drawable, rectangle);
        this.fillRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        n6 = DPIUtil.autoScaleUp(this.drawable, n6);
        n7 = DPIUtil.autoScaleUp(this.drawable, n7);
        this.fillRoundRectangleInPixels(n2, n3, n4, n5, n6, n7);
    }

    void fillRoundRectangleInPixels(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            this.fillRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipBrush, n2, n3, n4, n5, n6, n7);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --n2;
        }
        OS.RoundRect(this.handle, n2, n3, n2 + n4 + 1, n3 + n5 + 1, n6, n7);
    }

    void fillRoundRectangleGdip(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        int n13 = n7;
        int n14 = n8;
        int n15 = n9;
        if (n12 < 0) {
            n12 = 0 - n12;
            n10 -= n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
            n11 -= n13;
        }
        if (n14 < 0) {
            n14 = 0 - n14;
        }
        if (n15 < 0) {
            n15 = 0 - n15;
        }
        if (n14 == 0 || n15 == 0) {
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, n4, n5, n6, n7);
        } else {
            int n16 = Gdip.GraphicsPath_new(0);
            if (n16 == 0) {
                SWT.error(2);
            }
            if (n12 > n14) {
                if (n13 > n15) {
                    Gdip.GraphicsPath_AddArc(n16, n10 + n12 - n14, n11, n14, n15, 0.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10, n11, n14, n15, -90.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10, n11 + n13 - n15, n14, n15, -180.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10 + n12 - n14, n11 + n13 - n15, n14, n15, -270.0f, -90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc(n16, n10 + n12 - n14, n11, n14, n13, -270.0f, -180.0f);
                    Gdip.GraphicsPath_AddArc(n16, n10, n11, n14, n13, -90.0f, -180.0f);
                }
            } else if (n13 > n15) {
                Gdip.GraphicsPath_AddArc(n16, n10, n11, n12, n15, 0.0f, -180.0f);
                Gdip.GraphicsPath_AddArc(n16, n10, n11 + n13 - n15, n12, n15, -180.0f, -180.0f);
            } else {
                Gdip.GraphicsPath_AddArc(n16, n10, n11, n12, n13, 0.0f, 360.0f);
            }
            Gdip.GraphicsPath_CloseFigure(n16);
            Gdip.Graphics_FillPath(n2, n3, n16);
            Gdip.GraphicsPath_delete(n16);
        }
    }

    void flush() {
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_Flush(this.data.gdipGraphics, 0);
            int n2 = Gdip.Graphics_GetHDC(this.data.gdipGraphics);
            Gdip.Graphics_ReleaseHDC(this.data.gdipGraphics, n2);
        }
    }

    public int getAdvanceWidth(char n2) {
        Object object;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        if (OS.IsWinCE) {
            SIZE sIZE = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{n2}, 1, sIZE);
            return sIZE.cx;
        }
        int n3 = n2;
        if (n2 > 127) {
            object = new TCHAR(this.getCodePage(), (char)n2, false);
            n3 = ((TCHAR)object).tcharAt(0);
        }
        object = new int[1];
        OS.GetCharWidth(this.handle, n3, n3, (int[])object);
        return (int)object[0];
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.gdipGraphics != 0;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int n2 = Gdip.Graphics_GetSmoothingMode(this.data.gdipGraphics);
        switch (n2) {
            case 0: {
                return -1;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.win32_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char n2) {
        Object object;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        if (!OS.IsWinCE) {
            int n3 = n2;
            if (n2 > 127) {
                object = new TCHAR(this.getCodePage(), (char)n2, false);
                n3 = object.tcharAt(0);
            }
            if (OS.GetCharABCWidths(this.handle, n3, n3, object = new int[3])) {
                return object[1];
            }
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, tEXTMETRIC);
        object = new SIZE();
        OS.GetTextExtentPoint32W(this.handle, new char[]{n2}, 1, (SIZE)object);
        return object.cx - tEXTMETRIC.tmOverhang;
    }

    public Rectangle getClipping() {
        return DPIUtil.autoScaleDown(this.drawable, this.getClippingInPixels());
    }

    Rectangle getClippingInPixels() {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n2 = this.data.gdipGraphics) != 0) {
            Rect rect = new Rect();
            Gdip.Graphics_SetPixelOffsetMode(n2, 3);
            Gdip.Graphics_GetVisibleClipBounds(n2, rect);
            Gdip.Graphics_SetPixelOffsetMode(n2, 4);
            return new Rectangle(rect.X, rect.Y, rect.Width, rect.Height);
        }
        RECT rECT = new RECT();
        OS.GetClipBox(this.handle, rECT);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public void getClipping(Region region) {
        int n2;
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if ((n3 = this.data.gdipGraphics) != 0) {
            int n4 = Gdip.Region_new();
            Gdip.Graphics_GetClip(this.data.gdipGraphics, n4);
            if (Gdip.Region_IsInfinite(n4, n3)) {
                Rect rect = new Rect();
                Gdip.Graphics_SetPixelOffsetMode(n3, 3);
                Gdip.Graphics_GetVisibleClipBounds(n3, rect);
                Gdip.Graphics_SetPixelOffsetMode(n3, 4);
                OS.SetRectRgn(region.handle, rect.X, rect.Y, rect.X + rect.Width, rect.Y + rect.Height);
            } else {
                int n5 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                int n6 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                Gdip.Graphics_GetTransform(n3, n5);
                Gdip.Graphics_SetTransform(n3, n6);
                int n7 = Gdip.Region_GetHRGN(n4, this.data.gdipGraphics);
                Gdip.Graphics_SetTransform(n3, n5);
                Gdip.Matrix_delete(n6);
                Gdip.Matrix_delete(n5);
                if (!OS.IsWinCE) {
                    POINT pOINT = new POINT();
                    OS.GetWindowOrgEx(this.handle, pOINT);
                    OS.OffsetRgn(n7, pOINT.x, pOINT.y);
                }
                OS.CombineRgn(region.handle, n7, 0, 5);
                OS.DeleteObject(n7);
            }
            Gdip.Region_delete(n4);
            return;
        }
        POINT pOINT = new POINT();
        if (!OS.IsWinCE) {
            OS.GetWindowOrgEx(this.handle, pOINT);
        }
        if ((n2 = OS.GetClipRgn(this.handle, region.handle)) != 1) {
            RECT rECT = new RECT();
            OS.GetClipBox(this.handle, rECT);
            OS.SetRectRgn(region.handle, rECT.left, rECT.top, rECT.right, rECT.bottom);
        } else {
            OS.OffsetRgn(region.handle, pOINT.x, pOINT.y);
        }
        if (!OS.IsWinCE) {
            int n8 = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetMetaRgn(this.handle, n8) != 0) {
                OS.OffsetRgn(n8, pOINT.x, pOINT.y);
                OS.CombineRgn(region.handle, n8, region.handle, 1);
            }
            OS.DeleteObject(n8);
            int n9 = this.data.hwnd;
            if (n9 != 0 && this.data.ps != null) {
                int n10 = OS.CreateRectRgn(0, 0, 0, 0);
                if (OS.GetRandomRgn(this.handle, n10, 4) == 1) {
                    if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (OS.GetLayout(this.handle) & 1) != 0) {
                        int n11 = OS.GetRegionData(n10, 0, null);
                        int[] nArray = new int[n11 / 4];
                        OS.GetRegionData(n10, n11, nArray);
                        int n12 = OS.ExtCreateRegion(new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, n11, nArray);
                        OS.DeleteObject(n10);
                        n10 = n12;
                    }
                    if (OS.IsWinNT) {
                        OS.MapWindowPoints(0, n9, pOINT, 1);
                        OS.OffsetRgn(n10, pOINT.x, pOINT.y);
                    }
                    OS.CombineRgn(region.handle, n10, region.handle, 1);
                }
                OS.DeleteObject(n10);
            }
        }
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        int[] nArray = new int[8];
        int n2 = OS.GetTextCharset(this.handle);
        OS.TranslateCharsetInfo(n2, nArray, 1);
        return nArray[1];
    }

    int getFgBrush() {
        return this.data.foregroundPattern != null ? this.data.foregroundPattern.handle : this.data.gdipFgBrush;
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            return 1;
        }
        return OS.GetPolyFillMode(this.handle) == 2 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, tEXTMETRIC);
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.win32_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int n2 = Gdip.Graphics_GetInterpolationMode(this.data.gdipGraphics);
        switch (n2) {
            case 0: {
                return -1;
            }
            case 5: {
                return 0;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        LineAttributes lineAttributes = this.getLineAttributesInPixels();
        lineAttributes.width = DPIUtil.autoScaleDown(this.drawable, lineAttributes.width);
        return lineAttributes;
    }

    LineAttributes getLineAttributesInPixels() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = (int)this.data.lineDashes[i2];
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        return DPIUtil.autoScaleDown(this.drawable, this.getLineWidthInPixels());
    }

    int getLineWidthInPixels() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int n2 = Gdip.Graphics_GetTextRenderingHint(this.data.gdipGraphics);
        switch (n2) {
            case 0: {
                return -1;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((n2 = this.data.gdipGraphics) != 0) {
            Gdip.Graphics_GetTransform(n2, transform.handle);
            int n3 = this.identity();
            Gdip.Matrix_Invert(n3);
            Gdip.Matrix_Multiply(transform.handle, n3, 1);
            Gdip.Matrix_delete(n3);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n2 = 0;
        if (OS.IsWinCE) {
            n2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n2);
        } else {
            n2 = OS.GetROP2(this.handle);
        }
        return n2 == 7;
    }

    void initGdip() {
        this.data.device.checkGDIP();
        int n2 = this.data.gdipGraphics;
        if (n2 != 0) {
            return;
        }
        int n3 = OS.CreateRectRgn(0, 0, 0, 0);
        int n4 = OS.GetClipRgn(this.handle, n3);
        if (!OS.IsWinCE) {
            POINT pOINT = new POINT();
            OS.GetWindowOrgEx(this.handle, pOINT);
            OS.OffsetRgn(n3, pOINT.x, pOINT.y);
        }
        OS.SelectClipRgn(this.handle, 0);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(this.handle, OS.GetLayout(this.handle) & 0xFFFFFFFE);
        }
        if ((n2 = (this.data.gdipGraphics = Gdip.Graphics_new(this.handle))) == 0) {
            SWT.error(2);
        }
        Gdip.Graphics_SetPageUnit(n2, 2);
        Gdip.Graphics_SetPixelOffsetMode(n2, 4);
        if ((this.data.style & 0x8000000) != 0) {
            int n5 = this.identity();
            Gdip.Graphics_SetTransform(n2, n5);
            Gdip.Matrix_delete(n5);
        }
        if (n4 == 1) {
            this.setClipping(n3);
        }
        OS.DeleteObject(n3);
        this.data.state = 0;
        if (this.data.hPen != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(8));
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0;
        }
        if (this.data.hBrush != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(5));
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0;
        }
    }

    int identity() {
        if ((this.data.style & 0x8000000) != 0) {
            Object object;
            int n2 = 0;
            int n3 = OS.GetDeviceCaps(this.handle, 2);
            if (n3 == 2) {
                n2 = OS.GetDeviceCaps(this.handle, 110);
            } else {
                object = this.data.image;
                if (object != null) {
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(((Image)object).handle, BITMAP.sizeof, bITMAP);
                    n2 = bITMAP.bmWidth;
                } else {
                    int n4;
                    int n5 = n4 = OS.IsWinCE ? this.data.hwnd : OS.WindowFromDC(this.handle);
                    if (n4 != 0) {
                        RECT rECT = new RECT();
                        OS.GetClientRect(n4, rECT);
                        n2 = rECT.right - rECT.left;
                    } else {
                        int n6 = OS.GetCurrentObject(this.handle, 7);
                        BITMAP bITMAP = new BITMAP();
                        OS.GetObject(n6, BITMAP.sizeof, bITMAP);
                        n2 = bITMAP.bmWidth;
                    }
                }
            }
            object = new POINT();
            if (!OS.IsWinCE) {
                OS.GetWindowOrgEx(this.handle, (POINT)object);
            }
            return Gdip.Matrix_new(-1.0f, 0.0f, 0.0f, 1.0f, n2 + 2 * ((POINT)object).x, 0.0f);
        }
        return Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    void init(Drawable drawable, GCData gCData, int n2) {
        int n3;
        Image image;
        int n4 = gCData.foreground;
        if (n4 != -1) {
            gCData.state &= 0xFFFFF6FE;
        } else {
            gCData.foreground = OS.GetTextColor(n2);
        }
        int n5 = gCData.background;
        if (n5 != -1) {
            gCData.state &= 0xFFFFF9FD;
        } else {
            gCData.background = OS.GetBkColor(n2);
        }
        gCData.state &= 0xFFFFCFFF;
        Font font = gCData.font;
        if (font != null) {
            gCData.state &= 0xFFFFFFFB;
        } else {
            gCData.font = Font.win32_new(this.device, OS.GetCurrentObject(n2, 6));
        }
        int n6 = gCData.device.hPalette;
        if (n6 != 0) {
            OS.SelectPalette(n2, n6, true);
            OS.RealizePalette(n2);
        }
        if ((image = gCData.image) != null) {
            gCData.hNullBitmap = OS.SelectObject(n2, image.handle);
            image.memGC = this;
        }
        if ((n3 = gCData.layout) != -1 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            int n7 = OS.GetLayout(n2);
            if ((n7 & 1) != (n3 & 1)) {
                OS.SetLayout(n2, (n7 &= 0xFFFFFFFE) | n3);
            }
            if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n2;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n2 = this.data.gdipGraphics) != 0) {
            int n3 = Gdip.Region_new();
            Gdip.Graphics_GetClip(this.data.gdipGraphics, n3);
            boolean bl2 = Gdip.Region_IsInfinite(n3, n2);
            Gdip.Region_delete(n3);
            return !bl2;
        }
        int n4 = OS.CreateRectRgn(0, 0, 0, 0);
        int n5 = OS.GetClipRgn(this.handle, n4);
        OS.DeleteObject(n4);
        return n5 > 0;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    float measureSpace(int n2, int n3) {
        PointF pointF = new PointF();
        RectF rectF = new RectF();
        Gdip.Graphics_MeasureString(this.data.gdipGraphics, new char[]{' '}, 1, n2, pointF, n3, rectF);
        return rectF.Width;
    }

    public void setAdvanced(boolean bl2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (bl2 && this.data.gdipGraphics != 0) {
            return;
        }
        if (bl2) {
            try {
                this.initGdip();
            }
            catch (SWTException sWTException) {}
        } else {
            this.disposeGdip();
            this.data.alpha = 255;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0);
            if ((this.data.style & 0x8000000) != 0) {
                OS.SetLayout(this.handle, OS.GetLayout(this.handle) | 1);
            }
        }
    }

    public void setAntialias(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && n2 == -1) {
            return;
        }
        int n3 = 0;
        switch (n2) {
            case -1: {
                n3 = 0;
                break;
            }
            case 0: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 4;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetSmoothingMode(this.data.gdipGraphics, n3);
    }

    public void setAlpha(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && (n2 & 0xFF) == 255) {
            return;
        }
        this.initGdip();
        this.data.alpha = n2 & 0xFF;
        this.data.state &= 0xFFFFFFFC;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == null && this.data.background == color.handle) {
            return;
        }
        this.data.backgroundPattern = null;
        this.data.background = color.handle;
        this.data.state &= 0xFFFFFDFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && pattern == null) {
            return;
        }
        this.initGdip();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    void setClipping(int n2) {
        int n3 = n2;
        int n4 = this.data.gdipGraphics;
        if (n4 != 0) {
            if (n3 != 0) {
                int n5 = Gdip.Region_new(n3);
                Gdip.Graphics_SetClip(n4, n5, 0);
                Gdip.Region_delete(n5);
            } else {
                Gdip.Graphics_ResetClip(n4);
            }
        } else {
            POINT pOINT = null;
            if (n3 != 0 && !OS.IsWinCE) {
                pOINT = new POINT();
                OS.GetWindowOrgEx(this.handle, pOINT);
                OS.OffsetRgn(n3, -pOINT.x, -pOINT.y);
            }
            OS.SelectClipRgn(this.handle, n3);
            if (n3 != 0 && !OS.IsWinCE) {
                OS.OffsetRgn(n3, pOINT.x, pOINT.y);
            }
        }
    }

    public void setClipping(int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        n3 = DPIUtil.autoScaleUp(this.drawable, n3);
        n4 = DPIUtil.autoScaleUp(this.drawable, n4);
        n5 = DPIUtil.autoScaleUp(this.drawable, n5);
        this.setClippingInPixels(n2, n3, n4, n5);
    }

    void setClippingInPixels(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n6 = OS.CreateRectRgn(n2, n3, n2 + n4, n3 + n5);
        this.setClipping(n6);
        OS.DeleteObject(n6);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0);
        if (path != null) {
            this.initGdip();
            int n2 = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
            Gdip.GraphicsPath_SetFillMode(path.handle, n2);
            Gdip.Graphics_SetClipPath(this.data.gdipGraphics, path.handle);
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            this.setClipping(0);
        } else {
            rectangle = DPIUtil.autoScaleUp(this.drawable, rectangle);
            this.setClippingInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFillRule(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            return;
        }
        int n3 = 1;
        switch (n2) {
            case 2: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.SetPolyFillMode(this.handle, n3);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == null && color.handle == this.data.foreground) {
            return;
        }
        this.data.foregroundPattern = null;
        this.data.foreground = color.handle;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && pattern == null) {
            return;
        }
        this.initGdip();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && n2 == -1) {
            return;
        }
        int n3 = 0;
        switch (n2) {
            case -1: {
                n3 = 0;
                break;
            }
            case 0: {
                n3 = 5;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetInterpolationMode(this.data.gdipGraphics, n3);
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        if (lineAttributes == null) {
            SWT.error(4);
        }
        lineAttributes.width = DPIUtil.autoScaleUp(this.drawable, lineAttributes.width);
        this.setLineAttributesInPixels(lineAttributes);
    }

    void setLineAttributesInPixels(LineAttributes lineAttributes) {
        float f2;
        int n2;
        int n3;
        int n4;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n5 = 0;
        float f3 = lineAttributes.width;
        if (f3 != this.data.lineWidth) {
            n5 |= 0x4010;
        }
        if ((n4 = lineAttributes.style) != this.data.lineStyle) {
            n5 |= 8;
            switch (n4) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n4 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n3 = lineAttributes.join) != this.data.lineJoin) {
            n5 |= 0x40;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.cap) != this.data.lineCap) {
            n5 |= 0x20;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl2 = fArray2 == null || fArray2.length != fArray.length;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                float f4 = fArray[i2];
                if (f4 <= 0.0f) {
                    SWT.error(5);
                }
                if (bl2 || fArray2[i2] == f4) continue;
                bl2 = true;
            }
            if (bl2) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n5 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n5 |= 8;
        } else {
            fArray = fArray2;
        }
        float f5 = lineAttributes.dashOffset;
        if (f5 != this.data.lineDashesOffset) {
            n5 |= 8;
        }
        if ((f2 = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n5 |= 0x80;
        }
        this.initGdip();
        if (n5 == 0) {
            return;
        }
        this.data.lineWidth = f3;
        this.data.lineStyle = n4;
        this.data.lineCap = n2;
        this.data.lineJoin = n3;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f5;
        this.data.lineMiterLimit = f2;
        this.data.state &= ~n5;
    }

    public void setLineCap(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == n2) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n2;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            int n2;
            boolean bl2 = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n3 = nArray[n2];
                if (n3 <= 0) {
                    SWT.error(5);
                }
                if (bl2 || fArray[n2] == (float)n3) continue;
                bl2 = true;
            }
            if (!bl2) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.data.lineDashes[n2] = nArray[n2];
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n2) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n2;
        this.data.state &= 0xFFFFFFBF;
    }

    public void setLineStyle(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n2) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n2 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n2;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n2) {
        n2 = DPIUtil.autoScaleUp(this.drawable, n2);
        this.setLineWidthInPixels(n2);
    }

    void setLineWidthInPixels(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)n2) {
            return;
        }
        this.data.lineWidth = n2;
        this.data.state &= 0xFFFFBFEF;
    }

    public void setXORMode(boolean bl2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetROP2(this.handle, bl2 ? 7 : 13);
    }

    public void setTextAntialias(int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && n2 == -1) {
            return;
        }
        int n3 = 0;
        switch (n2) {
            case -1: {
                n3 = 0;
                break;
            }
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                int[] nArray = new int[1];
                OS.SystemParametersInfo(8202, 0, nArray, 0);
                if (nArray[0] == 2) {
                    n3 = 5;
                    break;
                }
                n3 = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetTextRenderingHint(this.data.gdipGraphics, n3);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && transform == null) {
            return;
        }
        this.initGdip();
        int n2 = this.identity();
        if (transform != null) {
            Gdip.Matrix_Multiply(n2, transform.handle, 0);
        }
        Gdip.Graphics_SetTransform(this.data.gdipGraphics, n2);
        Gdip.Matrix_delete(n2);
        this.data.state &= 0xFFFFBFFF;
    }

    public Point stringExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        return DPIUtil.autoScaleDown(this.drawable, this.stringExtentInPixels(string));
    }

    Point stringExtentInPixels(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int n2 = string.length();
        int n3 = this.data.gdipGraphics;
        if (n3 != 0) {
            Point point = new Point(0, 0);
            this.drawText(n3, string, 0, 0, 0, point);
            return point;
        }
        SIZE sIZE = new SIZE();
        if (n2 == 0) {
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, sIZE);
            return new Point(0, sIZE.cy);
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        OS.GetTextExtentPoint32W(this.handle, cArray, n2, sIZE);
        return new Point(sIZE.cx, sIZE.cy);
    }

    public Point textExtent(String string) {
        return DPIUtil.autoScaleDown(this.drawable, this.textExtentInPixels(string, 6));
    }

    public Point textExtent(String string, int n2) {
        return DPIUtil.autoScaleDown(this.drawable, this.textExtentInPixels(string, n2));
    }

    Point textExtentInPixels(String string, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(4);
        int n3 = this.data.gdipGraphics;
        if (n3 != 0) {
            Point point = new Point(0, 0);
            this.drawText(n3, string, 0, 0, n2, point);
            return point;
        }
        if (string.length() == 0) {
            SIZE sIZE = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, sIZE);
            return new Point(0, sIZE.cy);
        }
        RECT rECT = new RECT();
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, false);
        int n4 = 1024;
        if ((n2 & 2) == 0) {
            n4 |= 0x20;
        }
        if ((n2 & 4) != 0) {
            n4 |= 0x40;
        }
        if ((n2 & 8) == 0) {
            n4 |= 0x800;
        }
        OS.DrawText(this.handle, tCHAR, tCHAR.length(), rECT, n4);
        return new Point(rECT.right, rECT.bottom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        int n2 = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, n2);
        return gC;
    }

    public static GC win32_new(int n2, GCData gCData) {
        int n3;
        GC gC = new GC();
        gC.device = gCData.device;
        gCData.style |= 0x2000000;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && ((n3 = OS.GetLayout(n2)) & 1) != 0) {
            gCData.style |= 0xC000000;
        }
        gC.init(null, gCData, n2);
        return gC;
    }

    private static int cos(int n2, int n3) {
        return (int)(Math.cos((double)n2 * (Math.PI / 180)) * (double)n3);
    }

    private static int sin(int n2, int n3) {
        return (int)(Math.sin((double)n2 * (Math.PI / 180)) * (double)n3);
    }
}

