/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.io.InputStream;

final class LEDataInputStream
extends InputStream {
    int position;
    InputStream in;
    protected byte[] buf;
    protected int pos;

    public LEDataInputStream(InputStream inputStream) {
        this(inputStream, 512);
    }

    public LEDataInputStream(InputStream inputStream, int n2) {
        this.in = inputStream;
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n2];
        this.pos = n2;
    }

    @Override
    public void close() throws IOException {
        this.buf = null;
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public int available() throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        return this.buf.length - this.pos + this.in.available();
    }

    @Override
    public int read() throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        if (this.pos < this.buf.length) {
            ++this.position;
            return this.buf[this.pos++] & 0xFF;
        }
        int n2 = this.in.read();
        if (n2 != -1) {
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n4 = 0; n4 != n3 && (n5 = this.readData(byArray, n2, n3 - n4)) != -1; n4 += n5) {
            n2 += n5;
        }
        this.position += n4;
        if (n4 == 0 && n4 != n3) {
            return -1;
        }
        return n4;
    }

    private int readData(byte[] byArray, int n2, int n3) throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n3 > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = 0;
        int n5 = n2;
        int n6 = this.buf.length - this.pos;
        if (n6 > 0) {
            n4 = n6 >= n3 ? n3 : n6;
            System.arraycopy(this.buf, this.pos, byArray, n5, n4);
            n5 += n4;
            this.pos += n4;
        }
        if (n4 == n3) {
            return n3;
        }
        int n7 = this.in.read(byArray, n5, n3 - n4);
        if (n7 > 0) {
            return n7 + n4;
        }
        if (n4 == 0) {
            return n7;
        }
        return n4;
    }

    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.read(byArray);
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        this.read(byArray);
        return (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    public void unread(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (n2 > this.pos) {
            throw new IOException();
        }
        this.position -= n2;
        this.pos -= n2;
        System.arraycopy(byArray, 0, this.buf, this.pos, n2);
    }
}

