/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XColormapEvent$Buffer;

public class XColormapEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int COLORMAP;
    public static final int NEW;
    public static final int STATE;

    protected XColormapEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XColormapEvent create(long l2, ByteBuffer byteBuffer) {
        return new XColormapEvent(l2, byteBuffer);
    }

    public XColormapEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XColormapEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XColormapEvent.ntype(this.address());
    }

    public long serial() {
        return XColormapEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XColormapEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XColormapEvent.ndisplay(this.address());
    }

    public long window() {
        return XColormapEvent.nwindow(this.address());
    }

    public long colormap() {
        return XColormapEvent.ncolormap(this.address());
    }

    public int new$() {
        return XColormapEvent.nnew$(this.address());
    }

    public int state() {
        return XColormapEvent.nstate(this.address());
    }

    public XColormapEvent type(int n2) {
        XColormapEvent.ntype(this.address(), n2);
        return this;
    }

    public XColormapEvent serial(long l2) {
        XColormapEvent.nserial(this.address(), l2);
        return this;
    }

    public XColormapEvent send_event(boolean bl2) {
        XColormapEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XColormapEvent display(long l2) {
        XColormapEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XColormapEvent window(long l2) {
        XColormapEvent.nwindow(this.address(), l2);
        return this;
    }

    public XColormapEvent colormap(long l2) {
        XColormapEvent.ncolormap(this.address(), l2);
        return this;
    }

    public XColormapEvent new$(int n2) {
        XColormapEvent.nnew$(this.address(), n2);
        return this;
    }

    public XColormapEvent state(int n2) {
        XColormapEvent.nstate(this.address(), n2);
        return this;
    }

    public XColormapEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, int n3, int n4) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.window(l4);
        this.colormap(l5);
        this.new$(n3);
        this.state(n4);
        return this;
    }

    public XColormapEvent set(XColormapEvent xColormapEvent) {
        MemoryUtil.memCopy(xColormapEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XColormapEvent malloc() {
        return new XColormapEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XColormapEvent calloc() {
        return new XColormapEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XColormapEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XColormapEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XColormapEvent create(long l2) {
        return new XColormapEvent(l2, null);
    }

    public static XColormapEvent createSafe(long l2) {
        return l2 == 0L ? null : new XColormapEvent(l2, null);
    }

    public static XColormapEvent$Buffer malloc(int n2) {
        return new XColormapEvent$Buffer(MemoryUtil.nmemAllocChecked(XColormapEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XColormapEvent$Buffer calloc(int n2) {
        return new XColormapEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XColormapEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XColormapEvent.__create(n2, SIZEOF);
        return new XColormapEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XColormapEvent$Buffer create(long l2, int n2) {
        return new XColormapEvent$Buffer(l2, n2);
    }

    public static XColormapEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XColormapEvent$Buffer(l2, n2);
    }

    public static XColormapEvent mallocStack() {
        return XColormapEvent.malloc(MemoryStack.stackGet());
    }

    public static XColormapEvent callocStack() {
        return XColormapEvent.calloc(MemoryStack.stackGet());
    }

    public static XColormapEvent mallocStack(MemoryStack memoryStack) {
        return XColormapEvent.malloc(memoryStack);
    }

    public static XColormapEvent callocStack(MemoryStack memoryStack) {
        return XColormapEvent.calloc(memoryStack);
    }

    public static XColormapEvent$Buffer mallocStack(int n2) {
        return XColormapEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XColormapEvent$Buffer callocStack(int n2) {
        return XColormapEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XColormapEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XColormapEvent.malloc(n2, memoryStack);
    }

    public static XColormapEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XColormapEvent.calloc(n2, memoryStack);
    }

    public static XColormapEvent malloc(MemoryStack memoryStack) {
        return new XColormapEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XColormapEvent calloc(MemoryStack memoryStack) {
        return new XColormapEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XColormapEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XColormapEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XColormapEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XColormapEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static long ncolormap(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)COLORMAP);
    }

    public static int nnew$(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)NEW);
    }

    public static int nstate(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)STATE);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void ncolormap(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)COLORMAP, l3);
    }

    public static void nnew$(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)NEW, n2);
    }

    public static void nstate(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)STATE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XColormapEvent.__struct(XColormapEvent.__member(4), XColormapEvent.__member(CLONG_SIZE), XColormapEvent.__member(4), XColormapEvent.__member(POINTER_SIZE), XColormapEvent.__member(CLONG_SIZE), XColormapEvent.__member(CLONG_SIZE), XColormapEvent.__member(4), XColormapEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        COLORMAP = struct$Layout.offsetof(5);
        NEW = struct$Layout.offsetof(6);
        STATE = struct$Layout.offsetof(7);
    }
}

