/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingCQE$Buffer;

public class IOURingCQE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USER_DATA;
    public static final int RES;
    public static final int FLAGS;
    public static final int BIG_CQE;

    protected IOURingCQE(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingCQE create(long l2, ByteBuffer byteBuffer) {
        return new IOURingCQE(l2, byteBuffer);
    }

    public IOURingCQE(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingCQE.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long user_data() {
        return IOURingCQE.nuser_data(this.address());
    }

    public int res() {
        return IOURingCQE.nres(this.address());
    }

    public int flags() {
        return IOURingCQE.nflags(this.address());
    }

    public LongBuffer big_cqe() {
        return IOURingCQE.nbig_cqe(this.address());
    }

    public long big_cqe(int n2) {
        return IOURingCQE.nbig_cqe(this.address(), n2);
    }

    public IOURingCQE user_data(long l2) {
        IOURingCQE.nuser_data(this.address(), l2);
        return this;
    }

    public IOURingCQE res(int n2) {
        IOURingCQE.nres(this.address(), n2);
        return this;
    }

    public IOURingCQE flags(int n2) {
        IOURingCQE.nflags(this.address(), n2);
        return this;
    }

    public IOURingCQE big_cqe(LongBuffer longBuffer) {
        IOURingCQE.nbig_cqe(this.address(), longBuffer);
        return this;
    }

    public IOURingCQE big_cqe(int n2, long l2) {
        IOURingCQE.nbig_cqe(this.address(), n2, l2);
        return this;
    }

    public IOURingCQE set(long l2, int n2, int n3, LongBuffer longBuffer) {
        this.user_data(l2);
        this.res(n2);
        this.flags(n3);
        this.big_cqe(longBuffer);
        return this;
    }

    public IOURingCQE set(IOURingCQE iOURingCQE) {
        MemoryUtil.memCopy(iOURingCQE.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingCQE malloc() {
        return new IOURingCQE(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingCQE calloc() {
        return new IOURingCQE(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingCQE create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingCQE(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingCQE create(long l2) {
        return new IOURingCQE(l2, null);
    }

    public static IOURingCQE createSafe(long l2) {
        return l2 == 0L ? null : new IOURingCQE(l2, null);
    }

    public static IOURingCQE$Buffer malloc(int n2) {
        return new IOURingCQE$Buffer(MemoryUtil.nmemAllocChecked(IOURingCQE.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingCQE$Buffer calloc(int n2) {
        return new IOURingCQE$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingCQE$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingCQE.__create(n2, SIZEOF);
        return new IOURingCQE$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingCQE$Buffer create(long l2, int n2) {
        return new IOURingCQE$Buffer(l2, n2);
    }

    public static IOURingCQE$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingCQE$Buffer(l2, n2);
    }

    public static IOURingCQE malloc(MemoryStack memoryStack) {
        return new IOURingCQE(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingCQE calloc(MemoryStack memoryStack) {
        return new IOURingCQE(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingCQE$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingCQE$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingCQE$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingCQE$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nuser_data(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)USER_DATA);
    }

    public static int nres(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RES);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static LongBuffer nbig_cqe(long l2) {
        return MemoryUtil.memLongBuffer(l2 + (long)BIG_CQE, 0);
    }

    public static long nbig_cqe(long l2, int n2) {
        return MemoryUtil.memGetLong(l2 + (long)BIG_CQE + Checks.check(n2, 0) * 8L);
    }

    public static void nuser_data(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)USER_DATA, l3);
    }

    public static void nres(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RES, n2);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void nbig_cqe(long l2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(longBuffer, 0);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(longBuffer), l2 + (long)BIG_CQE, longBuffer.remaining() * 8);
    }

    public static void nbig_cqe(long l2, int n2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)BIG_CQE + Checks.check(n2, 0) * 8L, l3);
    }

    static {
        Struct$Layout struct$Layout = IOURingCQE.__struct(IOURingCQE.__member(8), IOURingCQE.__member(4), IOURingCQE.__member(4), IOURingCQE.__array(8, 0));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        USER_DATA = struct$Layout.offsetof(0);
        RES = struct$Layout.offsetof(1);
        FLAGS = struct$Layout.offsetof(2);
        BIG_CQE = struct$Layout.offsetof(3);
    }
}

