/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.RECT$Buffer;

public class RECT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LEFT;
    public static final int TOP;
    public static final int RIGHT;
    public static final int BOTTOM;

    protected RECT(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected RECT create(long l2, ByteBuffer byteBuffer) {
        return new RECT(l2, byteBuffer);
    }

    public RECT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), RECT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int left() {
        return RECT.nleft(this.address());
    }

    public int top() {
        return RECT.ntop(this.address());
    }

    public int right() {
        return RECT.nright(this.address());
    }

    public int bottom() {
        return RECT.nbottom(this.address());
    }

    public RECT left(int n2) {
        RECT.nleft(this.address(), n2);
        return this;
    }

    public RECT top(int n2) {
        RECT.ntop(this.address(), n2);
        return this;
    }

    public RECT right(int n2) {
        RECT.nright(this.address(), n2);
        return this;
    }

    public RECT bottom(int n2) {
        RECT.nbottom(this.address(), n2);
        return this;
    }

    public RECT set(int n2, int n3, int n4, int n5) {
        this.left(n2);
        this.top(n3);
        this.right(n4);
        this.bottom(n5);
        return this;
    }

    public RECT set(RECT rECT) {
        MemoryUtil.memCopy(rECT.address(), this.address(), SIZEOF);
        return this;
    }

    public static RECT malloc() {
        return new RECT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static RECT calloc() {
        return new RECT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static RECT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new RECT(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static RECT create(long l2) {
        return new RECT(l2, null);
    }

    public static RECT createSafe(long l2) {
        return l2 == 0L ? null : new RECT(l2, null);
    }

    public static RECT$Buffer malloc(int n2) {
        return new RECT$Buffer(MemoryUtil.nmemAllocChecked(RECT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static RECT$Buffer calloc(int n2) {
        return new RECT$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static RECT$Buffer create(int n2) {
        ByteBuffer byteBuffer = RECT.__create(n2, SIZEOF);
        return new RECT$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static RECT$Buffer create(long l2, int n2) {
        return new RECT$Buffer(l2, n2);
    }

    public static RECT$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new RECT$Buffer(l2, n2);
    }

    public static RECT mallocStack() {
        return RECT.malloc(MemoryStack.stackGet());
    }

    public static RECT callocStack() {
        return RECT.calloc(MemoryStack.stackGet());
    }

    public static RECT mallocStack(MemoryStack memoryStack) {
        return RECT.malloc(memoryStack);
    }

    public static RECT callocStack(MemoryStack memoryStack) {
        return RECT.calloc(memoryStack);
    }

    public static RECT$Buffer mallocStack(int n2) {
        return RECT.malloc(n2, MemoryStack.stackGet());
    }

    public static RECT$Buffer callocStack(int n2) {
        return RECT.calloc(n2, MemoryStack.stackGet());
    }

    public static RECT$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return RECT.malloc(n2, memoryStack);
    }

    public static RECT$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return RECT.calloc(n2, memoryStack);
    }

    public static RECT malloc(MemoryStack memoryStack) {
        return new RECT(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RECT calloc(MemoryStack memoryStack) {
        return new RECT(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static RECT$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new RECT$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static RECT$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new RECT$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nleft(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)LEFT);
    }

    public static int ntop(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TOP);
    }

    public static int nright(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RIGHT);
    }

    public static int nbottom(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)BOTTOM);
    }

    public static void nleft(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)LEFT, n2);
    }

    public static void ntop(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TOP, n2);
    }

    public static void nright(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RIGHT, n2);
    }

    public static void nbottom(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)BOTTOM, n2);
    }

    static {
        Struct$Layout struct$Layout = RECT.__struct(RECT.__member(4), RECT.__member(4), RECT.__member(4), RECT.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        LEFT = struct$Layout.offsetof(0);
        TOP = struct$Layout.offsetof(1);
        RIGHT = struct$Layout.offsetof(2);
        BOTTOM = struct$Layout.offsetof(3);
    }
}

