/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component.callback;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import uk.co.caprica.vlcj.player.component.callback.CallbackImagePainter;

public class ScaledCallbackImagePainter
implements CallbackImagePainter {
    @Override
    public void prepare(Graphics2D graphics2D, JComponent jComponent) {
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    @Override
    public void paint(Graphics2D graphics2D, JComponent jComponent, BufferedImage bufferedImage) {
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        graphics2D.setColor(jComponent.getBackground());
        graphics2D.fillRect(0, 0, n2, n3);
        if (bufferedImage != null) {
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            float f2 = (float)n2 / (float)n4;
            float f3 = (float)n3 / (float)n5;
            float f4 = Math.min(f2, f3);
            float f5 = (float)n4 * f4;
            float f6 = (float)n5 * f4;
            graphics2D.translate(((float)n2 - f5) / 2.0f, ((float)n3 - f6) / 2.0f);
            if ((double)f4 != 1.0) {
                graphics2D.scale(f4, f4);
            }
            graphics2D.drawImage(bufferedImage, null, 0, 0);
        }
    }
}

