/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.AppSettings;
import emulator.Emulator;
import emulator.debug.Profiler3D;
import emulator.graphics3D.IGraphics3D;
import emulator.graphics3D.m3g.CameraCache;
import emulator.graphics3D.m3g.LightsCache;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class Graphics3D {
    public static final int ANTIALIAS = 2;
    public static final int DITHER = 4;
    public static final int OVERWRITE = 16;
    public static final int TRUE_COLOR = 8;
    private static Object target = null;
    private static IGraphics3D impl;
    private static Graphics3D inst;
    private int viewportX;
    private int viewportY;
    private int viewportWidth;
    private int viewportHeight;
    private float depthRangeNear;
    private float depthRangeFar;
    private Image2D tempBgImage;

    private Graphics3D() {
        impl = Emulator.getGraphics3D();
        this.depthRangeNear = 0.0f;
        this.depthRangeFar = 1.0f;
    }

    public static final Graphics3D getInstance() {
        return inst;
    }

    public static final IGraphics3D getImpl() {
        return impl;
    }

    public static final Hashtable getProperties() {
        return impl.getProperties();
    }

    public void bindTarget(Object target) {
        this.bindTarget(target, true, 0);
    }

    public void bindTarget(Object target, boolean depthBuffer, int hints) {
        impl.enableDepthBuffer(depthBuffer);
        if (Graphics3D.target != null) {
            throw new IllegalStateException("Target already bound");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (hints != 0 && (hints & 0x1E) == 0) {
            throw new IllegalArgumentException("hints");
        }
        boolean overwrite = !AppSettings.m3gIgnoreOverwrite && (hints & 0x10) != 0;
        Background bck = new Background();
        bck.setColorClearEnable(!overwrite);
        bck.setDepthClearEnable(depthBuffer);
        if (target instanceof Graphics) {
            Graphics g = (Graphics)target;
            int targetW = g.getImage().getWidth();
            int targetH = g.getImage().getHeight();
            if (targetW > 2048 || targetH > 2048) {
                throw new IllegalArgumentException();
            }
            Graphics3D.target = target;
            impl.bindTarget((Object)g);
            this.setViewport(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
            if (!overwrite) {
                if (this.tempBgImage == null || this.tempBgImage.getWidth() != targetW || this.tempBgImage.getHeight() != targetH) {
                    this.tempBgImage = new Image2D(99, new Image(g.getImage()));
                }
                this.tempBgImage.setRGB(g.getImage());
                bck.setImage(this.tempBgImage);
                bck.setCrop(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
            }
        } else if (target instanceof Image2D) {
            Image2D img2d = (Image2D)target;
            int targetW = img2d.getWidth();
            int targetH = img2d.getHeight();
            if (targetW > 2048 || targetH > 2048) {
                throw new IllegalArgumentException();
            }
            int imageFormat = img2d.getFormat();
            if (!img2d.isMutable() || imageFormat != 99 && imageFormat != 100) {
                throw new IllegalArgumentException();
            }
            Graphics3D.target = target;
            impl.bindTarget((Object)img2d);
            this.setViewport(0, 0, targetW, targetH);
            if (!overwrite) {
                bck.setImage(img2d);
                bck.setCrop(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
            }
        } else {
            throw new IllegalArgumentException("Unsupported target type");
        }
        if (Graphics3D.target != null) {
            impl.setHints(hints);
            this.setDepthRange(this.depthRangeNear, this.depthRangeFar);
            this.clear(bck);
        }
    }

    public void releaseTarget() {
        if (target != null) {
            impl.releaseTarget();
            target = null;
        }
    }

    public Object getTarget() {
        return target;
    }

    public int getHints() {
        return impl.getHints();
    }

    public boolean isDepthBufferEnabled() {
        return impl.isDepthBufferEnabled();
    }

    public void setViewport(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0 || width > 2048 || height > 2048) {
            throw new IllegalArgumentException();
        }
        this.viewportX = x;
        this.viewportY = y;
        this.viewportWidth = width;
        this.viewportHeight = height;
        impl.setViewport(x, y, width, height);
    }

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    public int getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportHeight() {
        return this.viewportHeight;
    }

    public void setDepthRange(float near, float far) {
        if (!(near >= 0.0f && near <= 1.0f && far >= 0.0f && far <= 1.0f)) {
            throw new IllegalArgumentException();
        }
        this.depthRangeNear = near;
        this.depthRangeFar = far;
        impl.setDepthRange(near, far);
    }

    public float getDepthRangeNear() {
        return this.depthRangeNear;
    }

    public float getDepthRangeFar() {
        return this.depthRangeFar;
    }

    public void clear(Background background) {
        if (target == null) {
            throw new IllegalStateException();
        }
        impl.clearBackgound((Object)background);
    }

    public void render(World world) {
        ++Profiler3D.M3G_renderWorldCallCount;
        if (world == null) {
            throw new NullPointerException();
        }
        if (target == null || world.getActiveCamera() == null || !world.getActiveCamera().isDescendantOf(world)) {
            throw new IllegalStateException();
        }
        impl.render(world);
    }

    public void render(Node node, Transform transform) {
        ++Profiler3D.M3G_renderNodeCallCount;
        if (node == null) {
            throw new NullPointerException();
        }
        if (!(node instanceof Sprite3D || node instanceof Mesh || node instanceof Group)) {
            throw new IllegalArgumentException();
        }
        if (target == null || CameraCache.camera == null) {
            throw new IllegalStateException();
        }
        impl.render(node, transform);
    }

    public void render(VertexBuffer vertices, IndexBuffer triangles, Appearance appearance, Transform transform, int scope) {
        ++Profiler3D.M3G_renderVertexCallCount;
        if (vertices != null && triangles != null && appearance != null) {
            if (target == null || CameraCache.camera == null) {
                throw new IllegalStateException();
            }
        } else {
            throw new NullPointerException();
        }
        impl.render(vertices, triangles, appearance, transform, scope);
    }

    public void render(VertexBuffer vertices, IndexBuffer triangles, Appearance appearance, Transform transform) {
        this.render(vertices, triangles, appearance, transform, -1);
    }

    public void setCamera(Camera camera, Transform transform) {
        CameraCache.setCamera((Camera)camera, (Transform)transform);
    }

    public Camera getCamera(Transform transform) {
        return CameraCache.getCamera((Transform)transform);
    }

    public int addLight(Light light, Transform transform) {
        return LightsCache.addLight((Light)light, (Transform)transform);
    }

    public void setLight(int index, Light light, Transform transform) {
        LightsCache.setLight((int)index, (Light)light, (Transform)transform);
    }

    public void resetLights() {
        LightsCache.resetLights();
    }

    public int getLightCount() {
        return LightsCache.getLightCount();
    }

    public Light getLight(int index, Transform transform) {
        return LightsCache.getLight((int)index, (Transform)transform);
    }

    static {
        inst = new Graphics3D();
    }
}

