/*
 * Decompiled with CFR 0.152.
 */
package org.pigler.api;

import com.nokia.mid.ui.DirectUtils;
import com.nokia.mj.impl.rt.legacy.LegacyRtPort;
import com.nokia.mj.impl.rt.legacy.MIDEventServer;
import com.nokia.mj.impl.rt.legacy.ToolkitInvoker;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import javax.microedition.lcdui.Image;
import org.pigler.api.IPiglerTapHandler;
import org.pigler.api.ImageUtils;
import org.pigler.api.PiglerException;

public final class PiglerAPI {
    public static final int DiscreetPopupDurationLong = 1;
    public static final int DiscreetPopupLightsOn = 2;
    public static final int DiscreetPopupConfirmationTone = 4;
    public static final int DiscreetPopupWarningTone = 8;
    public static final int DiscreetPopupErrorTone = 16;
    private static final MIDEventServer eventServer;
    private Finalizer finalizer = this.registerFinalize();
    private int eventSourceHandle = this._createEventSource(eventServer.getHandle());
    private int apiHandle = this._createAPI(this.eventSourceHandle);
    private boolean closed;
    private IPiglerTapHandler listener;
    private boolean initialized;
    private String appName;
    private boolean isBelle;
    private int bitmapSize;

    static {
        try {
            Jvm.loadSystemLibrary((String)"piglerjavaapi");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        eventServer = new MIDEventServer("java-piglerapi");
    }

    public PiglerAPI() {
        String s = System.getProperty("microedition.platform");
        boolean bl = this.isBelle = s != null && s.charAt(s.indexOf("platform_version=") + 19) > '2';
        if (!this.isBelle) {
            this._startAnnaServer(this.eventSourceHandle, this.apiHandle);
        }
    }

    public int init() throws Exception {
        String appName;
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.appName = appName = "JavaApp_" + Integer.toHexString(LegacyRtPort.getMidletUid());
        int res = this._init(this.eventSourceHandle, this.apiHandle, LegacyRtPort.getMidletUid(), appName);
        if (res < 0) {
            throw new PiglerException("Init error: " + res);
        }
        this.initialized = true;
        return res;
    }

    public int init(String appName) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (appName == null) {
            throw new NullPointerException("appName");
        }
        if (appName.length() == 0) {
            throw new IllegalArgumentException("appName");
        }
        if (appName.length() > 63) {
            appName = appName.substring(0, 63);
        }
        this.appName = appName;
        int res = this._init(this.eventSourceHandle, this.apiHandle, LegacyRtPort.getMidletUid(), appName);
        if (res < 0) {
            throw new PiglerException("Init error: " + res);
        }
        this.initialized = true;
        return res;
    }

    public int getAPIVersion() throws Exception {
        this.checkClosed();
        return this._getAPIVersion(this.eventSourceHandle, this.apiHandle);
    }

    public int createNotification(String title, String text, Image icon, boolean removeOnTap) throws Exception {
        this.checkClosed();
        int res = this._setNotification(this.eventSourceHandle, this.apiHandle, 0, this.formatText(title, text));
        if (res < 0) {
            if (res == -9) {
                throw new PiglerException("No more notification slots left");
            }
            throw new PiglerException("Create notification error: " + res);
        }
        this._setRemoveNotificationOnTap(this.eventSourceHandle, this.apiHandle, 0, removeOnTap);
        if (icon != null) {
            this.setNotificationIcon(res, icon);
        }
        return res;
    }

    public void updateNotification(int uid, String title, String text, Image icon) throws Exception {
        this.updateNotification(uid, title, text);
        this.updateNotification(uid, icon);
    }

    public void updateNotification(int uid, String title, String text) throws Exception {
        if (uid <= 0) {
            throw new IllegalArgumentException();
        }
        this.checkClosed();
        int res = this._setNotification(this.eventSourceHandle, this.apiHandle, uid, this.formatText(title, text));
        if (res < 0) {
            throw new PiglerException("Update notification text error:" + res);
        }
    }

    public void updateNotification(int uid, Image icon) throws Exception {
        if (uid <= 0) {
            throw new IllegalArgumentException();
        }
        this.checkClosed();
        if (icon == null) {
            throw new NullPointerException("icon");
        }
        int res = this.setNotificationIcon(uid, icon);
        if (res < 0) {
            throw new PiglerException("Update notification icon error: " + res);
        }
    }

    public void removeNotification(int uid) throws Exception {
        this.checkClosed();
        int res = this._removeNotification(this.eventSourceHandle, this.apiHandle, uid);
        if (res < 0) {
            throw new PiglerException("Remove notification error: " + res);
        }
    }

    public int removeAllNotifications() {
        this.checkClosed();
        return this._removeAllNotifications(this.eventSourceHandle, this.apiHandle);
    }

    public int getLastTappedNotification() {
        this.checkClosed();
        return this._getLastTappedNotification(this.eventSourceHandle, this.apiHandle);
    }

    public void setRemoveNotificationOnTap(int uid, boolean remove) throws Exception {
        this.checkClosed();
        int res = this._setRemoveNotificationOnTap(this.eventSourceHandle, this.apiHandle, uid, remove);
        if (res < 0) {
            throw new PiglerException("Update notification error: " + res);
        }
    }

    public void setLaunchAppOnTap(int uid, boolean launch) throws Exception {
        this.checkClosed();
        int res = this._setLaunchAppOnTap(this.eventSourceHandle, this.apiHandle, uid, launch);
        if (res < 0) {
            throw new PiglerException("Update notification error: " + res);
        }
    }

    public void setListener(IPiglerTapHandler listener) {
        this.listener = listener;
    }

    public void close() {
        if (this.closed || this.apiHandle == 0) {
            return;
        }
        this.closed = true;
        this._close(this.eventSourceHandle, this.apiHandle);
    }

    public String getAppName() {
        return this.appName;
    }

    public int getMaxNotificationsCount() {
        if (this.apiHandle == 0 || !this.initialized) {
            return -1;
        }
        int r = this._getMaxNotificationsCount(this.eventSourceHandle, this.apiHandle);
        return r < 0 ? (this.isBelle ? 100 : r) : r;
    }

    public int getNotificationsCount() throws Exception {
        this.checkClosed();
        return this._getNotificationsCount(this.eventSourceHandle, this.apiHandle);
    }

    public int getGlobalNotificationsCount() throws Exception {
        this.checkClosed();
        int r = this._getGlobalNotificationsCount(this.eventSourceHandle, this.apiHandle);
        return r;
    }

    public boolean isSingleLine() {
        return !this.isBelle;
    }

    public int getIconSize() {
        return this.isBelle ? 52 : 28;
    }

    public void showGlobalPopup(String title, String text, int flags) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (text == null) {
            text = "";
        }
        if ((flags & 0xFFFFFFE0) != 0) {
            throw new IllegalArgumentException("flags");
        }
        ToolkitInvoker inv = ToolkitInvoker.getToolkitInvoker();
        int res = this._showGlobalDiscreetPopup(this.eventSourceHandle, inv.toolkitGetHandle(inv.getToolkit()), title, text, flags, LegacyRtPort.getMidletUid());
        if (res < 0) {
            throw new PiglerException("showGlobalPopup error: " + res);
        }
    }

    private void checkClosed() {
        if (!this.initialized || this.closed || this.apiHandle == 0) {
            throw new IllegalStateException();
        }
    }

    private void notificationCallback(int uid) {
        if (this.listener != null) {
            this.listener.handleNotificationTap(uid);
        }
    }

    private String formatText(String title, String text) {
        if (title == null) {
            title = "";
        }
        if (text == null) {
            text = "";
        }
        if (title.length() > 63) {
            title = title.substring(0, 63);
        }
        if (text.length() > 63) {
            text = text.substring(0, 63);
        }
        if (!this.isBelle) {
            if (text.length() > 0) {
                title = String.valueOf(title) + " " + text;
            }
            title = title.trim();
        } else if (text.length() > 0) {
            title = String.valueOf(title) + "\n" + text;
        }
        if (title.length() == 0) {
            throw new IllegalArgumentException();
        }
        return title;
    }

    private int setNotificationIcon(int uid, Image icon) {
        int size;
        if (icon == null) {
            return 0;
        }
        int n = size = this.bitmapSize != 0 ? this.bitmapSize : (this.bitmapSize = this._getBitmapSize(this.eventSourceHandle, this.apiHandle));
        if (size == 0) {
            return 0;
        }
        if (size < 0) {
            size = 68;
        }
        Image scaledIcon = DirectUtils.createImage((int)size, (int)size, (int)0);
        int targetSize = this.getIconSize();
        int w = icon.getWidth();
        int h = icon.getHeight();
        if (w > targetSize || h > targetSize) {
            icon = w > h ? ImageUtils.resize(icon, targetSize, targetSize * h / w) : ImageUtils.resize(icon, targetSize * w / h, targetSize);
        }
        scaledIcon.getGraphics().drawImage(icon, size - icon.getWidth() >> 1, size - icon.getHeight() >> 1, 20);
        icon = null;
        int[] rgb = new int[size * size];
        scaledIcon.getRGB(rgb, 0, size, 0, 0, size, size);
        return this._setNotificationIcon(this.eventSourceHandle, this.apiHandle, uid, rgb);
    }

    private Finalizer registerFinalize() {
        return new Finalizer(){

            public void finalizeImpl() {
                PiglerAPI.this.close();
                PiglerAPI.this._dispose(PiglerAPI.this.eventSourceHandle, PiglerAPI.this.apiHandle);
                PiglerAPI.this.apiHandle = 0;
                PiglerAPI.this.eventSourceHandle = 0;
            }
        };
    }

    private native int _createEventSource(int var1);

    private native int _createAPI(int var1);

    private native void _dispose(int var1, int var2);

    private native int _initRandom(int var1, int var2, int var3);

    private native int _init(int var1, int var2, int var3, String var4);

    private native int _setNotification(int var1, int var2, int var3, String var4);

    private native int _removeNotification(int var1, int var2, int var3);

    private native int _removeAllNotifications(int var1, int var2);

    private native int _getLastTappedNotification(int var1, int var2);

    private native int _setRemoveNotificationOnTap(int var1, int var2, int var3, boolean var4);

    private native int _setNotificationIcon(int var1, int var2, int var3, int[] var4);

    private native void _close(int var1, int var2);

    private native int _getAPIVersion(int var1, int var2);

    private native int _setLaunchAppOnTap(int var1, int var2, int var3, boolean var4);

    private native int _getNotificationsCount(int var1, int var2);

    private native int _getMaxNotificationsCount(int var1, int var2);

    private native int _getGlobalNotificationsCount(int var1, int var2);

    private native int _getBitmapSize(int var1, int var2);

    private native int _startAnnaServer(int var1, int var2);

    private native int _showGlobalDiscreetPopup(int var1, int var2, String var3, String var4, int var5, int var6);
}

